/*
 * xepdmgrtest.c
 *
 * Test of xepdmgrclient; sends some strings to server and exits.
 *
 * History:
 *       4/09/2008 DRF Initial implementation.
 *       7/09/2008 DRF Add parameter support.
 *      25/04/2009 DRF Add EpdCancel().
 *
 * Authors: DRF Dario Rodriguez dario@softhome.net
 * (c) 2008 Dario Rodriguez
 * This program is licensed under the terms of the GNU LGPL v3 or greater.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "xepdmgrclient.h"

int
main(int argc, char *argv[])
{
        sEpd *Epd;
        int i;
        char *cmd;
        if(argc>1 && strcmp(argv[argc-1],"--help")==0) {
                printf("Syntax: %s [ { flush | cancel | full | typing | auto0 | auto1 } [...]] [--help]\n",argv[0]);
                return(0);
        }
        if((Epd=EpdInit(NULL))==NULL) {
                printf("ERROR: Initialization of communications failed\n");
                return(1);
        }
        if(argc==1) {
                EpdFlush(Epd);
                EpdCancel(Epd);
                EpdRefreshFull(Epd);
                EpdRefreshTyping(Epd);
                EpdRefreshAuto(Epd,0);
                EpdRefreshAuto(Epd,1);
        } else {
                for(i=1;i<argc;i++) {
                        cmd=argv[i];
                        if(strcmp(cmd,"flush")==0) {
                                EpdFlush(Epd);
                        } else if(strcmp(cmd,"cancel")==0) {
                                EpdCancel(Epd);
                        } else if(strcmp(cmd,"full")==0) {
                                EpdRefreshFull(Epd);
                        } else if(strcmp(cmd,"typing")==0) {
                                EpdRefreshTyping(Epd);
                        } else if(strcmp(cmd,"auto0")==0) {
                                EpdRefreshAuto(Epd,0);
                        } else if(strcmp(cmd,"auto1")==0) {
                                EpdRefreshAuto(Epd,1);
                        } else {
                                printf("WARNING: Command \"%s\" not recognized. Use --help for a list of supported commands.\n",cmd);
                        }
                }
        }
        EpdFini(Epd);
        return(0);
}

