/*
 * xepdmgrclient.h
 *
 * Implements communications with xepdmgr using X atoms/properties.
 *
 * Header file.
 *
 * History:
 *       4/09/2008 DRF Initial implementation.
 *      25/04/2009 DRF Add EpdCancel().
 *
 * Authors: DRF Dario Rodriguez dario@softhome.net
 * (c) 2008 Dario Rodriguez
 * This program is licensed under the terms of the GNU LGPL v3 or greater.
 */

typedef void sEpd;

#ifdef __cplusplus
extern "C" {
#endif

sEpd *EpdInit(char *Display); /* Display==NULL for default display */
void EpdFini(sEpd *Epd);

int EpdFlush(sEpd *Epd); /* cancel timeouts, do now any pending refresh */
int EpdCancel(sEpd *Epd); /* cancel timeouts, forget pending refreshes */
int EpdRefreshFull(sEpd *Epd);
int EpdRefreshTyping(sEpd *Epd);
int EpdRefreshAuto(sEpd *Epd,int Enabled); /* Default is Enabled==1 */


#ifdef __cplusplus
};
#endif
