import java.awt.Button;
import java.awt.Color;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.GridLayout;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import com.irex.sdk.DisplayUpdate;

public class Calculator extends Frame implements ActionListener {

    String operand = "";
    char operation = ' ';

    Button button1 = new Button("1");
    Button button2 = new Button("2");
    Button button3 = new Button("3");
    Button button4 = new Button("4");
    Button button5 = new Button("5");
    Button button6 = new Button("6");
    Button button7 = new Button("7");
    Button button8 = new Button("8");
    Button button9 = new Button("9");
    Button button0 = new Button("0");
    Button buttonPeriod = new Button(".");
    Button buttonMultiply = new Button("X");
    Button buttonDivide = new Button("/");
    Button buttonAdd = new Button("+");
    Button buttonSubtract = new Button("-");
    Button buttonEquals = new Button("=");
    Button buttonQuit = new Button("Off");

    Panel body = new Panel(new GridLayout(2, 1));
    Panel keypad = new Panel(new GridLayout(0, 4));

    TextField textField = new TextField(30);

    public Calculator() {
	setSize(768, 935);

	setLayout(new FlowLayout());
	//setLayout(new CardLayout());

	button1.setActionCommand("1");
	button1.addActionListener(this);
	button2.setActionCommand("2");
	button2.addActionListener(this);
	button3.setActionCommand("3");
	button3.addActionListener(this);
	button4.setActionCommand("4");
	button4.addActionListener(this);
	button5.setActionCommand("5");
	button5.addActionListener(this);
	button6.setActionCommand("6");
	button6.addActionListener(this);
	button7.setActionCommand("7");
	button7.addActionListener(this);
	button8.setActionCommand("8");
	button8.addActionListener(this);
	button9.setActionCommand("9");
	button9.addActionListener(this);
	button0.setActionCommand("0");
	button0.addActionListener(this);
	buttonPeriod.setActionCommand(".");
	buttonPeriod.addActionListener(this);
	buttonMultiply.setActionCommand("X");
	buttonMultiply.addActionListener(this);
	buttonDivide.setActionCommand("/");
	buttonDivide.addActionListener(this);
	buttonAdd.setActionCommand("+");
	buttonAdd.addActionListener(this);
	buttonSubtract.setActionCommand("-");
	buttonSubtract.addActionListener(this);
	buttonEquals.setActionCommand("=");
	buttonEquals.addActionListener(this);
	buttonQuit.setActionCommand("CLOSE");
	buttonQuit.addActionListener(this);

	body.setBounds( 10, 0, 400, 400);

	keypad.setBounds( 10, 0, 400, 400);

	keypad.add(button7);
	keypad.add(button8);
	keypad.add(button9);
	keypad.add(buttonMultiply);

	keypad.add(button4);
	keypad.add(button5);
	keypad.add(button6);
	keypad.add(buttonDivide);

	keypad.add(button1);
	keypad.add(button2);
	keypad.add(button3);
	keypad.add(buttonAdd);

	keypad.add(button0);
	keypad.add(buttonPeriod);
	keypad.add(buttonEquals);
	keypad.add(buttonSubtract);

	keypad.add(buttonQuit);

	body.add(textField);
	body.add(keypad);
	add(body);
	//	pack();

	// Make us the target for events
	requestFocus();

	setVisible(true);
	DisplayUpdate.dispMainWinFullQ();
    }

    public void actionPerformed(ActionEvent e) {
	String command = e.getActionCommand();
	System.out.println("Got command: " + command);
	if (command.length() == 1) {
	    char c = command.charAt(0);
	    switch (c) {
	    case '=':
		try {
		    double result = 0;
		    double d1 = Double.parseDouble(operand);
		    double d2 = Double.parseDouble(textField.getText());
		    switch (operation) {
		    case 'X':
			result = d1 * d2;
			break;
		    case '/':
			result = d1 / d2;
			break;
		    case '+':
			result = d1 + d2;
			break;
		    case '-':
			result = d1 - d2;
			break;
		    }
		    textField.setText(String.valueOf(result));
		    textField.repaint();
		    DisplayUpdate.dispMainWinFullQ();
		} catch (NumberFormatException nfe) {
		}
		break;
	    case 'X':
	    case '/':
	    case '+':
	    case '-':
		operand = textField.getText();
		operation = c;
		textField.setText("");
		textField.repaint();
		DisplayUpdate.dispMainWinFullQ();
		break;
	    case '0':
	    case '1':
	    case '2':
	    case '3':
	    case '4':
	    case '5':
	    case '6':
	    case '7':
	    case '8':
	    case '9':
	    case '.':
		textField.setText(textField.getText() + c); 
		textField.repaint();
		DisplayUpdate.dispMainWinFullQ();
		break;
	    }
	} else if (command.equals("CLOSE")) {
	    System.exit(0);
	}
    }

    public static void main(String[] args) {
	Calculator test = new Calculator();
    }


}
