# -*- coding: cp1251 -*-
""" russianbook.py -- create a book with cyrillic author, title, and text """

# Note: Cyrillic title and author does not show up in list of books unless
#       the reader fonts are changed.  This program embeds the arial font
#       in order to get access to a cyrilic font for the text.

from pylrs.pylrs import *

FALSTAFF_S = ""
FALSTAFF_U = u''
BOOK_TITLE = "  "


def russianbook():
    # create the book
    book = Book(author=FALSTAFF_S, title=BOOK_TITLE, sourceencoding="cp1251")

    # add a font with all the characters we need    
    book.Font("c:/windows/fonts/arial.ttf", "Arial")
    
    # add a page to the book using the default page style
    page = book.Page()

    # add a textblock to the page using defaults for BlockStyle 
    textBlock = page.TextBlock(TextStyle(fontfacename="Arial"))

    # add a paragraph to the text block 
    p = textBlock.Paragraph()
    p.append(FALSTAFF_U)
    p.append(': ' + BOOK_TITLE + '.')
    p.CR()
    p.append(FALSTAFF_S + ": " + BOOK_TITLE + ".")

    # generate the lrf and file
    book.renderLrf("books/russianbook.lrf")
    book.renderLrs("books/russianbook.lrs")


if __name__ == "__main__":
    russianbook()
