""" formatting.py -- a collection of various formatting examples """

from pylrs.pylrs import *

COVER = "cover.jpeg"
THUMBNAIL = "thumbnail.gif"

# a new class that applies some built-in span items
class LittleText(Span):
    def __init__(self, text=None):
        Span.__init__(self, text, fontsize=50)

# a new class that makes little italics (more complicated, but possible)
class LittleItalic(Italic):
    tagName = "Italic" # need to override the tag and element name
    def __init__(self, text=None):
        Italic.__init__(self, text)

    def append(self, content):
        Italic.append(self, Span(content, fontsize=50))


def formatting():
    b = Book(title="Formatting Example",
            author=("Some Writer", "Writer, Some"),
            bookid="FB0123456", isbn="123-0-1234-5678-9",
            publisher="Self Published", thumbnail=THUMBNAIL,
            category="Fiction")

    ps = PageStyle()
    ts = TextStyle()
    bs = BlockStyle()
    
    tocPage = b.Page(ps)
    tocTb = TextBlock(ts, bs)
    tocPage.append(tocTb)
    b.addTocEntry("Table of Contents", tocTb)

    # adding a cover page
    imageStream = ImageStream(COVER)
    page = b.Page(PageStyle(evensidemargin=0, oddsidemargin=0, topmargin=0))
    page.ImageBlock(refstream=imageStream)
    
    # explicit appending
    p = Page()
    b.append(p)
    tb =TextBlock()
    p.append(tb)

    b.addTocEntry("Begin Reading", tb)
    tb.append(Paragraph("Beginning of the text"))
    tb.append(CR())

    p.append(BlockSpace(yspace=50))
    p.append(RuledLine())
    
    tb2 = TextBlock(ts, bs)
    p.append(tb2)
    tocTb.append(Paragraph(CharButton(b.JumpButton(tb), "Line 2")))

    tb2.append(Paragraph("Line 2")) # no automatic CR after para
    
    para = Paragraph()
    tb2.append(para)
    para.append("hello")
    para.append(" ")
    para.append("there")
    
    p2 = Paragraph()
    tb2.append(p2)
    p2.append("before CR")
    p2.append(CR())
    p2.append("after CR")


    # italics and span
    p3 = Paragraph()
    tb2.append(CR())
    tb2.append(p3)
    p3.append(Italic("This is in italics,"))
    p3.append(" (I hope.)")
    p3.append(CR())
    p3.append(Span("T", fontsize=300)).append("his is strange.").append(CR())


    # hanging indent
    hiTextStyle = TextStyle(parindent=-900, parskip=200)
    hiBlockStyle = BlockStyle(sidemargin=30)
    hiTb = p.TextBlock(hiTextStyle, hiBlockStyle)
    p4 =Paragraph()
    hiTb.append(p4)
    p4.append("this is first line").append(CR()).append("second line")
    hiTb.append(Paragraph("another para (no cr in tb)"))
    hiTb.append(CR())
    p5 = Paragraph()
    hiTb.append(p5)
    p5.append("this is a long line that should wrap by iteself so that " +
            "there can be a test of the hanging indent style applied to the " +
            "textstyle and the blockstyle")
    hiTb.append(CR())
    p6 = Paragraph()
    hiTb.append(p6)
    p6.append("This is another long paragraph that hopefully should " +
            "wrap around as well. This one contains a single space between " +
            "the two sentences. There is a single CR between the two " +
            "paragraphs an no internal CR's in either paragraph." +
            "YES .. This is another long paragraph that hopefully should " +
            "wrap around as well. This one contains a single space between " +
            "the two sentences. There is a single CR between the two " +
            "paragraphs an no internal CR's in either paragraph." +
            "YES YES  This is another long paragraph that hopefully should " +
            "wrap around as well. This one contains a single space between " +
            "the two sentences. There is a single CR between the two " +
            "paragraphs an no internal CR's in either paragraph.")
   

    # Bold and Italic
    page = b.Page(ps)
    tb = page.TextBlock(ts, bs)
    p = tb.Paragraph()
    it = Italic()
    p.append(it)
    it.append("hello")
    it.append(Bold(" there"))   

    # use our own formatting classes
    page = b.Page()
    tb = page.TextBlock()
    para = tb.Paragraph()
    para.append("Normal ")
    para.append(LittleText("little"))
    para.append(" Big Again ")
    para.append(LittleItalic("little and italic"))
    tb.append(CR())
    tb = page.TextBlock()
    para = tb.Paragraph()
    # box does not do anything (or it's broken)
    box = Box(linetype="double")
    para.append(box)
    box.append("Normal ")
    box.append(" Big Again ")


    b.renderLrf("/Users/bubien/Desktop/formatting.lrf")


if __name__ == "__main__":
    formatting()
