/* Emacs -*-C-*- Mode */
#ifndef _UNICHECK_C_
#define _UNICHECK_C_

#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>

#if defined(__cplusplus) || defined(c_plusplus)
extern "C"
{
#endif

/************************************************************
 * main()													*
 *															*
 ************************************************************/
int
main(int argc, char **argv)
{
	unsigned char	c;
	char			*file;
	int				fd;
	int				line;
	int				ccnt;
	int				allclear = 1;

	if (argc != 2)
	{
		fprintf(stderr, "Usage: %s <file>\n", argv[0]);
		exit (1);
	}

	file = argv[1];
	fd = open(file, O_RDONLY);
	if (fd < 0)
	{
		fprintf(stderr, "Could not open file: %s\n", file);
		exit (1);
	}

	line = 1;
	ccnt  = 1;
	while (read(fd, &c, 1) > 0)
	{
		if (c == '\n')
		{
			line++;
			ccnt = 1;
		}

		if (c >= 128)
		{
			allclear = 0;
			printf("Out of range at line %d, character %d\n", line, ccnt);
		}
		ccnt++;
	}
	if (allclear)
		printf("All Clear.\n");
}

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* _UNICHECK_C_ */

