from pylrs.pylrs import *

"""
    An example book showing the creation of multiple pages and a table
    of contents.
    
    The style of books from Sony is to create a book table of contents
    with only four things in it, one of which is a page of CharButtons that
    jump to various parts of the book.  This inner table of contents is kept
    in it's own page tree.  That style is used in this example.
"""

def createCover(book):
    pass


def createChapter(chapter, tocTb, book, titleTs, footnoteTs):
    chapterTitle = "Chapter %d" % chapter

    # make a  chapter heading
    page = book.Page()
    tb = page.TextBlock(titleTs)
    tb.Paragraph(chapterTitle)
    page.RuledLine()

    # if this is the first chapter, add it to the main toc
    if chapter == 1:
        book.addTocEntry("Begin Reading", tb)

    # add the chapter to the "inner" table of contents
    
    tocTb.Paragraph(CharButton(JumpButton(tb), chapterTitle))

    # now, add some contents

    tb = page.TextBlock()
    p = tb.Paragraph()
    p.append("Day %d of my life was fairly dull." % chapter)

    if chapter == 2:
        footNote = TextBlock(footnoteTs)
        p.append(CharButton(JumpButton(footNote), Sup("1")))

    p.append(" Mostly, I slept.")

    if chapter == 2:
        page.BlockSpace(y=50)
        page.append(footNote)
        fp = footNote.Paragraph()
        fp.append(Sup("1")).append("I apparently did meet my grandparents.")



def autobiography():
    # some handy text styles
    titleTs = TextStyle(fontsize=200, fontweight=800)
    footnoteTs = TextStyle(fontsize=80)

    book = Book(title="My Autobiography",
            author=("Alec Writer", "Writer, Alec"))
    
    # Table of Contents Page
    solo = book.Solo()
    tocPage = solo.Page()
    tocTb = tocPage.TextBlock(titleTs)
    book.addTocEntry("Table of Contents", tocTb)    
    tocTb = tocPage.TextBlock()
    tocTb.Paragraph("Table of Contents")

    copyrightPage = book.Page()
    copyrightTb = copyrightPage.TextBlock(titleTs)
    copyrightTb.Paragraph("Copyright Notice")
    copyrightTb = copyrightPage.TextBlock()
    copyrightTb.Paragraph("This book is not copyrighted.")
    book.addTocEntry("Copyright Notice", copyrightTb)

    # now, add some exciting content

 
    for chapter in range(1, 5):
        createChapter(chapter, tocTb, book, titleTs, footnoteTs)
    
    
    # finally, stick an about page on
    aboutPage = book.Page()
    aboutTb = aboutPage.TextBlock()
    book.addTocEntry("About this Book", aboutTb) 
    
    aboutTb.Paragraph("About this book, I don't know.")
    p = aboutTb.Paragraph()
    p.append("No, I ").append(Italic("really")).append(" don't know.")

    # finished, render it

    book.renderLrf("books/autobiography.lrf")
    book.renderLrs("books/autobiography.lrs")

if __name__ == "__main__":
    autobiography()


