/*
 * Decompiled with CFR 0.152.
 */
package com.scotty1024.iliadviewer.cbzviewer;

import com.irex.mobipocket.reader.Utils;
import com.irex.sdk.DisplayUpdate;
import com.irex.sdk.ErIpcCmd;
import com.irex.sdk.ErIpcServer;
import com.irex.sdk.ErPageBar;
import com.irex.sdk.IpcServerCallBack;
import com.irex.sdk.ViewerSignal;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ImageObserver;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.DatagramPacket;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.kxml2.io.KXmlParser;

public class CBZViewer
extends Frame
implements IpcServerCallBack,
KeyListener,
MouseListener,
WindowListener,
ImageObserver {
    private ErIpcServer m_ersrv;
    private ErPageBar pagebar;
    private int IREX_READER_UA_ID = 110;
    protected ZipFile zFile = null;
    protected ArrayList zEntries = null;
    protected byte[] zBuffer = new byte[32768];
    protected int curPage = -1;
    protected Image screenImage = null;
    protected String settingsName = null;

    public static void main(String[] stringArray) throws Exception {
        CBZViewer cBZViewer = new CBZViewer(stringArray[0]);
    }

    public CBZViewer(String string) throws Exception {
        long l = System.currentTimeMillis();
        System.out.println("url: " + string);
        this.settingsName = string.substring(0, string.length() - 3) + "mbp";
        System.out.println("Settings name: " + this.settingsName);
        this.loadSettings();
        this.zFile = new ZipFile(string);
        TreeSet<String> treeSet = new TreeSet<String>();
        Object object = this.zFile.entries();
        while (object.hasMoreElements()) {
            treeSet.add(object.nextElement().getName());
        }
        this.zEntries = new ArrayList(this.zFile.size());
        object = treeSet.iterator();
        while (object.hasNext()) {
            this.zEntries.add(this.zFile.getEntry((String)object.next()));
        }
        treeSet.clear();
        treeSet = null;
        ((Component)this).setSize(768, 935);
        this.m_ersrv = ErIpcServer.getInstanceByChannelId((int)15, (IpcServerCallBack)this);
        if (this.m_ersrv == null) {
            System.out.print("Opening connection to ErIpcServer failed.");
            throw new Exception("Couldn't connect to ErIpcServer.");
        }
        this.m_ersrv.startServer();
        this.pagebar = ErPageBar.getInstance();
        if (this.pagebar == null) {
            System.out.println("pagebar client create error");
            System.exit(1);
        } else {
            this.pagebar.pbReset(this.IREX_READER_UA_ID);
            this.pagebar.pbSetPageCount(this.IREX_READER_UA_ID, this.zEntries.size());
        }
        this.addMouseListener(this);
        this.addWindowListener(this);
        this.addKeyListener(this);
        this.requestFocus();
        ((Component)this).setVisible(true);
        int n = this.curPage;
        this.curPage = -1;
        this.setPage(n);
        long l2 = System.currentTimeMillis() - l;
        String string2 = "000" + l2;
        System.out.println("CBZViewer initialized in " + l2 / 1000L + "." + string2.substring(string2.length() - 3) + " seconds");
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.out.println("Program closing.");
        this.saveSettings();
        System.exit(0);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    protected void setPage(int n) {
        if (n < 1) {
            n = 1;
        } else if (n > this.zEntries.size()) {
            n = this.zEntries.size();
        }
        if (this.curPage == n) {
            return;
        }
        Utils.busyBlink();
        try {
            InputStream inputStream = this.zFile.getInputStream((ZipEntry)this.zEntries.get(n - 1));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = 0;
            do {
                if ((n2 = inputStream.read(this.zBuffer)) <= 0) continue;
                byteArrayOutputStream.write(this.zBuffer, 0, n2);
            } while (n2 > 0);
            inputStream.close();
            this.screenImage = Toolkit.getDefaultToolkit().createImage(byteArrayOutputStream.toByteArray());
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(this.screenImage, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                System.out.println(interruptedException);
                System.exit(0);
            }
            byteArrayOutputStream.close();
            int n3 = this.screenImage.getWidth(this);
            int n4 = this.screenImage.getHeight(this);
            Image image = null;
            if (n4 > n3) {
                if (n4 > 963) {
                    image = this.screenImage.getScaledInstance(-1, 963, 4);
                } else if (n3 > 768) {
                    image = this.screenImage.getScaledInstance(768, -1, 4);
                }
            } else if (n3 > 768) {
                image = this.screenImage.getScaledInstance(768, -1, 4);
            } else if (n4 > 963) {
                image = this.screenImage.getScaledInstance(-1, 963, 4);
            }
            if (image != null) {
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForID(0);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println(interruptedException);
                    System.exit(0);
                }
                this.screenImage = image;
            }
            this.curPage = n;
            this.pagebar.pbSetCurrentPage(this.IREX_READER_UA_ID, n);
            this.pagebar.pbRedraw(this.IREX_READER_UA_ID);
            ((Component)this).setVisible(false);
            ((Component)this).setVisible(true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void paint(Graphics graphics) {
        if (this.screenImage != null) {
            int n = this.screenImage.getWidth(this);
            int n2 = this.screenImage.getHeight(this);
            graphics.drawImage(this.screenImage, (768 - n) / 2, (963 - n2) / 2, this);
            DisplayUpdate.dispMainWinFullQ();
            Utils.busyOff();
        }
    }

    public void messageReceived(DatagramPacket datagramPacket) {
        ErIpcCmd erIpcCmd = ViewerSignal.parseCommand((String)new String(datagramPacket.getData(), 0, datagramPacket.getLength()));
        if (erIpcCmd == null) {
            System.out.print("Invalid ErIpcCmd message.");
            return;
        }
        if (erIpcCmd.get_cmdcode() == 0) {
            String[] stringArray = erIpcCmd.get_args();
            int n = 0;
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (Throwable throwable) {
                System.out.println("Got invalid ErIpcCmd message argument.");
                return;
            }
            Utils.busyBlink();
            this.setPage(n);
        } else {
            System.out.println("Ignore ErIpcCmd message of code: " + erIpcCmd.get_cmdcode());
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 116: {
                Utils.busyBlink();
                System.out.println("VK_F5 Quiting.");
                this.saveSettings();
                System.exit(0);
                break;
            }
            case 36: {
                this.moveRelativePage(1);
                break;
            }
            case 34: {
                this.moveRelativePage(1);
                break;
            }
            case 112: {
                this.moveRelativePage(5);
                break;
            }
            case 33: {
                this.moveRelativePage(-1);
                break;
            }
            case 113: {
                this.moveRelativePage(-5);
                break;
            }
        }
        keyEvent.consume();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    protected void moveRelativePage(int n) {
        this.setPage(this.curPage + n);
    }

    protected void loadSettings() {
        try {
            KXmlParser kXmlParser = new KXmlParser();
            FileInputStream fileInputStream = new FileInputStream(this.settingsName);
            kXmlParser.setInput((InputStream)fileInputStream, "utf-8");
            kXmlParser.nextTag();
            kXmlParser.require(2, null, "text");
            String string = kXmlParser.getAttributeValue(null, "page");
            this.curPage = Integer.parseInt(string);
            System.out.println("Loaded page number: " + this.curPage);
            ((InputStream)fileInputStream).close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void saveSettings() {
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(this.settingsName));
            printWriter.println("<text page=\"" + this.curPage + "\" />");
            printWriter.close();
            System.out.println("Saved page number: " + this.curPage);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

