/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu;

import com.lizardtech.djvu.BSInputStream;
import com.lizardtech.djvu.CachedInputStream;
import com.lizardtech.djvu.Codec;
import com.lizardtech.djvu.DjVuInterface;
import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvu.GPixel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class Palette
extends DjVuObject
implements Cloneable,
Codec {
    public static final int DJVUPALETTEVERSION = 0;
    public int[] colordata = null;
    private final Hashtable pmap = new Hashtable();
    private GPixel[] palette = null;
    static /* synthetic */ Class class$com$lizardtech$djvu$Palette;

    public boolean isImageData() {
        return true;
    }

    public void setPalette(GPixel[] gPixelArray) {
        this.palette = gPixelArray;
    }

    public GPixel[] getPalette() {
        return this.palette;
    }

    public static Palette createPalette(DjVuInterface djVuInterface) {
        DjVuOptions djVuOptions = djVuInterface.getDjVuOptions();
        return (Palette)DjVuObject.create(djVuOptions, djVuOptions.getPaletteClass(), class$com$lizardtech$djvu$Palette == null ? (class$com$lizardtech$djvu$Palette = Palette.class$("com.lizardtech.djvu.Palette")) : class$com$lizardtech$djvu$Palette);
    }

    public Object clone() {
        Palette palette = null;
        try {
            palette = (Palette)super.clone();
            GPixel[] gPixelArray = this.getPalette();
            if (gPixelArray != null) {
                GPixel[] gPixelArray2 = new GPixel[gPixelArray.length];
                palette.setPalette(gPixelArray2);
                int n = 0;
                while (n < gPixelArray2.length) {
                    gPixelArray2[n] = (GPixel)gPixelArray[n].clone();
                }
            }
            if (this.colordata != null) {
                palette.colordata = (int[])this.colordata.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return palette;
    }

    public final void get_color(int n, GPixel gPixel) {
        this.index_to_color(this.colordata[n], gPixel);
    }

    public final int size() {
        return this.getPalette().length;
    }

    public int color_to_index(GPixel gPixel) {
        Integer n = new Integer(gPixel.getBlue() << 16 | gPixel.getGreen() << 8 | gPixel.getRed());
        Integer n2 = (Integer)this.pmap.get(n);
        return n2 != null ? n2.intValue() : this.color_to_index_slow(gPixel);
    }

    public final void index_to_color(int n, GPixel gPixel) {
        gPixel.set(this.getPalette()[n]);
    }

    public void decode(CachedInputStream cachedInputStream) throws IOException {
        int n;
        int n2;
        int n3;
        CachedInputStream cachedInputStream2 = (CachedInputStream)cachedInputStream.clone();
        this.pmap.clear();
        int n4 = ((InputStream)cachedInputStream2).read();
        if ((n4 & 0x7F) != 0) {
            throw new IOException("bad palette version " + n4);
        }
        int n5 = ((InputStream)cachedInputStream2).read() << 8;
        if ((n5 |= ((InputStream)cachedInputStream2).read()) < 0) {
            throw new IOException("Bad palette size " + n5);
        }
        GPixel[] gPixelArray = new GPixel[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            byte by = (byte)((InputStream)cachedInputStream2).read();
            n2 = ((InputStream)cachedInputStream2).read();
            n = ((InputStream)cachedInputStream2).read();
            gPixelArray[n3] = new GPixel(by, (byte)n2, (byte)n);
        }
        this.setPalette(gPixelArray);
        if ((n4 & 0x80) != 0) {
            n3 = ((InputStream)cachedInputStream2).read() << 16;
            n3 |= ((InputStream)cachedInputStream2).read() << 8;
            if ((n3 |= ((InputStream)cachedInputStream2).read()) < 0) {
                throw new IOException("bad palette datasize");
            }
            this.colordata = new int[n3];
            BSInputStream bSInputStream = BSInputStream.createBSInputStream(this).init(cachedInputStream2);
            for (n2 = 0; n2 < n3; ++n2) {
                n = ((InputStream)bSInputStream).read() << 8;
                if ((n |= ((InputStream)bSInputStream).read()) < 0 || n >= n5) {
                    throw new IOException("bad palette data");
                }
                this.colordata[n2] = n;
            }
        }
    }

    public void decode_rgb_entries(InputStream inputStream, int n) throws IOException {
        GPixel[] gPixelArray = new GPixel[n];
        for (int i = 0; i < n; ++i) {
            byte by = (byte)inputStream.read();
            byte by2 = (byte)inputStream.read();
            byte by3 = (byte)inputStream.read();
            gPixelArray[i] = new GPixel(by3, by2, by);
        }
        this.setPalette(gPixelArray);
    }

    private int color_to_index_slow(GPixel gPixel) {
        GPixel[] gPixelArray = this.getPalette();
        int n = gPixelArray.length;
        int n2 = 0;
        int n3 = 196608;
        for (int i = 0; i < n; ++i) {
            int n4;
            int n5;
            GPixel gPixel2 = gPixelArray[i];
            int n6 = 0xFF & gPixel.blueByte() - gPixel2.blueByte();
            int n7 = n6 * n6 + (n5 = 0xFF & gPixel.greenByte() - gPixel2.greenByte()) * n5 + (n4 = 0xFF & gPixel.redByte() - gPixel2.redByte()) * n4;
            if (n7 >= n3) continue;
            n2 = i;
            n3 = n7;
        }
        if (this.pmap.size() < 32768) {
            Integer n8 = new Integer(gPixel.getBlue() << 16 | gPixel.getGreen() << 8 | gPixel.getRed());
            this.pmap.put(n8, new Integer(n2));
        }
        return n2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

