/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu;

import com.lizardtech.djvu.DjVuInterface;
import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvu.GBitmap;
import com.lizardtech.djvu.GRect;
import com.lizardtech.djvu.JB2Blit;
import com.lizardtech.djvu.JB2Decode;
import com.lizardtech.djvu.JB2Dict;
import com.lizardtech.djvu.JB2Shape;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class JB2Image
extends JB2Dict {
    public boolean reproduce_old_bug = false;
    public int height = 0;
    public int width = 0;
    private Vector blits = new Vector();
    static /* synthetic */ Class class$com$lizardtech$djvu$JB2Image;

    public static JB2Image createJB2Image(DjVuInterface djVuInterface) {
        DjVuOptions djVuOptions = djVuInterface.getDjVuOptions();
        return (JB2Image)DjVuObject.create(djVuOptions, djVuOptions.getJB2ImageClass(), class$com$lizardtech$djvu$JB2Image == null ? (class$com$lizardtech$djvu$JB2Image = JB2Image.class$("com.lizardtech.djvu.JB2Image")) : class$com$lizardtech$djvu$JB2Image);
    }

    public Object clone() {
        JB2Image jB2Image = (JB2Image)super.clone();
        if (this.blits != null) {
            Vector<Object> vector;
            jB2Image.blits = vector = new Vector<Object>();
            Enumeration enumeration = this.blits.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(((JB2Blit)enumeration.nextElement()).clone());
            }
        }
        return jB2Image;
    }

    public final GBitmap get_bitmap() {
        return this.get_bitmap(1);
    }

    public final GBitmap get_bitmap(int n) {
        return this.get_bitmap(n, 1);
    }

    public final GBitmap get_bitmap(int n, int n2) {
        if (this.width == 0 || this.height == 0) {
            throw new IllegalStateException("JB2Image can not create bitmap");
        }
        int n3 = (this.width + n - 1) / n;
        int n4 = (this.height + n - 1) / n;
        int n5 = (n3 + n2 - 1 & ~(n2 - 1)) - n3;
        GBitmap gBitmap = GBitmap.createGBitmap(this);
        gBitmap.init(n4, n3, n5);
        gBitmap.setGrays(1 + n * n);
        for (int i = 0; i < this.get_blit_count(); ++i) {
            JB2Blit jB2Blit = this.get_blit(i);
            JB2Shape jB2Shape = this.get_shape(jB2Blit.shapeno());
            if (jB2Shape.getGBitmap() == null) continue;
            gBitmap.blit(jB2Shape.getGBitmap(), jB2Blit.left(), jB2Blit.bottom(), n);
        }
        return gBitmap;
    }

    public final GBitmap get_bitmap(GRect gRect) {
        return this.get_bitmap(gRect, 1);
    }

    public final GBitmap get_bitmap(GRect gRect, int n) {
        return this.get_bitmap(gRect, n, 1);
    }

    public final GBitmap get_bitmap(GRect gRect, int n, int n2) {
        return this.get_bitmap(gRect, n, n2, 0);
    }

    public final GBitmap get_bitmap(GRect gRect, int n, int n2, int n3) {
        if (this.width == 0 || this.height == 0) {
            throw new IllegalStateException("JB2Image can not create bitmap");
        }
        int n4 = gRect.xmin * n;
        int n5 = gRect.ymin * n;
        int n6 = gRect.width();
        int n7 = gRect.height();
        int n8 = (n6 + n2 - 1 & ~(n2 - 1)) - n6;
        GBitmap gBitmap = GBitmap.createGBitmap(this);
        gBitmap.init(n7, n6, n8);
        gBitmap.setGrays(1 + n * n);
        int n9 = 0;
        while (n9 < this.get_blit_count()) {
            JB2Blit jB2Blit;
            JB2Shape jB2Shape;
            if ((jB2Shape = this.get_shape((jB2Blit = this.get_blit(n9++)).shapeno())).getGBitmap() == null) continue;
            gBitmap.blit(jB2Shape.getGBitmap(), jB2Blit.left() - n4, n3 + jB2Blit.bottom() - n5, n);
        }
        return gBitmap;
    }

    public final GBitmap get_bitmap(GRect gRect, int n, int n2, int n3, Vector vector) {
        if (vector == null) {
            return this.get_bitmap(gRect, n, n2, n3);
        }
        if (this.width == 0 || this.height == 0) {
            throw new IllegalStateException("JB2Image can not create bitmap");
        }
        int n4 = gRect.xmin * n;
        int n5 = gRect.ymin * n;
        int n6 = gRect.width();
        int n7 = gRect.height();
        int n8 = (n6 + n2 - 1 & ~(n2 - 1)) - n6;
        GBitmap gBitmap = GBitmap.createGBitmap(this);
        gBitmap.init(n7, n6, n8);
        gBitmap.setGrays(1 + n * n);
        int n9 = 0;
        while (n9 < this.get_blit_count()) {
            JB2Blit jB2Blit;
            JB2Shape jB2Shape;
            if ((jB2Shape = this.get_shape((jB2Blit = this.get_blit(n9++)).shapeno())).getGBitmap() == null || !gBitmap.blit(jB2Shape.getGBitmap(), jB2Blit.left() - n4, n3 + jB2Blit.bottom() - n5, n)) continue;
            vector.addElement(new Integer(n9 - 1));
        }
        return gBitmap;
    }

    public final JB2Blit get_blit(int n) {
        return (JB2Blit)this.blits.elementAt(n);
    }

    public final int get_blit_count() {
        return this.blits.size();
    }

    public int add_blit(JB2Blit jB2Blit) {
        if (jB2Blit.shapeno() >= this.get_shape_count()) {
            throw new IllegalArgumentException("JB2Image bad shape");
        }
        int n = this.blits.size();
        this.blits.addElement(jB2Blit);
        return n;
    }

    public void decode(InputStream inputStream, JB2Dict jB2Dict) throws IOException {
        this.init();
        JB2Decode jB2Decode = JB2Decode.createJB2Decode(this);
        jB2Decode.init(inputStream, jB2Dict);
        jB2Decode.code(this);
    }

    public void init() {
        this.height = 0;
        this.width = 0;
        this.blits.setSize(0);
        super.init();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

