/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu;

import com.lizardtech.djvu.BitContext;
import com.lizardtech.djvu.DjVuInterface;
import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvu.IWBlock;
import com.lizardtech.djvu.IWMap;
import com.lizardtech.djvu.ZPCodec;
import java.io.IOException;

final class IWCodec
extends DjVuObject {
    static final int[] iw_quant = new int[]{65536, 131072, 131072, 262144, 262144, 262144, 524288, 524288, 524288, 0x100000, 0x100000, 0x100000, 0x200000, 0x100000, 0x100000, 0x200000};
    static final Bucket[] bandbuckets = new Bucket[]{new Bucket(0, 1), new Bucket(1, 1), new Bucket(2, 1), new Bucket(3, 1), new Bucket(4, 4), new Bucket(8, 4), new Bucket(12, 4), new Bucket(16, 16), new Bucket(32, 16), new Bucket(48, 16)};
    static final int ZERO = 1;
    static final int ACTIVE = 2;
    static final int NEW = 4;
    static final int UNK = 8;
    private BitContext ctxMant;
    private BitContext ctxRoot;
    private IWMap map;
    private byte[] bucketstate;
    private byte[] coeffstate;
    private BitContext[][] ctxBucket;
    private BitContext[] ctxStart = new BitContext[32];
    private int[] quant_hi;
    private int[] quant_lo;
    private int curband;
    private int curbit;
    static /* synthetic */ Class class$com$lizardtech$djvu$IWCodec;

    public IWCodec() {
        int n;
        for (n = 0; n < 32; ++n) {
            this.ctxStart[n] = new BitContext();
        }
        this.ctxBucket = new BitContext[10][8];
        for (n = 0; n < 10; ++n) {
            for (int i = 0; i < 8; ++i) {
                this.ctxBucket[n][i] = new BitContext();
            }
        }
        this.quant_hi = new int[10];
        this.quant_lo = new int[16];
        this.coeffstate = new byte[256];
        this.bucketstate = new byte[16];
        this.curband = 0;
        this.curbit = 1;
        this.ctxMant = new BitContext();
        this.ctxRoot = new BitContext();
    }

    public static IWCodec createIWCodec(DjVuInterface djVuInterface) {
        DjVuOptions djVuOptions = djVuInterface.getDjVuOptions();
        return (IWCodec)DjVuObject.create(djVuOptions, djVuOptions.getIWCodecClass(), class$com$lizardtech$djvu$IWCodec == null ? (class$com$lizardtech$djvu$IWCodec = IWCodec.class$("com.lizardtech.djvu.IWCodec")) : class$com$lizardtech$djvu$IWCodec);
    }

    int code_slice(ZPCodec zPCodec) throws IOException {
        if (this.curbit < 0) {
            return 0;
        }
        if (this.is_null_slice(this.curbit, this.curband) == 0) {
            for (int i = 0; i < this.map.nb; ++i) {
                int n = IWCodec.bandbuckets[this.curband].start;
                int n2 = IWCodec.bandbuckets[this.curband].size;
                this.decode_buckets(zPCodec, this.curbit, this.curband, this.map.blocks[i], n, n2);
            }
        }
        if (++this.curband >= bandbuckets.length) {
            this.curband = 0;
            ++this.curbit;
            if (this.next_quant() == 0) {
                this.curbit = -1;
                return 0;
            }
        }
        return 1;
    }

    void decode_buckets(ZPCodec zPCodec, int n, int n2, IWBlock iWBlock, int n3, int n4) throws IOException {
        int n5;
        int n6;
        int n7 = this.quant_hi[n2];
        int n8 = 0;
        byte[] byArray = this.coeffstate;
        int n9 = 0;
        int n10 = 0;
        while (n10 < n4) {
            n6 = 0;
            short[] sArray = iWBlock.getBlock(n3 + n10);
            if (sArray == null) {
                n6 = 8;
            } else {
                for (int i = 0; i < 16; ++i) {
                    n5 = byArray[n9 + i] & 1;
                    if (n5 == 0) {
                        n5 = sArray[i] != 0 ? (n5 |= 2) : (n5 |= 8);
                    }
                    byArray[n9 + i] = (byte)n5;
                    n6 |= n5;
                }
            }
            this.bucketstate[n10] = (byte)n6;
            n8 |= n6;
            ++n10;
            n9 += 16;
        }
        if (n4 < 16 || (n8 & 2) != 0) {
            n8 |= 4;
        } else if ((n8 & 8) != 0 && zPCodec.decoder(this.ctxRoot) != 0) {
            n8 |= 4;
        }
        if ((n8 & 4) != 0) {
            for (n10 = 0; n10 < n4; ++n10) {
                int n11;
                short[] sArray;
                if ((this.bucketstate[n10] & 8) == 0) continue;
                n6 = 0;
                if (!DjVuOptions.NOCTX_BUCKET_UPPER && n2 > 0 && (sArray = iWBlock.getBlock((n11 = n3 + n10 << 2) >> 4)) != null) {
                    if (sArray[n11 &= 0xF] != 0) {
                        ++n6;
                    }
                    if (sArray[n11 + 1] != 0) {
                        ++n6;
                    }
                    if (sArray[n11 + 2] != 0) {
                        ++n6;
                    }
                    if (n6 < 3 && sArray[n11 + 3] != 0) {
                        ++n6;
                    }
                }
                if (!DjVuOptions.NOCTX_BUCKET_ACTIVE && (n8 & 2) != 0) {
                    n6 |= 4;
                }
                if (zPCodec.decoder(this.ctxBucket[n2][n6]) == 0) continue;
                int n12 = n10;
                this.bucketstate[n12] = (byte)(this.bucketstate[n12] | 4);
            }
        }
        if ((n8 & 4) != 0) {
            byArray = this.coeffstate;
            n9 = 0;
            n10 = 0;
            while (n10 < n4) {
                if ((this.bucketstate[n10] & 4) != 0) {
                    int n13;
                    short[] sArray = iWBlock.getBlock(n3 + n10);
                    if (sArray == null) {
                        sArray = iWBlock.getInitializedBlock(n3 + n10);
                        for (n13 = 0; n13 < 16; ++n13) {
                            if ((byArray[n9 + n13] & 1) != 0) continue;
                            byArray[n9 + n13] = 8;
                        }
                    }
                    n13 = 0;
                    int n14 = 7;
                    if (!DjVuOptions.NOCTX_EXPECT) {
                        for (n5 = 0; n5 < 16; ++n5) {
                            if ((byArray[n9 + n5] & 8) == 0) continue;
                            ++n13;
                        }
                    }
                    for (n5 = 0; n5 < 16; ++n5) {
                        if ((byArray[n9 + n5] & 8) == 0) continue;
                        if (n2 == 0) {
                            n7 = this.quant_lo[n5];
                        }
                        int n15 = 0;
                        if (!DjVuOptions.NOCTX_EXPECT) {
                            n15 = n13 >= n14 ? n14 : n13;
                        }
                        if (!DjVuOptions.NOCTX_ACTIVE && (this.bucketstate[n10] & 2) != 0) {
                            n15 |= 8;
                        }
                        if (zPCodec.decoder(this.ctxStart[n15]) != 0) {
                            int n16 = n9 + n5;
                            byArray[n16] = (byte)(byArray[n16] | 4);
                            int n17 = n7 >> 1;
                            int n18 = n7 + n17 - (n17 >> 2);
                            sArray[n5] = zPCodec.IWdecoder() != 0 ? (short)(-n18) : (short)n18;
                        }
                        if (DjVuOptions.NOCTX_EXPECT) continue;
                        if ((byArray[n9 + n5] & 4) != 0) {
                            n13 = 0;
                            continue;
                        }
                        if (n13 <= 0) continue;
                        --n13;
                    }
                }
                ++n10;
                n9 += 16;
            }
        }
        if ((n8 & 2) != 0) {
            byArray = this.coeffstate;
            n9 = 0;
            n10 = 0;
            while (n10 < n4) {
                if ((this.bucketstate[n10] & 2) != 0) {
                    short[] sArray = iWBlock.getBlock(n3 + n10);
                    for (int i = 0; i < 16; ++i) {
                        if ((byArray[n9 + i] & 2) == 0) continue;
                        int n19 = sArray[i];
                        if (n19 < 0) {
                            n19 = -n19;
                        }
                        if (n2 == 0) {
                            n7 = this.quant_lo[i];
                        }
                        if (n19 <= 3 * n7) {
                            n19 += n7 >> 2;
                            n19 = zPCodec.decoder(this.ctxMant) != 0 ? (n19 += n7 >> 1) : n19 - n7 + (n7 >> 1);
                        } else {
                            n19 = zPCodec.IWdecoder() != 0 ? (n19 += n7 >> 1) : n19 - n7 + (n7 >> 1);
                        }
                        sArray[i] = sArray[i] > 0 ? (short)n19 : (short)(-n19);
                    }
                }
                ++n10;
                n9 += 16;
            }
        }
    }

    float estimate_decibel(float f) {
        return 0.0f;
    }

    IWCodec init(IWMap iWMap) {
        this.map = iWMap;
        int n = 0;
        int[] nArray = iw_quant;
        int n2 = 0;
        int n3 = 0;
        while (n < 4) {
            this.quant_lo[n++] = nArray[n2++];
            ++n3;
        }
        for (n3 = 0; n3 < 4; ++n3) {
            this.quant_lo[n++] = nArray[n2];
        }
        ++n2;
        for (n3 = 0; n3 < 4; ++n3) {
            this.quant_lo[n++] = nArray[n2];
        }
        ++n2;
        for (n3 = 0; n3 < 4; ++n3) {
            this.quant_lo[n++] = nArray[n2];
        }
        ++n2;
        this.quant_hi[0] = 0;
        for (n3 = 1; n3 < 10; ++n3) {
            this.quant_hi[n3] = nArray[n2++];
        }
        while (this.quant_lo[0] >= 32768) {
            this.next_quant();
        }
        return this;
    }

    int is_null_slice(int n, int n2) {
        if (n2 == 0) {
            int n3 = 1;
            for (int i = 0; i < 16; ++i) {
                int n4 = this.quant_lo[i];
                this.coeffstate[i] = 1;
                if (n4 <= 0 || n4 >= 32768) continue;
                this.coeffstate[i] = 0;
                n3 = 0;
            }
            return n3;
        }
        int n5 = this.quant_hi[n2];
        if (n5 <= 0 || n5 >= 32768) {
            return 1;
        }
        for (int i = 0; i < IWCodec.bandbuckets[n2].size << 4; ++i) {
            this.coeffstate[i] = 0;
        }
        return 0;
    }

    int next_quant() {
        int n;
        int n2 = 0;
        for (n = 0; n < 16; ++n) {
            this.quant_lo[n] = this.quant_lo[n] >> 1;
            if (this.quant_lo[n] == 0) continue;
            n2 = 1;
        }
        for (n = 0; n < 10; ++n) {
            this.quant_hi[n] = this.quant_hi[n] >> 1;
            if (this.quant_hi[n] == 0) continue;
            n2 = 1;
        }
        return n2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Bucket {
        protected static int sz = 8;
        protected final int size;
        protected final int start;

        public Bucket(int n, int n2) {
            this.start = n;
            this.size = n2;
        }
    }
}

