/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu;

import com.lizardtech.djvu.GMap;
import com.lizardtech.djvu.GPixel;

public final class GPixelReference
extends GPixel {
    private GMap parent;
    private int offset;
    private final int ncolors;
    private final int redOffset;
    private final int greenOffset;
    private final int blueOffset;

    public GPixelReference(GMap gMap, int n) {
        this.parent = gMap;
        this.ncolors = gMap.getColorSize();
        this.offset = n * this.ncolors;
        this.blueOffset = gMap.getBlueOffset();
        this.greenOffset = gMap.getGreenOffset();
        this.redOffset = gMap.getRedOffset();
    }

    public GPixelReference(GMap gMap, int n, int n2) {
        this.parent = gMap;
        this.ncolors = gMap.getColorSize();
        this.offset = (gMap.rowOffset(n) + n2) * this.ncolors;
        this.blueOffset = gMap.getBlueOffset();
        this.greenOffset = gMap.getGreenOffset();
        this.redOffset = gMap.getRedOffset();
    }

    public final void setPixels(GPixelReference gPixelReference, int n) {
        if (gPixelReference.ncolors != this.ncolors || gPixelReference.blueOffset != this.blueOffset || gPixelReference.greenOffset != this.greenOffset || gPixelReference.redOffset != this.redOffset) {
            while (n-- > 0) {
                this.set(gPixelReference);
                gPixelReference.incOffset();
                this.incOffset();
            }
        } else {
            System.arraycopy(gPixelReference.parent.data, gPixelReference.offset, this.parent.data, this.offset, n * this.ncolors);
            gPixelReference.incOffset(n);
            this.incOffset(n);
        }
    }

    public void setOffset(int n) {
        this.offset = n * this.ncolors;
    }

    public void setOffset(int n, int n2) {
        this.offset = (this.parent.rowOffset(n) + n2) * this.ncolors;
    }

    public void YCC_to_RGB(int n) {
        if (this.ncolors != 3 || this.parent.isRampNeeded()) {
            throw new IllegalStateException("YCC_to_RGB only legal with three colors");
        }
        while (n-- > 0) {
            byte by = this.parent.data[this.offset];
            byte by2 = this.parent.data[this.offset + 1];
            byte by3 = this.parent.data[this.offset + 2];
            int n2 = by3 + (by3 >> 1);
            int n3 = by + 128 - (by2 >> 2);
            int n4 = n3 + (by2 << 1);
            this.parent.data[this.offset++] = (byte)(n4 < 255 ? (n4 > 0 ? n4 : 0) : 255);
            int n5 = n3 - (n2 >> 1);
            this.parent.data[this.offset++] = (byte)(n5 < 255 ? (n5 > 0 ? n5 : 0) : 255);
            int n6 = by + 128 + n2;
            this.parent.data[this.offset++] = (byte)(n6 < 255 ? (n6 > 0 ? n6 : 0) : 255);
        }
    }

    public void setBGR(int n, int n2, int n3) {
        this.parent.data[this.offset + this.blueOffset] = (byte)n;
        this.parent.data[this.offset + this.greenOffset] = (byte)n2;
        this.parent.data[this.offset + this.redOffset] = (byte)n3;
    }

    public void setBlue(byte by) {
        this.parent.data[this.offset + this.blueOffset] = by;
    }

    public byte blueByte() {
        return this.parent.data[this.offset + this.blueOffset];
    }

    public GPixelReference duplicate() {
        return new GPixelReference(this.parent, this.offset);
    }

    public void fillRGBPixels(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        int n7 = this.parent.rows() - n2;
        if (!this.parent.isRampNeeded()) {
            int n8 = n7;
            while (n8-- > n7 - n4) {
                int n9 = n5;
                int n10 = (this.parent.rowOffset(n8) + n) * this.ncolors;
                int n11 = n3;
                while (n11 > 0) {
                    nArray[n9++] = 0xFF000000 | 0xFF0000 & this.parent.data[n10 + this.redOffset] << 16 | 0xFF00 & this.parent.data[n10 + this.greenOffset] << 8 | 0xFF & this.parent.data[n10 + this.blueOffset];
                    --n11;
                    n10 += this.ncolors;
                }
                n5 += n6;
            }
        } else {
            GPixelReference gPixelReference = this.parent.createGPixelReference(0);
            int n12 = n7;
            while (n12-- > n7 - n4) {
                gPixelReference.setOffset(n12, n);
                int n13 = n5;
                for (int i = n3; i > 0; --i) {
                    nArray[n13++] = this.parent.ramp(gPixelReference).hashCode();
                    gPixelReference.incOffset();
                }
                n5 += n6;
            }
        }
    }

    public void setGreen(byte by) {
        this.parent.data[this.offset + this.greenOffset] = by;
    }

    public byte greenByte() {
        return this.parent.data[this.offset + this.greenOffset];
    }

    public void incOffset() {
        this.offset += this.ncolors;
    }

    public void incOffset(int n) {
        this.offset += this.ncolors * n;
    }

    public void setRed(byte by) {
        this.parent.data[this.offset + this.redOffset] = by;
    }

    public byte redByte() {
        return this.parent.data[this.offset + this.redOffset];
    }
}

