/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu;

import com.lizardtech.djvu.BSInputStream;
import com.lizardtech.djvu.CachedInputStream;
import com.lizardtech.djvu.Codec;
import com.lizardtech.djvu.DjVmDir;
import com.lizardtech.djvu.DjVuInterface;
import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvu.DjVuPage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Document
extends DjVuObject
implements Cloneable,
Runnable {
    public static final byte[] octets = new byte[]{65, 84, 38, 84};
    public static int MAX_PRIORITY = 1;
    public static int MIN_PRIORITY = 0;
    public Thread prefetchThread = null;
    private static Vector[] prefetchVector = new Vector[]{new Vector(), new Vector()};
    private static int prefetchCount = 0;
    private final PropertyChangeSupport change;
    private String status = null;
    protected Hashtable cachedInputStreamMap = new Hashtable();
    protected Hashtable pageMap = new Hashtable();
    private Codec bookmark = null;
    private CachedInputStream pool = null;
    private DjVmDir dir = DjVmDir.createDjVmDir(this);
    private Object parentRef = null;
    private boolean asyncValue = false;
    static /* synthetic */ Class class$com$lizardtech$djvu$Document;

    public Document() {
        this.change = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.change.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.change.removePropertyChangeListener(propertyChangeListener);
    }

    public void setStatus(String string) {
        String string2 = this.status;
        this.status = string;
        this.change.firePropertyChange("status", string2, string);
    }

    public String getStatus() {
        return this.status;
    }

    public Document(URL uRL) throws IOException {
        this();
        this.init(uRL);
    }

    public static Document createDocument(DjVuInterface djVuInterface) {
        DjVuOptions djVuOptions = djVuInterface.getDjVuOptions();
        return (Document)DjVuObject.create(djVuOptions, djVuOptions.getDocumentClass(), class$com$lizardtech$djvu$Document == null ? (class$com$lizardtech$djvu$Document = Document.class$("com.lizardtech.djvu.Document")) : class$com$lizardtech$djvu$Document);
    }

    public final void setAsync(boolean bl) {
        this.asyncValue = bl;
    }

    public final boolean isAsync() {
        return this.asyncValue;
    }

    public Codec getBookmark() {
        Codec codec = this.bookmark;
        if (codec == null) {
            this.bookmark = codec = this.getDjVuOptions().createBookmark();
        }
        return codec;
    }

    public DjVmDir getDjVmDir() {
        return this.dir;
    }

    public DjVuPage getPage(int n, int n2, boolean bl) throws IOException {
        String string = this.getDjVmDir().page_to_file(n).get_load_name();
        DjVuPage djVuPage = this.getPage(string, n2, bl);
        return djVuPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DjVuPage getPage(String string, int n, boolean bl) throws IOException {
        Object object;
        DjVuPage djVuPage = null;
        if (DjVuObject.hasReferences) {
            try {
                djVuPage = (DjVuPage)DjVuObject.getFromReference(this.pageMap.get(string));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        if (djVuPage == null) {
            CachedInputStream cachedInputStream = this.get_data(string);
            if (!bl) {
                this.prefetch(string, MAX_PRIORITY);
            }
            if (bl || cachedInputStream.available() > 0) {
                Object object2;
                object = this.getDjVmDir().getInitURL();
                if (object != null) {
                    object = new URL((URL)object, string);
                }
                djVuPage = this.createDjVuPage((URL)object);
                djVuPage.setAsync(this.isAsync());
                djVuPage.setPriority(n);
                djVuPage.decode(cachedInputStream);
                if (DjVuObject.hasReferences && (object2 = DjVuObject.createSoftReference(djVuPage, null)) != null) {
                    try {
                        this.pageMap.put(string, object2);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        if (djVuPage == null || bl) return djVuPage;
        int n2 = this.getPageno('#' + string);
        object = prefetchVector;
        synchronized (prefetchVector) {
            prefetchVector[MAX_PRIORITY].setSize(0);
            prefetchVector[MIN_PRIORITY].setSize(0);
            prefetchCount = 0;
            this.prefetch(string, MAX_PRIORITY);
            this.prefetch(0, MIN_PRIORITY);
            this.prefetch(this.size() - 1, MIN_PRIORITY);
            this.prefetch(n2 - 2, MIN_PRIORITY);
            this.prefetch(n2 + 2, MIN_PRIORITY);
            this.prefetch(n2 - 1, MIN_PRIORITY);
            this.prefetch(n2 + 1, MIN_PRIORITY);
            // ** MonitorExit[var6_8 /* !! */ ] (shouldn't be in output)
            return djVuPage;
        }
    }

    public int getPageno(String string) {
        return this.getDjVmDir().getPageno(string);
    }

    public Object clone() {
        Document document = null;
        try {
            document = (Document)super.clone();
            DjVmDir djVmDir = this.getDjVmDir();
            if (djVmDir != null) {
                document.dir = (DjVmDir)djVmDir.clone();
            }
            if (this.cachedInputStreamMap != null) {
                document.cachedInputStreamMap = (Hashtable)this.cachedInputStreamMap.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return document;
    }

    public DjVuPage createDjVuPage(URL uRL) {
        return new DocumentDjVuPage(uRL);
    }

    public void delete_file(String string) throws IOException {
        if (!this.cachedInputStreamMap.contains(string)) {
            throw new IOException("Can not delete " + string);
        }
        this.cachedInputStreamMap.remove(string);
        this.getDjVmDir().delete_file(string);
    }

    public CachedInputStream get_data(String string) throws IOException {
        Object object;
        if (string == null) {
            throw new IOException("Can not find blank name.");
        }
        CachedInputStream cachedInputStream = (CachedInputStream)this.cachedInputStreamMap.get(string);
        DjVmDir djVmDir = this.getDjVmDir();
        if (cachedInputStream == null) {
            object = djVmDir.get_files_list();
            URL uRL = djVmDir.getInitURL();
            DjVmDir.File file = this.getDjVmDir().id_to_file(string);
            if (file == null) {
                if (uRL == null) {
                    throw new IOException("Requested data outside document");
                }
                URL uRL2 = new URL(uRL, string);
                cachedInputStream = CachedInputStream.createCachedInputStream(this).init(uRL2, false);
                this.insert_file(cachedInputStream, 0, string, string);
            } else if (this.pool != null) {
                cachedInputStream = (CachedInputStream)this.pool.clone();
                cachedInputStream.skip(file.offset);
                cachedInputStream.setSize(file.size);
                this.cachedInputStreamMap.put(string, cachedInputStream);
            } else if (uRL != null) {
                cachedInputStream = CachedInputStream.createCachedInputStream(this).init(new URL(uRL, string), false);
                this.cachedInputStreamMap.put(string, cachedInputStream);
            }
        }
        if (!(djVmDir.is_bundled() || (object = cachedInputStream.getIFFChunks()) != null && object.hasMoreElements())) {
            throw new IOException("EOF");
        }
        return cachedInputStream;
    }

    public CachedInputStream get_data(int n) throws IOException {
        return this.get_data(this.getDjVmDir().page_to_file(n).get_load_name());
    }

    public Document init(URL uRL) throws IOException {
        this.read(uRL);
        return this;
    }

    public void insert_file(InputStream inputStream, int n, String string, String string2) throws IOException {
        this.insert_file(inputStream, n, string, string2, "");
    }

    public void insert_file(InputStream inputStream, int n, String string, String string2, String string3) throws IOException {
        this.insert_file(inputStream, n, string, string2, string3, -1);
    }

    public void insert_file(InputStream inputStream, int n, String string, String string2, String string3, int n2) throws IOException {
        DjVmDir.File file = this.getDjVmDir().createFile(string, string2, string3, n);
        CachedInputStream cachedInputStream = CachedInputStream.createCachedInputStream(this).init(inputStream);
        this.insert_file(file, cachedInputStream, n2);
    }

    public void insert_file(CachedInputStream cachedInputStream, int n, String string, String string2) throws IOException {
        this.insert_file(cachedInputStream, n, string, string2, "");
    }

    public void insert_file(CachedInputStream cachedInputStream, int n, String string, String string2, String string3) throws IOException {
        this.insert_file(cachedInputStream, n, string, string2, string3, -1);
    }

    public void insert_file(CachedInputStream cachedInputStream, int n, String string, String string2, String string3, int n2) throws IOException {
        DjVmDir.File file = this.getDjVmDir().createFile(string, string2, string3, n);
        this.insert_file(file, cachedInputStream, n2);
    }

    public void insert_file(DjVmDir.File file, CachedInputStream cachedInputStream) throws IOException {
        this.insert_file(file, cachedInputStream, -1);
    }

    public void insert_file(DjVmDir.File file, CachedInputStream cachedInputStream, int n) throws IOException {
        if (file == null) {
            throw new IOException("No zero file.");
        }
        if (this.cachedInputStreamMap.contains(file.get_load_name())) {
            throw new IOException("No duplicates allowed.");
        }
        CachedInputStream cachedInputStream2 = (CachedInputStream)cachedInputStream.clone();
        int n2 = cachedInputStream2.read();
        int n3 = cachedInputStream2.read();
        int n4 = cachedInputStream2.read();
        int n5 = cachedInputStream2.read();
        if (n2 != octets[0] || n3 != octets[1] || n4 != octets[2] || n5 != octets[3]) {
            cachedInputStream = cachedInputStream2.createCachedInputStream(Integer.MAX_VALUE);
        }
        this.cachedInputStreamMap.put(file.get_load_name(), cachedInputStream);
        this.getDjVmDir().insert_file(file, n);
    }

    public void prefetch(int n, int n2) {
        try {
            this.prefetch(this.getDjVmDir().page_to_file(n).get_load_name(), n2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void prefetch(String string, int n) {
        if (this.size() <= 0) return;
        Vector[] vectorArray = prefetchVector;
        synchronized (prefetchVector) {
            prefetchVector[n].addElement(string);
            ++prefetchCount;
            prefetchVector.notifyAll();
            Thread thread = this.prefetchThread;
            if (thread != null && this.prefetchThread.isAlive()) return;
            Document document = Document.createDocument(new DjVuObject());
            document.parentRef = DjVuObject.createWeakReference(this, this);
            document.dir = this.getDjVmDir();
            document.cachedInputStreamMap = this.cachedInputStreamMap;
            this.prefetchThread = thread = new Thread(document);
            thread.start();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void read(InputStream inputStream) throws IOException {
        this.read(CachedInputStream.createCachedInputStream(this).init(inputStream));
    }

    public void read(CachedInputStream cachedInputStream) throws IOException {
        Object object;
        Cloneable cloneable;
        DjVmDir djVmDir = this.getDjVmDir();
        djVmDir.setInitURL(null);
        Enumeration enumeration = cachedInputStream.getIFFChunks();
        if (enumeration == null || !enumeration.hasMoreElements()) {
            throw new IOException("EOF");
        }
        CachedInputStream cachedInputStream2 = (CachedInputStream)enumeration.nextElement();
        if (!"FORM:DJVM".equals(cachedInputStream2.getName())) {
            this.insert_file(cachedInputStream, 1, "noname.djvu", "noname.djvu");
            return;
        }
        Enumeration enumeration2 = cachedInputStream2.getIFFChunks();
        if (enumeration2 != null && !enumeration2.hasMoreElements()) {
            throw new IOException("EOF");
        }
        CachedInputStream cachedInputStream3 = (CachedInputStream)enumeration2.nextElement();
        if (!"DIRM".equals(cachedInputStream3.getName())) {
            throw new IOException("No DIRM chunk");
        }
        djVmDir.decode(cachedInputStream3);
        this.cachedInputStreamMap.clear();
        if (djVmDir.is_indirect()) {
            throw new IOException("Cannot read indirect chunk.");
        }
        this.pool = cachedInputStream;
        Vector vector = djVmDir.get_files_list();
        for (int i = 0; i < vector.size(); ++i) {
            cloneable = (DjVmDir.File)vector.elementAt(i);
            object = (CachedInputStream)cachedInputStream.clone();
            ((CachedInputStream)object).skip(((DjVmDir.File)cloneable).offset);
            ((CachedInputStream)object).setSize(((DjVmDir.File)cloneable).size);
            this.cachedInputStreamMap.put(((DjVmDir.File)cloneable).get_load_name(), object);
        }
        Codec codec = this.getBookmark();
        if (codec != null) {
            while (enumeration2.hasMoreElements() && (object = ((CachedInputStream)(cloneable = (CachedInputStream)enumeration2.nextElement())).getName()) != null && !((String)object).startsWith("FORM")) {
                if (!((String)object).equals("NAVM")) continue;
                codec.decode(CachedInputStream.createCachedInputStream(this).init(BSInputStream.createBSInputStream(this).init((InputStream)((Object)cloneable))));
            }
        }
    }

    public void read(URL uRL) throws IOException {
        this.setStatus("Read URL " + uRL);
        DjVmDir djVmDir = this.getDjVmDir();
        djVmDir.setInitURL(null);
        CachedInputStream cachedInputStream = CachedInputStream.createCachedInputStream(this).init(uRL, false);
        Enumeration enumeration = cachedInputStream.getIFFChunks();
        if (enumeration == null || !enumeration.hasMoreElements()) {
            throw new IOException("Invalid DjVu File Format");
        }
        CachedInputStream cachedInputStream2 = (CachedInputStream)enumeration.nextElement();
        if (!"FORM:DJVM".equals(cachedInputStream2.getName())) {
            if (!cachedInputStream.isDjVuFile()) {
                throw new IOException("Invalid DjVu File Format");
            }
            String string = uRL.getFile();
            int n = string.indexOf(63);
            if (n > 0) {
                string = string.substring(0, n);
            }
            if ((n = string.lastIndexOf(47)) > 0) {
                string = string.substring(n);
            }
            this.insert_file(cachedInputStream, 1, string, string);
        } else {
            Enumeration enumeration2 = cachedInputStream2.getIFFChunks();
            if (enumeration2 == null || !enumeration2.hasMoreElements()) {
                throw new IOException("EOF");
            }
            CachedInputStream cachedInputStream3 = (CachedInputStream)enumeration2.nextElement();
            if (!"DIRM".equals(cachedInputStream3.getName())) {
                throw new IOException("No DIRM chunk");
            }
            djVmDir.decode(cachedInputStream3);
            if (djVmDir.is_bundled()) {
                this.read(cachedInputStream);
            } else {
                Codec codec = this.getBookmark();
                if (codec != null) {
                    while (enumeration2.hasMoreElements()) {
                        cachedInputStream3 = (CachedInputStream)enumeration2.nextElement();
                        if (!"NAVM".equals(cachedInputStream3.getName())) continue;
                        codec.decode(CachedInputStream.createCachedInputStream(this).init(BSInputStream.createBSInputStream(this).init(cachedInputStream3)));
                    }
                }
                this.cachedInputStreamMap.clear();
            }
        }
        djVmDir.setInitURL(uRL);
        this.setStatus("URL " + uRL + " initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            Thread thread = Thread.currentThread();
            int n = MIN_PRIORITY;
            String string = null;
            while (((Document)DjVuObject.getFromReference((Object)this.parentRef)).prefetchThread == thread) {
                String string2 = null;
                Vector[] vectorArray = prefetchVector;
                // MONITORENTER : prefetchVector
                Document cfr_ignored_0 = (Document)DjVuObject.getFromReference(this.parentRef);
                if (prefetchCount == 0) {
                    try {
                        prefetchVector.wait(5000L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    Document cfr_ignored_1 = (Document)DjVuObject.getFromReference(this.parentRef);
                    if (prefetchCount == 0) {
                        ((Document)DjVuObject.getFromReference((Object)this.parentRef)).prefetchThread = null;
                        // MONITOREXIT : vectorArray
                        return;
                    }
                }
                n = prefetchVector.length;
                while (n > 0) {
                    Vector vector;
                    if ((vector = prefetchVector[--n]).size() <= 0) continue;
                    string2 = (String)vector.lastElement();
                    vector.removeElementAt(vector.size() - 1);
                    Document cfr_ignored_2 = (Document)DjVuObject.getFromReference(this.parentRef);
                    --prefetchCount;
                    if (string2 == null) continue;
                    if (string2.equals(string)) {
                        string2 = null;
                        continue;
                    }
                    if (n >= MAX_PRIORITY) break;
                    Vector vector2 = prefetchVector[n + 1];
                    vector2.addElement(string2);
                    Document cfr_ignored_3 = (Document)DjVuObject.getFromReference(this.parentRef);
                    ++prefetchCount;
                    string2 = null;
                    try {
                        prefetchVector.wait(200L);
                    }
                    catch (Throwable throwable) {}
                    break;
                }
                // MONITOREXIT : vectorArray
                if (string2 == null) continue;
                string = string2;
                try {
                    ((Document)DjVuObject.getFromReference(this.parentRef)).setStatus("fetching " + string2);
                    ((Document)DjVuObject.getFromReference(this.parentRef)).get_data(string2).prefetchWait();
                    ((Document)DjVuObject.getFromReference(this.parentRef)).setStatus("fetched " + string2);
                }
                catch (Throwable throwable) {}
            }
            return;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int size() {
        return this.getDjVmDir().get_pages_num();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class DocumentDjVuPage
    extends DjVuPage {
        DocumentDjVuPage(URL uRL) {
            this.setDjVuOptions(Document.this.getDjVuOptions());
            this.url = uRL;
        }

        CachedInputStream createCachedInputStream(String string) throws IOException {
            return Document.this.get_data(string);
        }
    }
}

