/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu;

import com.lizardtech.djvu.DataPool;
import com.lizardtech.djvu.DjVuInterface;
import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvu.IFFEnumeration;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;

public class CachedInputStream
extends InputStream
implements DjVuInterface,
Cloneable {
    private DataPool buffer = null;
    private int markOffset = 0;
    private int offset = 0;
    private int endOffset = 0;
    private int blockIndex = -1;
    private byte[] block = null;
    private DjVuObject djvuObject = new DjVuObject();
    private String name = null;
    static /* synthetic */ Class class$com$lizardtech$djvu$CachedInputStream;

    public static CachedInputStream createCachedInputStream(DjVuInterface djVuInterface) {
        DjVuOptions djVuOptions = djVuInterface.getDjVuOptions();
        return (CachedInputStream)DjVuObject.create(djVuOptions, djVuOptions.getCachedInputStreamClass(), class$com$lizardtech$djvu$CachedInputStream == null ? (class$com$lizardtech$djvu$CachedInputStream = CachedInputStream.class$("com.lizardtech.djvu.CachedInputStream")) : class$com$lizardtech$djvu$CachedInputStream);
    }

    public void setDjVuOptions(DjVuOptions djVuOptions) {
        this.djvuObject.setDjVuOptions(djVuOptions);
    }

    public DjVuOptions getDjVuOptions() {
        return this.djvuObject.getDjVuOptions();
    }

    public CachedInputStream createCachedInputStream(int n) {
        CachedInputStream cachedInputStream = (CachedInputStream)this.clone();
        cachedInputStream.setSize(n);
        return cachedInputStream;
    }

    public CachedInputStream init(DataPool dataPool, int n, int n2) {
        this.buffer = dataPool;
        this.markOffset = this.offset = n;
        this.endOffset = n2;
        return this;
    }

    public CachedInputStream init(URL uRL, boolean bl) {
        return this.init(DataPool.createDataPool(this).init(uRL), 0, Integer.MAX_VALUE);
    }

    public CachedInputStream init(InputStream inputStream) {
        if (inputStream instanceof CachedInputStream) {
            CachedInputStream cachedInputStream = (CachedInputStream)inputStream;
            return this.init(cachedInputStream.buffer, cachedInputStream.offset, cachedInputStream.getEndOffset());
        }
        return this.init(DataPool.createDataPool(this).init(inputStream), 0, Integer.MAX_VALUE);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int getEndOffset() {
        int n = this.buffer.getEndOffset();
        return n < this.endOffset ? n : this.endOffset;
    }

    public synchronized void setSize(int n) {
        long l = this.offset + n;
        if (l < (long)this.endOffset) {
            this.endOffset = (int)l;
        }
    }

    public int available() {
        int n = this.buffer.getCurrentSize();
        int n2 = n < this.endOffset ? n : this.endOffset;
        return n2 > 0 ? n2 : 0;
    }

    public void mark(int n) {
        this.markOffset = this.offset;
    }

    public boolean markSuppoted() {
        return true;
    }

    public int read() {
        int n = -1;
        int n2 = this.offset / 8192;
        if (n2 != this.blockIndex) {
            this.block = this.buffer.getBlock(n2, true);
            this.blockIndex = n2;
            if (this.block == null) {
                this.offset = this.getEndOffset();
                this.blockIndex = -1;
            }
        }
        if (this.offset < this.getEndOffset()) {
            n = 0xFF & this.block[this.offset++ % 8192];
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) {
        int n3 = -1;
        int n4 = this.offset / 8192;
        if (n4 != this.blockIndex) {
            this.block = this.buffer.getBlock(n4, true);
            this.blockIndex = n4;
            if (this.block == null) {
                this.offset = this.getEndOffset();
                this.blockIndex = -1;
            }
        }
        if (this.offset < this.getEndOffset()) {
            int n5 = this.offset % 8192;
            n3 = 8192 - n5;
            if (n3 > n2) {
                n3 = n2;
            }
            System.arraycopy(this.block, n5, byArray, n, n3);
            this.offset += n3;
        }
        return n3;
    }

    public int read(byte[] byArray) {
        int n;
        for (int i = byArray.length; i > 0; i -= n) {
            int n2 = byArray.length - i;
            n = this.read(byArray, n2, i);
            if (n >= 0) continue;
            return n2 > 0 ? n2 : -1;
        }
        return byArray.length;
    }

    public int read16() {
        int n = this.read();
        if (n < 0) {
            return n;
        }
        int n2 = this.read();
        return n2 >= 0 ? n << 8 | n2 : -1;
    }

    public int read24() {
        int n = this.read16();
        if (n < 0) {
            return n;
        }
        int n2 = this.read();
        return n2 >= 0 ? n << 8 | n2 : -1;
    }

    public void reset() throws IOException {
        this.offset = this.markOffset;
    }

    public long skip(long l) {
        int n;
        int n2 = this.getEndOffset();
        int n3 = n = (long)n2 <= l + (long)this.offset ? n2 - this.offset : (int)l;
        if (n > 0) {
            this.offset += n;
        } else {
            n = 0;
        }
        return n;
    }

    public void prefetchWait() {
        try {
            for (int i = this.offset / 8192; i < this.getEndOffset() / 8192; ++i) {
                this.buffer.getBlock(i, true);
            }
            this.buffer.getBlock((this.getEndOffset() - 1) / 8192, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String readSizedUTF(int n) throws IOException {
        String string = this.createCachedInputStream(n).readFullyUTF();
        this.skip(n);
        return string;
    }

    public String readFullyUTF() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        int n = this.read();
        while (n >= 0) {
            byteArrayOutputStream.write(n);
            n = this.read();
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        try {
            if (byArray.length > 65537) {
                return new String(byArray, 2, byArray.length - 2, "UTF-8");
            }
            byArray[0] = (byte)(byArray.length - 2 >> 8);
            byArray[1] = (byte)(byArray.length - 2 & 0xFF);
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            return dataInputStream.readUTF();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(DjVuOptions.err);
            System.gc();
            return new String(byArray, 2, byArray.length - 2);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isDjVuFile() {
        byte[] byArray = this.buffer.getBlock(0, true);
        return byArray != null && byArray[0] == 65 && byArray[1] == 84 && byArray[2] == 38 && byArray[3] == 84;
    }

    public Enumeration getIFFChunks() {
        IFFEnumeration iFFEnumeration = null;
        if (this.name == null || this.name.length() != 4) {
            iFFEnumeration = IFFEnumeration.createIFFEnumeration(this).init(this);
        }
        return iFFEnumeration;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

