/*
 * Decompiled with CFR 0.152.
 */
package com.scotty1024.iliadviewer.djvuviewer;

import com.irex.mobipocket.reader.Utils;
import com.irex.sdk.ErIpcCmd;
import com.irex.sdk.ErIpcServer;
import com.irex.sdk.ErPageBar;
import com.irex.sdk.IpcServerCallBack;
import com.irex.sdk.ViewerSignal;
import com.lizardtech.djvu.Document;
import com.lizardtech.djvubean.DjVuBean;
import com.lizardtech.djvubean.DjVuViewport;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.DatagramPacket;
import java.net.URL;
import org.kxml2.io.KXmlParser;

public class DJVUViewer
extends Frame
implements PropertyChangeListener,
IpcServerCallBack,
KeyListener {
    private ErIpcServer m_ersrv;
    private ErPageBar pagebar;
    private int IREX_READER_UA_ID = 110;
    public static final int FIT_WIDTH = -1;
    public static final int FIT_PAGE = -2;
    public static final String IMAGE_STRING = "Image";
    public static final String TEXT_STRING = "Text";
    public CardLayout cardLayout = null;
    protected Container scrollPane = null;
    protected Document document = null;
    protected int documentSize = -1;
    protected URL url = null;
    protected boolean first = true;
    protected boolean useScrollPane = false;
    protected int scale = 100;
    private Component splitPane = null;
    private Container centerPane = null;
    private DjVuBean djvuBean = null;
    private Object parentRef = null;
    private boolean validDjVu = false;
    private static DJVUViewer viewer = null;
    protected String settingsName = null;
    protected int curPage = 1;
    static /* synthetic */ Class class$com$scotty1024$iliadviewer$djvuviewer$DJVUViewer;

    public static void main(String[] stringArray) {
        viewer = new DJVUViewer(stringArray[0]);
    }

    public DJVUViewer(String string) {
        System.out.println("url: " + string);
        try {
            long l = System.currentTimeMillis();
            System.out.println((class$com$scotty1024$iliadviewer$djvuviewer$DJVUViewer == null ? (class$com$scotty1024$iliadviewer$djvuviewer$DJVUViewer = DJVUViewer.class$("com.scotty1024.iliadviewer.djvuviewer.DJVUViewer")) : class$com$scotty1024$iliadviewer$djvuviewer$DJVUViewer).getName() + " loaded");
            this.url = new URL("file:///" + string);
            this.settingsName = string.substring(0, string.length() - 4) + "mbp";
            System.out.println("Settings name: " + this.settingsName);
            this.loadSettings();
            DjVuBean djVuBean = this.getDjVuBean();
            ((Component)this).setSize(768, 935);
            Dimension dimension = this.getToolkit().getScreenSize();
            djVuBean.addPropertyChangeListener(this);
            this.setLayout(new BorderLayout());
            Component component = null;
            if (component != null) {
                this.add(component, "North");
            }
            this.documentSize = djVuBean.getDocumentSize();
            this.add(this.getSplitPane(djVuBean.getOutline(), this.getCenterPane()), "Center");
            Dimension dimension2 = this.getSize();
            if (dimension2 != null) {
                djVuBean.setTargetWidth(dimension2.width);
            }
            this.validDjVu = true;
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.out.println("Program closing.");
                    DJVUViewer.this.saveSettings();
                    System.exit(0);
                }
            });
            this.m_ersrv = ErIpcServer.getInstanceByChannelId((int)15, (IpcServerCallBack)this);
            if (this.m_ersrv == null) {
                System.out.print("Opening connection to ErIpcServer failed.");
                throw new Exception("Couldn't connect to ErIpcServer.");
            }
            this.m_ersrv.startServer();
            this.pagebar = ErPageBar.getInstance();
            if (this.pagebar == null) {
                System.out.println("pagebar client create error");
                System.exit(1);
            } else {
                this.pagebar.pbReset(this.IREX_READER_UA_ID);
                this.pagebar.pbSetPageCount(this.IREX_READER_UA_ID, this.documentSize);
                this.pagebar.pbSetCurrentPage(this.IREX_READER_UA_ID, this.curPage);
                this.pagebar.pbRedraw(this.IREX_READER_UA_ID);
            }
            this.addKeyListener(this);
            this.requestFocus();
            ((Component)this).setVisible(true);
            long l2 = System.currentTimeMillis() - l;
            String string2 = "000" + l2;
            System.out.println("Viewer initialized in " + l2 / 1000L + "." + string2.substring(string2.length() - 3) + " seconds");
            this.getDjVuBean().setPage(this.curPage);
        }
        catch (Throwable throwable) {
            this.validDjVu = false;
            this.removeAll();
            throwable.printStackTrace();
        }
    }

    public DjVuBean getDjVuBean() throws IOException {
        DjVuBean djVuBean = this.djvuBean;
        if (djVuBean == null) {
            try {
                djVuBean = this.djvuBean = new DjVuBean();
                djVuBean.setURL(this.url);
            }
            catch (Throwable throwable) {
                System.out.println("Failed to setURL");
                throwable.printStackTrace();
                System.exit(1);
            }
        }
        return djVuBean;
    }

    public Component getScrollPane() throws IOException {
        Container container = this.scrollPane;
        if (container == null) {
            DjVuBean djVuBean = this.getDjVuBean();
            if (djVuBean instanceof DjVuViewport) {
                container = new Container();
                container.setLayout(new BorderLayout());
                container.add("East", ((DjVuViewport)djVuBean).getScrollbar(1));
                container.add("South", ((DjVuViewport)djVuBean).getScrollbar(0));
                container.add("Center", djVuBean);
            } else {
                djVuBean.setBackground(new Color(128, 128, 128));
                return djVuBean;
            }
        }
        return container;
    }

    public Component getSplitPane(Component component, Component component2) {
        if (component == null) {
            return component2;
        }
        if (component2 == null) {
            return component;
        }
        Container container = new Container();
        container.setLayout(new BorderLayout());
        container.add(component, "West");
        container.add(component2, "Center");
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Container getCenterPane() throws IOException {
        Container container = this.centerPane;
        if (container == null) {
            DJVUViewer dJVUViewer = this;
            synchronized (dJVUViewer) {
                container = this.centerPane;
                if (container == null) {
                    container = new Container();
                    container.setBackground(new Color(128, 128, 128));
                    CardLayout cardLayout = new CardLayout();
                    container.setLayout(cardLayout);
                    container.add(IMAGE_STRING, this.getScrollPane());
                    this.centerPane = container;
                    this.cardLayout = cardLayout;
                }
            }
        }
        return container;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void messageReceived(DatagramPacket datagramPacket) {
        ErIpcCmd erIpcCmd = ViewerSignal.parseCommand((String)new String(datagramPacket.getData(), 0, datagramPacket.getLength()));
        if (erIpcCmd == null) {
            System.out.print("Invalid ErIpcCmd message.");
            return;
        }
        if (erIpcCmd.get_cmdcode() == 0) {
            String[] stringArray = erIpcCmd.get_args();
            int n = 0;
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (Throwable throwable) {
                System.out.println("Got invalid ErIpcCmd message argument.");
                return;
            }
            Utils.busyBlink();
            this.movePage(n);
        } else {
            System.out.println("Ignore ErIpcCmd message of code: " + erIpcCmd.get_cmdcode());
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 116: {
                Utils.busyBlink();
                System.out.println("VK_F5 Quiting.");
                this.saveSettings();
                System.exit(0);
                break;
            }
            case 36: {
                this.moveRelativePage(1);
                break;
            }
            case 34: {
                this.moveRelativePage(1);
                break;
            }
            case 112: {
                this.moveRelativePage(5);
                break;
            }
            case 33: {
                this.moveRelativePage(-1);
                break;
            }
            case 113: {
                this.moveRelativePage(-5);
                break;
            }
        }
        keyEvent.consume();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    protected void moveRelativePage(int n) {
        try {
            this.movePage(this.getDjVuBean().getPage() + n);
        }
        catch (IOException iOException) {
            System.out.println("Error trying to set page number.");
            iOException.printStackTrace();
        }
    }

    protected void movePage(int n) {
        if (n < 1) {
            n = 1;
        } else if (n > this.documentSize) {
            n = this.documentSize;
        }
        try {
            if (this.getDjVuBean().getPage() != n) {
                Utils.busyBlink();
                this.getDjVuBean().setPage(n);
                this.pagebar.pbSetCurrentPage(this.IREX_READER_UA_ID, n);
                this.pagebar.pbRedraw(this.IREX_READER_UA_ID);
            }
        }
        catch (IOException iOException) {
            System.out.println("Error trying to set page number.");
            iOException.printStackTrace();
        }
    }

    protected void loadSettings() {
        try {
            KXmlParser kXmlParser = new KXmlParser();
            FileInputStream fileInputStream = new FileInputStream(this.settingsName);
            kXmlParser.setInput((InputStream)fileInputStream, "utf-8");
            kXmlParser.nextTag();
            kXmlParser.require(2, null, "text");
            String string = kXmlParser.getAttributeValue(null, "page");
            this.curPage = Integer.parseInt(string);
            System.out.println("Loaded page number: " + this.curPage);
            ((InputStream)fileInputStream).close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void saveSettings() {
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(this.settingsName));
            printWriter.println("<text page=\"" + this.getDjVuBean().getPage() + "\" />");
            printWriter.close();
            System.out.println("Saved page number: " + this.curPage);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

