/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvubean;

import com.lizardtech.djvu.DjVuInfo;
import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvu.DjVuPage;
import com.lizardtech.djvu.GMap;
import com.lizardtech.djvu.GRect;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.awt.image.ReplicateScaleFilter;
import java.util.Hashtable;

public final class DjVuFilter
extends ImageFilter
implements Runnable {
    private static final int INTEREST_RECT = 0;
    private static final int FULL_RECT = 1;
    private static final int BUFFER_RECT = 2;
    private static final int PAGE_RECT = 3;
    private static final int LAST_RENDERED_RECT = 4;
    private static final int PROGRESSIVE_THREAD = 0;
    private static final int SCROLL_THREAD = 0;
    private static final int NEWPIXEL_THREAD = 1;
    private static final int PROGRESSIVE_FLAG = 0;
    private static final int NEWPIXELS_FLAG = 1;
    public static final ColorModel RGB_MODEL = ColorModel.getRGBdefault();
    public static final ColorModel GRAY_MODEL = new DirectColorModel(8, 255, 255, 255);
    public final DjVuInfo info;
    public final DjVuPage page;
    public final boolean animated;
    protected final Point position = new Point();
    protected final int fullHeight;
    protected final int fullWidth;
    protected final int subsample;
    protected final double sx;
    protected final double sy;
    private final Dimension pageSize;
    private final Hashtable imageTable = new Hashtable();
    private final MemoryImageSource source;
    private final Rectangle bounds;
    private final boolean[] flags = new boolean[]{false, false};
    private final GMap[] mapArray = new GMap[]{null, null};
    private final ImageProducer[] producer = new ImageProducer[]{null};
    private final Object[] reuseArray = new Object[]{null};
    private final GRect[] segmentArray = new GRect[]{null, null, null, null, null};
    private final Thread[] threadArray = new Thread[]{null, null};
    private final int bufferHeight;
    private final int bufferWidth;
    private final int deltaX;
    private final int deltaY;
    private int fillColor = -8355712;
    private boolean firstTime = true;
    static /* synthetic */ Class class$com$lizardtech$djvubean$DjVuFilter;

    public DjVuFilter(Rectangle rectangle, Dimension dimension, DjVuPage djVuPage, boolean bl) {
        this.info = djVuPage.getInfoWait();
        this.bounds = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.page = djVuPage;
        this.pageSize = dimension;
        this.animated = bl;
        this.source = new MemoryImageSource(1, 1, GRAY_MODEL, new byte[1], 0, 1);
        this.source.setAnimated(bl);
        this.source.setFullBufferUpdates(bl);
        this.flags[0] = bl;
        this.position.x = rectangle.x;
        this.position.y = rectangle.y;
        int n = 12;
        GRect gRect = null;
        while (true) {
            gRect = this.segmentArray[3] = new GRect(0, 0, (this.info.width + n - 1) / n, (this.info.height + n - 1) / n);
            if (n == 1 || gRect.xmax >= dimension.width && gRect.ymax >= dimension.height) break;
            --n;
        }
        this.subsample = n;
        this.sx = (double)this.info.width / ((double)dimension.width * (double)n);
        this.sy = (double)this.info.height / ((double)dimension.height * (double)n);
        this.fullWidth = (int)Math.ceil(this.sx * (double)rectangle.width);
        this.fullHeight = (int)Math.ceil(this.sy * (double)rectangle.height);
        if (bl) {
            this.bufferWidth = Math.min((int)Math.ceil(this.sx * (double)rectangle.width * 8.0 / 7.0), gRect.width());
            this.bufferHeight = Math.min((int)Math.ceil(this.sy * (double)rectangle.height * 8.0 / 7.0), gRect.height());
            this.deltaX = Math.max((1 + this.bufferWidth - this.fullWidth) / 2, 0);
            this.deltaY = Math.max((1 + this.bufferHeight - this.fullHeight) / 2, 0);
            if (djVuPage.isDecoding()) {
                this.threadArray[0] = new Thread(this);
                this.threadArray[0].start();
            } else {
                GRect gRect2 = this.segment();
                this.mapArray[0] = this.mapArray[1] = djVuPage.getMap(gRect2, n, null);
                this.segmentArray[2] = gRect2;
            }
        } else {
            this.deltaX = 0;
            this.deltaY = 0;
            this.bufferWidth = this.fullWidth;
            this.bufferHeight = this.fullHeight;
        }
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setDimensions(int n, int n2) {
        super.setDimensions(this.fullWidth, this.fullHeight);
    }

    public Image getImage(Component component) {
        Image image = (Image)DjVuObject.getFromReference(this.imageTable.get(component));
        if (image == null) {
            image = component.createImage(this.getImageProducer());
            this.imageTable.put(component, DjVuObject.createSoftReference(image, image));
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ImageProducer getImageProducer() {
        if (this.producer[0] != null) return this.producer[0];
        GMap[] gMapArray = this.mapArray;
        synchronized (this.mapArray) {
            if (this.producer[0] != null) return this.producer[0];
            FilteredImageSource filteredImageSource = new FilteredImageSource(this.source, this);
            this.producer[0] = this.fullWidth != this.bounds.width || this.fullHeight != this.bounds.height ? new FilteredImageSource(filteredImageSource, this.fullWidth < this.bounds.width ? new ReplicateScaleFilter(this.bounds.width, this.bounds.height) : new AreaAveragingScaleFilter(this.bounds.width, this.bounds.height)) : filteredImageSource;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.producer[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int n7;
        Object[] objectArray;
        GMap gMap = null;
        GRect gRect = null;
        GRect gRect2 = null;
        GRect gRect3 = null;
        if (!this.animated && this.mapArray[0] == null) {
            objectArray = this.mapArray;
            // MONITORENTER : this.mapArray
            if (this.mapArray[0] == null) {
                try {
                    this.page.waitForCodec(this.page.doneLock, 0L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                gRect = this.segment();
                gMap = this.page.getMap(gRect, this.subsample, null);
                this.segmentArray[2] = gRect;
                this.segmentArray[4] = null;
                this.mapArray[0] = gMap;
                this.mapArray[1] = null;
                gRect2 = this.segmentArray[0];
                gRect = this.segmentArray[2];
                gRect3 = this.segmentArray[1];
            }
            // MONITOREXIT : objectArray
        }
        if (gMap == null) {
            objectArray = this.mapArray;
            // MONITORENTER : this.mapArray
            gMap = this.mapArray[0];
            gRect2 = this.segmentArray[0];
            gRect = this.segmentArray[2];
            gRect3 = this.segmentArray[1];
            if (gMap == null || gRect3 == null || gRect == null || gRect3.isEmpty() || !gRect.contains(gRect2)) {
                if (!this.firstTime) {
                    // MONITOREXIT : objectArray
                    return;
                }
                gRect2 = new GRect();
            } else {
                this.segmentArray[4] = gRect3;
            }
            this.mapArray[1] = null;
            // MONITOREXIT : objectArray
        }
        this.firstTime = false;
        objectArray = new int[this.fullWidth];
        if (gRect2.isEmpty()) {
            GMap[] gMapArray = this.mapArray;
            // MONITORENTER : this.mapArray
            this.mapArray[1] = this.mapArray[0];
            // MONITOREXIT : gMapArray
            int n8 = 0;
            while (n8 < this.fullWidth) {
                objectArray[n8++] = (GMap)this.fillColor;
            }
            n8 = 0;
            while (n8 < this.fullHeight) {
                super.setPixels(0, n8++, this.fullWidth, 1, RGB_MODEL, (int[])objectArray, 0, this.fullWidth);
            }
            return;
        }
        int n9 = gRect2.width();
        int n10 = gRect2.xmin - gRect3.xmin;
        int n11 = 0;
        int n12 = gRect2.height();
        int n13 = gRect3.ymax - gRect2.ymax;
        int n14 = gRect2.ymin - gRect3.ymin;
        if (n13 > 0) {
            n7 = 0;
            while (n7 < this.fullWidth) {
                objectArray[n7++] = (GMap)this.fillColor;
            }
            do {
                super.setPixels(0, n11++, this.fullWidth, 1, RGB_MODEL, (int[])objectArray, 0, this.fullWidth);
            } while (--n13 > 0);
        }
        if (n12 > 0) {
            n7 = 0;
            while (n7 < n10) {
                objectArray[n7++] = (GMap)this.fillColor;
            }
            n7 = n10 + n9;
            while (n7 < this.fullWidth) {
                objectArray[n7++] = (GMap)this.fillColor;
            }
            n7 = gRect.ymax - gRect2.ymax;
            int n15 = gRect2.xmin - gRect.xmin;
            do {
                gMap.fillRGBPixels(n15, n7++, n9, 1, (int[])objectArray, n10, this.fullWidth);
                super.setPixels(0, n11++, this.fullWidth, 1, RGB_MODEL, (int[])objectArray, 0, this.fullWidth);
            } while (--n12 > 0);
        }
        GMap[] gMapArray = this.mapArray;
        // MONITORENTER : this.mapArray
        this.mapArray[1] = this.mapArray[0];
        // MONITOREXIT : gMapArray
        if (n14 <= 0) return;
        int n16 = 0;
        while (n16 < this.fullWidth) {
            objectArray[n16++] = (GMap)this.fillColor;
        }
        do {
            super.setPixels(0, n11++, this.fullWidth, 1, RGB_MODEL, (int[])objectArray, 0, this.fullWidth);
        } while (--n14 > 0);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        this.setPixels(n, n2, n3, n4, colorModel, (byte[])null, n5, n6);
    }

    public Dimension getSize() {
        return this.pageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void move(int n, int n2) {
        boolean bl = false;
        Point point = this.position;
        if (point.x == n && point.y == n2) return;
        if (!this.animated) {
            throw new IllegalStateException((class$com$lizardtech$djvubean$DjVuFilter == null ? (class$com$lizardtech$djvubean$DjVuFilter = DjVuFilter.class$("com.lizardtech.djvubean.DjVuFilter")) : class$com$lizardtech$djvubean$DjVuFilter).getName() + " animated=false");
        }
        GMap[] gMapArray = this.mapArray;
        synchronized (this.mapArray) {
            if (point.x != n || point.y != n2) {
                GRect gRect = this.segmentArray[1];
                point.x = n;
                point.y = n2;
                this.segment();
                if (this.source != null && gRect != null && !gRect.equals(this.segmentArray[1])) {
                    bl = true;
                    this.mapArray.notifyAll();
                    if (this.threadArray[0] == null) {
                        this.threadArray[0] = new Thread(this);
                        this.threadArray[0].start();
                    }
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (!bl) return;
            this.newPixels();
            return;
        }
    }

    public void run() {
        try {
            Thread thread = Thread.currentThread();
            if (thread == this.threadArray[1]) {
                this.newPixelRun();
            }
            if (thread == this.threadArray[0] && this.flags[0]) {
                this.progressiveRun();
            }
            if (this.threadArray[0] == thread) {
                this.scrollRun();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(DjVuOptions.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void newPixels() {
        this.flags[1] = true;
        if (this.source != null) {
            if (this.animated) {
                MemoryImageSource memoryImageSource = this.source;
                synchronized (memoryImageSource) {
                    this.source.notifyAll();
                    if (this.threadArray[1] == null) {
                        this.threadArray[1] = new Thread(this);
                        this.threadArray[1].start();
                    }
                }
            } else {
                this.newPixels();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void newPixelRun() {
        Thread thread = Thread.currentThread();
        if (this.source == null) return;
        int n = 0;
        while (true) {
            if (this.threadArray[1] != thread) {
                return;
            }
            if (this.flags[1]) {
                n = 0;
                this.flags[1] = false;
                this.source.newPixels();
                try {
                    Thread.sleep(20L);
                }
                catch (Throwable throwable) {}
                continue;
            }
            GMap[] gMapArray = this.mapArray;
            // MONITORENTER : this.mapArray
            if (!this.flags[1]) break;
            // MONITOREXIT : gMapArray
        }
        if (n++ > 0) {
            this.threadArray[1] = null;
            // MONITOREXIT : gMapArray
            return;
        }
        this.source.wait(200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void progressiveRun() {
        boolean bl;
        Thread thread = Thread.currentThread();
        GRect gRect = null;
        do {
            GMap[] gMapArray;
            boolean bl2;
            bl = bl2 = this.page.isDecoding();
            Object object = this.mapArray;
            // MONITORENTER : this.mapArray
            GMap gMap = this.mapArray[0];
            GRect gRect2 = this.segment();
            GRect gRect3 = this.segmentArray[1];
            // MONITOREXIT : object
            object = this.page.updateMap(gMap, gRect2, this.subsample);
            if (object != null && gMap != object) {
                gMapArray = this.mapArray;
                // MONITORENTER : this.mapArray
                this.reuseArray[0] = DjVuObject.createSoftReference(this.mapArray[1], this.mapArray[1]);
                this.mapArray[1] = object;
                this.mapArray[0] = object;
                this.segmentArray[2] = gRect2;
                gRect = null;
                this.segmentArray[4] = null;
                // MONITOREXIT : gMapArray
                this.newPixels();
                gRect = gRect3;
                if (DjVuOptions.COLLECT_GARBAGE) {
                    System.gc();
                }
                bl = true;
            } else if (!gRect3.equals(gRect)) {
                this.newPixels();
                gRect = gRect3;
            }
            if (!bl2) continue;
            this.page.waitForCodec(this.page.progressiveLock, 0L);
            if (object == null) continue;
            gMapArray = this.mapArray;
            // MONITORENTER : this.mapArray
            gRect2 = this.segment();
            gRect3 = this.segmentArray[1];
            // MONITOREXIT : gMapArray
            if (!gRect3.equals(gRect)) continue;
            try {
                this.page.waitForCodec(this.page.doneLock, 500L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        } while (bl);
        this.flags[0] = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void scrollRun() {
        Thread thread = Thread.currentThread();
        GRect gRect = new GRect();
        GRect gRect2 = new GRect();
        int n = 0;
        while (true) {
            GMap[] gMapArray = this.mapArray;
            // MONITORENTER : this.mapArray
            GMap gMap = this.mapArray[0];
            GRect gRect3 = this.segment();
            GRect gRect4 = this.segmentArray[2];
            if (gRect4 == null) {
                gRect4 = gRect3;
            }
            if (gRect4.contains(gRect3)) {
                gMap = null;
                if (this.threadArray[0] != thread) {
                    // MONITOREXIT : gMapArray
                    return;
                }
                if (n++ > 1) {
                    this.threadArray[0] = null;
                    // MONITOREXIT : gMapArray
                    return;
                }
                this.mapArray.wait(200L);
            }
            // MONITOREXIT : gMapArray
            n = 0;
            try {
                Object object;
                gRect2.intersect(gRect4, gRect3);
                if (gRect2.xmin == gRect3.xmin) {
                    gRect2.xmin = gRect4.xmax;
                    gRect2.xmax = gRect3.xmax;
                } else {
                    gRect2.xmin = gRect3.xmin;
                    gRect2.xmax = gRect4.xmin;
                }
                gRect.xmin = gRect3.xmin;
                gRect.xmax = gRect3.xmax;
                if (gRect2.ymin == gRect3.ymin) {
                    gRect.ymin = gRect4.ymax;
                    gRect.ymax = gRect3.ymax;
                } else {
                    gRect.ymin = gRect3.ymin;
                    gRect.ymax = gRect4.ymin;
                }
                double d = Math.sqrt(gRect.area());
                double d2 = Math.sqrt(gRect2.area());
                double d3 = Math.sqrt(gRect3.area());
                double d4 = gRect.isEmpty() || gRect2.isEmpty() ? 0.9 : 0.8;
                GMap gMap2 = (GMap)DjVuObject.getFromReference(this.reuseArray[0]);
                this.reuseArray[0] = null;
                if (gMap != null && d + d2 < d4 * d3) {
                    gMap = gMap.translate(gRect3.xmin - gRect4.xmin, gRect3.ymin - gRect4.ymin, gMap2);
                    if (!gRect.isEmpty()) {
                        object = this.page.getMap(gRect, this.subsample, null);
                        gMap.fill((GMap)object, gRect.xmin - gRect3.xmin, gRect.ymin - gRect3.ymin);
                    }
                    if (!gRect2.isEmpty()) {
                        object = this.page.getMap(gRect2, this.subsample, null);
                        gMap.fill((GMap)object, gRect2.xmin - gRect3.xmin, gRect2.ymin - gRect3.ymin);
                    }
                } else {
                    gMap = this.page.getMap(gRect3, this.subsample, gMap2);
                }
                if (gMap != null) {
                    object = this.mapArray;
                    // MONITORENTER : this.mapArray
                    this.reuseArray[0] = DjVuObject.createSoftReference(this.mapArray[1], this.mapArray[1]);
                    this.mapArray[0] = this.mapArray[1] = gMap;
                    this.segmentArray[2] = gRect3;
                    // MONITOREXIT : object
                }
                this.newPixels();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(DjVuOptions.err);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GRect segment() {
        GRect gRect = null;
        GMap[] gMapArray = this.mapArray;
        synchronized (this.mapArray) {
            int n = this.bounds.x = this.position.x;
            this.bounds.y = this.position.y;
            int n2 = this.pageSize.height - this.bounds.y - this.bounds.height;
            if (this.subsample != 0) {
                GRect gRect2;
                GRect gRect3 = this.segmentArray[3];
                int n3 = (int)Math.floor(this.sx * (double)n);
                int n4 = (int)Math.floor(this.sy * (double)n2);
                this.segmentArray[1] = gRect2 = new GRect(n3, n4, this.fullWidth, this.fullHeight);
                GRect gRect4 = new GRect();
                gRect4.intersect(gRect3, gRect2);
                this.segmentArray[0] = gRect4;
                if (this.animated) {
                    int n5 = Math.max(0, Math.min(gRect3.xmax - this.bufferWidth, Math.min(Math.max(gRect4.xmax - this.bufferWidth, n3 - this.deltaX), gRect4.xmin)));
                    int n6 = Math.max(0, Math.min(gRect3.ymax - this.bufferHeight, Math.min(Math.max(gRect4.ymax - this.bufferHeight, n4 - this.deltaY), gRect4.ymin)));
                    gRect = new GRect(n5, n6, this.bufferWidth, this.bufferHeight);
                } else {
                    gRect = gRect4;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return gRect;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

