/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu;

import com.lizardtech.djvu.BitContext;
import com.lizardtech.djvu.DjVuInterface;
import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvu.GBitmap;
import com.lizardtech.djvu.JB2Blit;
import com.lizardtech.djvu.JB2Codec;
import com.lizardtech.djvu.JB2Dict;
import com.lizardtech.djvu.JB2Image;
import com.lizardtech.djvu.NumContext;
import com.lizardtech.djvu.ZPCodec;
import java.io.IOException;
import java.io.InputStream;

public class JB2Decode
extends JB2Codec {
    protected final BitContext zpBitHolder = new BitContext();
    private GBitmap refBitmap;
    private JB2Dict zdict = null;
    private ZPCodec zp = null;
    static /* synthetic */ Class class$com$lizardtech$djvu$JB2Decode;

    public JB2Decode() {
        super(false);
    }

    public static JB2Decode createJB2Decode(DjVuInterface djVuInterface) {
        DjVuOptions djVuOptions = djVuInterface.getDjVuOptions();
        return (JB2Decode)DjVuObject.create(djVuOptions, djVuOptions.getJB2DecodeClass(), class$com$lizardtech$djvu$JB2Decode == null ? (class$com$lizardtech$djvu$JB2Decode = JB2Decode.class$("com.lizardtech.djvu.JB2Decode")) : class$com$lizardtech$djvu$JB2Decode);
    }

    public void code(JB2Image jB2Image) throws IOException {
        int n = 0;
        while ((n = this.code_record_B(n, jB2Image, null, null)) != 11) {
        }
        if (!this.gotstartrecordp) {
            throw new IllegalStateException("JB2Image no start");
        }
    }

    public void code(JB2Dict jB2Dict) throws IOException {
        int n = 0;
        while ((n = this.code_record_A(n, jB2Dict, null)) != 11) {
        }
        if (!this.gotstartrecordp) {
            throw new IllegalStateException("JB2Image no start");
        }
    }

    public void init(InputStream inputStream, JB2Dict jB2Dict) throws IOException {
        this.zdict = jB2Dict;
        this.zp = new ZPCodec(inputStream);
    }

    protected final boolean codeBit(boolean bl, BitContext bitContext) throws IOException {
        return this.zp.decoder(bitContext) != 0;
    }

    protected final int codeBit(boolean bl, byte[] byArray, int n) throws IOException {
        this.zpBitHolder.set(byArray[n]);
        int n2 = this.zp.decoder(this.zpBitHolder);
        byArray[n] = this.zpBitHolder.bit;
        return n2;
    }

    protected int codeNum(int n, int n2, NumContext numContext) throws IOException {
        return this.codeNum(n, n2, numContext, 0);
    }

    protected void code_absolute_location(JB2Blit jB2Blit, int n, int n2) throws IOException {
        if (!this.gotstartrecordp) {
            throw new IllegalStateException("JB2Image no start");
        }
        int n3 = this.codeNum(1, this.image_columns, this.abs_loc_x);
        int n4 = this.codeNum(1, this.image_rows, this.abs_loc_y);
        jB2Blit.bottom(n4 - n);
        jB2Blit.left(n3 - 1);
    }

    protected void code_absolute_mark_size(GBitmap gBitmap, int n) throws IOException {
        int n2 = this.codeNum(0, 262142, this.abs_size_x);
        int n3 = this.codeNum(0, 262142, this.abs_size_y);
        if (n2 != (0xFFFF & n2) || n3 != (0xFFFF & n3)) {
            throw new IllegalStateException("JB2Image bad number");
        }
        gBitmap.init(n3, n2, n);
    }

    protected void code_bitmap_by_cross_coding(GBitmap gBitmap, GBitmap gBitmap2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) throws IOException {
        while (n3 >= 0) {
            int n10 = this.get_cross_context(gBitmap, gBitmap2, n5, n6, n7, n8, n9, 0);
            int n11 = 0;
            while (n11 < n2) {
                int n12 = this.codeBit(false, this.cbitdist, n10);
                gBitmap.setByteAt(n6 + n11++, n12);
                n10 = this.shift_cross_context(gBitmap, gBitmap2, n10, n12, n5, n6, n7, n8, n9, n11);
            }
            n5 = n6;
            n6 = gBitmap.rowOffset(--n3);
            n7 = n8;
            n8 = n9;
            n9 = gBitmap2.rowOffset(--n4 - 1) + n;
        }
    }

    protected void code_bitmap_directly(GBitmap gBitmap, int n, int n2, int n3, int n4, int n5) throws IOException {
        while (n2 >= 0) {
            int n6 = this.get_direct_context(gBitmap, n3, n4, n5, 0);
            int n7 = 0;
            while (n7 < n) {
                int n8 = this.codeBit(false, this.bitdist, n6);
                gBitmap.setByteAt(n5 + n7++, n8);
                n6 = this.shift_direct_context(gBitmap, n6, n8, n3, n4, n5, n7);
            }
            n3 = n4;
            n4 = n5;
            n5 = gBitmap.rowOffset(--n2);
        }
    }

    protected String code_comment(String string) throws IOException {
        int n = this.codeNum(0, 262142, this.dist_comment_length);
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)this.codeNum(0, 255, this.dist_comment_byte);
        }
        return new String(byArray);
    }

    protected void code_image_size(JB2Dict jB2Dict) throws IOException {
        int n = this.codeNum(0, 262142, this.image_size_dist);
        int n2 = this.codeNum(0, 262142, this.image_size_dist);
        if (n != 0 || n2 != 0) {
            throw new IllegalStateException("JB2Image bad dict 2");
        }
        super.code_image_size(jB2Dict);
    }

    protected void code_image_size(JB2Image jB2Image) throws IOException {
        this.image_columns = this.codeNum(0, 262142, this.image_size_dist);
        this.image_rows = this.codeNum(0, 262142, this.image_size_dist);
        if (this.image_columns == 0 || this.image_rows == 0) {
            throw new IllegalStateException("JB2Image zero size");
        }
        jB2Image.width = this.image_columns;
        jB2Image.height = this.image_rows;
        super.code_image_size(jB2Image);
    }

    protected void code_inherited_shape_count(JB2Dict jB2Dict) throws IOException {
        int n = this.codeNum(0, 262142, this.inherited_shape_count_dist);
        JB2Dict jB2Dict2 = jB2Dict.get_inherited_dict();
        if (jB2Dict2 == null && n > 0) {
            if (this.zdict != null) {
                jB2Dict2 = this.zdict;
                jB2Dict.set_inherited_dict(jB2Dict2);
            } else {
                throw new IllegalStateException("JB2Image need dict");
            }
        }
        if (jB2Dict2 != null && n != jB2Dict2.get_shape_count()) {
            throw new IllegalStateException("JB2Image bad dict");
        }
    }

    protected int code_match_index(int n, JB2Dict jB2Dict) throws IOException {
        return this.codeNum(0, this.lib2shape.size() - 1, this.dist_match_index);
    }

    protected int code_record_type(int n) throws IOException {
        return this.codeNum(0, 11, this.dist_record_type);
    }

    protected void code_relative_mark_size(GBitmap gBitmap, int n, int n2, int n3) throws IOException {
        int n4 = this.codeNum(-262143, 262142, this.rel_size_x);
        int n5 = this.codeNum(-262143, 262142, this.rel_size_y);
        int n6 = n + n4;
        int n7 = n2 + n5;
        if (n6 != (0xFFFF & n6) || n7 != (0xFFFF & n7)) {
            throw new IllegalStateException("JB2Image bad number");
        }
        gBitmap.init(n7, n6, n3);
    }

    protected int get_diff(int n, NumContext numContext) throws IOException {
        return this.codeNum(-262143, 262142, numContext);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

