/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu;

import com.lizardtech.djvu.CachedInputStream;
import com.lizardtech.djvu.Codec;
import com.lizardtech.djvu.DjVuInterface;
import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvu.GPixelReference;
import com.lizardtech.djvu.GPixmap;
import com.lizardtech.djvu.GRect;
import com.lizardtech.djvu.IWCodec;
import com.lizardtech.djvu.IWMap;
import com.lizardtech.djvu.ZPCodec;
import java.io.IOException;

public class IWPixmap
extends DjVuObject
implements Codec {
    public static final int CRCBfull = 5;
    public static final int CRCBhalf = 3;
    public static final int CRCBMode = 1;
    public static final int CRCBnone = 2;
    public static final int CRCBnormal = 4;
    public static final float[][] rgb_to_ycc = new float[][]{{0.304348f, 0.608696f, 0.086956f}, {0.463768f, -0.405797f, -0.057971f}, {-0.173913f, -0.347826f, 0.521739f}};
    protected IWCodec cbcodec = null;
    protected IWCodec crcodec = null;
    protected IWCodec ycodec = null;
    protected IWMap cbmap = null;
    protected IWMap crmap = null;
    protected IWMap ymap = null;
    protected int cbytes = 0;
    protected int crcb_delay = 10;
    protected boolean crcb_half = false;
    protected int cserial = 0;
    protected int cslice = 0;
    static /* synthetic */ Class class$com$lizardtech$djvu$IWPixmap;

    public boolean isImageData() {
        return true;
    }

    public static IWPixmap createIWPixmap(DjVuInterface djVuInterface) {
        DjVuOptions djVuOptions = djVuInterface.getDjVuOptions();
        return (IWPixmap)DjVuObject.create(djVuOptions, djVuOptions.getIWPixmapClass(), class$com$lizardtech$djvu$IWPixmap == null ? (class$com$lizardtech$djvu$IWPixmap = IWPixmap.class$("com.lizardtech.djvu.IWPixmap")) : class$com$lizardtech$djvu$IWPixmap);
    }

    public void close_codec() {
        this.cbcodec = null;
        this.crcodec = null;
        this.ycodec = null;
        this.cserial = 0;
        this.cbytes = 0;
        this.cslice = 0;
        if (DjVuOptions.COLLECT_GARBAGE) {
            System.gc();
        }
    }

    public void decode(CachedInputStream cachedInputStream) throws IOException {
        int n;
        if (this.ycodec == null) {
            this.cserial = 0;
            this.cslice = 0;
            this.ymap = null;
        }
        if (cachedInputStream.read() != this.cserial) {
            throw new IOException("(IWPixmap::decode) Chunk does not bear expected serial number");
        }
        int n2 = this.cslice + cachedInputStream.read();
        if (this.cserial == 0) {
            int n3 = cachedInputStream.read();
            n = cachedInputStream.read();
            if ((n3 & 0x7F) != 1) {
                throw new IOException("(IWPixmap::decode) File has been compressed with an incompatible IWCodec");
            }
            if (n > 2) {
                throw new IOException("(IWPixmap::decode) File has been compressed with a more recent IWCodec");
            }
            int n4 = 5;
            if (n < 2) {
                n4 = 4;
            }
            int n5 = cachedInputStream.read() << 8;
            n5 |= cachedInputStream.read();
            int n6 = cachedInputStream.read() << 8;
            n6 |= cachedInputStream.read();
            this.crcb_delay = 0;
            this.crcb_half = false;
            int n7 = cachedInputStream.read();
            if (n >= 2) {
                this.crcb_delay = 0x7F & n7;
            }
            if (n >= 2) {
                boolean bl = this.crcb_half = (0x80 & n7) == 0;
            }
            if ((n3 & 0x80) != 0) {
                this.crcb_delay = -1;
            }
            this.ymap = IWMap.createIWMap(this).init(n5, n6);
            this.ycodec = IWCodec.createIWCodec(this).init(this.ymap);
            if (this.crcb_delay >= 0) {
                this.cbmap = IWMap.createIWMap(this).init(n5, n6);
                this.crmap = IWMap.createIWMap(this).init(n5, n6);
                this.cbcodec = IWCodec.createIWCodec(this).init(this.cbmap);
                this.crcodec = IWCodec.createIWCodec(this).init(this.crmap);
            }
        }
        ZPCodec zPCodec = ZPCodec.createZPCodec(this).init(cachedInputStream);
        n = 1;
        while (n != 0 && this.cslice < n2) {
            n = this.ycodec.code_slice(zPCodec);
            if (this.crcodec != null && this.cbcodec != null && this.crcb_delay <= this.cslice) {
                n |= this.cbcodec.code_slice(zPCodec);
                n |= this.crcodec.code_slice(zPCodec);
            }
            ++this.cslice;
        }
        ++this.cserial;
    }

    public int getHeight() {
        return this.ymap != null ? this.ymap.ih : 0;
    }

    public GPixmap getPixmap() {
        if (this.ymap == null) {
            return null;
        }
        int n = this.ymap.iw;
        int n2 = this.ymap.ih;
        int n3 = n * 3;
        byte[] byArray = new byte[n2 * n3];
        this.ymap.image(0, byArray, n3, 3, false);
        if (this.crmap != null && this.cbmap != null && this.crcb_delay >= 0) {
            this.cbmap.image(1, byArray, n3, 3, this.crcb_half);
            this.crmap.image(2, byArray, n3, 3, this.crcb_half);
        }
        GPixmap gPixmap = GPixmap.createGPixmap(this).init(byArray, n2, n);
        GPixelReference gPixelReference = gPixmap.createGPixelReference(0);
        int n4 = 0;
        while (n4 < n2) {
            gPixelReference.setOffset(n4++, 0);
            if (this.crmap != null && this.cbmap != null && this.crcb_delay >= 0) {
                gPixelReference.YCC_to_RGB(n);
                continue;
            }
            int n5 = n;
            while (n5-- > 0) {
                gPixelReference.setGray(127 - gPixelReference.getBlue());
                gPixelReference.incOffset();
            }
        }
        return gPixmap;
    }

    public GPixmap getPixmap(int n, GRect gRect, GPixmap gPixmap) {
        if (this.ymap == null) {
            return null;
        }
        if (gPixmap == null) {
            gPixmap = GPixmap.createGPixmap(this);
        }
        int n2 = gRect.width();
        int n3 = gRect.height();
        int n4 = n2 * 3;
        byte[] byArray = gPixmap.init((int)n3, (int)n2, null).data;
        this.ymap.image(n, gRect, 0, byArray, n4, 3, false);
        if (this.crmap != null && this.cbmap != null && this.crcb_delay >= 0) {
            this.cbmap.image(n, gRect, 1, byArray, n4, 3, this.crcb_half);
            this.crmap.image(n, gRect, 2, byArray, n4, 3, this.crcb_half);
        }
        GPixelReference gPixelReference = gPixmap.createGPixelReference(0);
        int n5 = 0;
        while (n5 < n3) {
            gPixelReference.setOffset(n5++, 0);
            if (this.crmap != null && this.cbmap != null && this.crcb_delay >= 0) {
                gPixelReference.YCC_to_RGB(n2);
                continue;
            }
            int n6 = n2;
            while (n6-- > 0) {
                gPixelReference.setGray(127 - gPixelReference.blueByte());
                gPixelReference.incOffset();
            }
        }
        return gPixmap;
    }

    public int getWidth() {
        return this.ymap != null ? this.ymap.iw : 0;
    }

    public int setCrcbDelay(int n) {
        if (n >= 0) {
            this.crcb_delay = n;
        }
        return this.crcb_delay;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

