/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu;

import com.lizardtech.djvu.DjVuInterface;
import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvu.GBitmap;
import com.lizardtech.djvu.GMap;
import com.lizardtech.djvu.GPixel;
import com.lizardtech.djvu.GPixelReference;
import com.lizardtech.djvu.GRect;

public class GPixmap
extends GMap
implements Cloneable {
    protected static final int[] invmap;
    protected static final int[] ctableI;
    protected static int[] ctable;
    protected static double lgamma;
    protected static final byte[] clip;
    protected static final Object[] multiplierRefArray;
    private final GPixelReference ref = this.createGPixelReference(-1);
    static /* synthetic */ Class class$com$lizardtech$djvu$GPixmap;

    public GPixmap() {
        super(3, 2, 1, 0, false);
    }

    public static GPixmap createGPixmap(DjVuInterface djVuInterface) {
        DjVuOptions djVuOptions = djVuInterface.getDjVuOptions();
        return (GPixmap)DjVuObject.create(djVuOptions, djVuOptions.getGPixmapClass(), class$com$lizardtech$djvu$GPixmap == null ? (class$com$lizardtech$djvu$GPixmap = GPixmap.class$("com.lizardtech.djvu.GPixmap")) : class$com$lizardtech$djvu$GPixmap);
    }

    public static synchronized int[] getColorCorrection(double d) {
        int[] nArray;
        if (d < 0.1 || d > 10.0) {
            DjVuOptions.err.println("(GPixmap::color_correct) Illegal parameter");
        }
        if (d < 1.001 && d > 0.999) {
            nArray = ctableI;
        } else {
            if (d != lgamma) {
                ctable = new int[256];
                for (int i = 0; i < 256; ++i) {
                    double d2 = (double)i / 255.0;
                    if (DjVuOptions.BEZIERGAMMA) {
                        double d3 = (Math.sqrt(1.0 + (d * d - 1.0) * d2) - 1.0) / (d - 1.0);
                        d2 = ((1.0 - d) * d3 + 2.0 * d) * d3 / (d + 1.0);
                    } else {
                        d2 = Math.pow(d2, 1.0 / d);
                    }
                    GPixmap.ctable[i] = (int)Math.floor(255.0 * d2 + 0.5);
                }
                lgamma = d;
            }
            nArray = ctable;
        }
        return nArray;
    }

    protected static int[] getMultiplier(int n) {
        int[] nArray = (int[])DjVuObject.getFromReference(multiplierRefArray[n]);
        if (nArray == null) {
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = 65536 - (i << 16) / n;
            }
            GPixmap.multiplierRefArray[n] = DjVuObject.createSoftReference(nArray, null);
        }
        return nArray;
    }

    public void attenuate(GBitmap gBitmap, int n, int n2) {
        int n3;
        int n4 = n2 + gBitmap.rows();
        if (n4 > this.rows()) {
            n4 = this.rows();
        }
        if (n2 > 0) {
            n4 -= n2;
        }
        if ((n3 = n + gBitmap.columns()) > this.columns()) {
            n3 = this.columns();
        }
        if (n > 0) {
            n3 -= n;
        }
        if (n4 <= 0 || n3 <= 0) {
            return;
        }
        int n5 = gBitmap.getGrays() - 1;
        int[] nArray = GPixmap.getMultiplier(n5);
        int n6 = gBitmap.rowOffset(n2 < 0 ? -n2 : 0) - (n < 0 ? n : 0);
        int n7 = this.rowOffset(n2 > 0 ? n2 : 0) + (n > 0 ? n : 0);
        GPixelReference gPixelReference = this.createGPixelReference(0);
        for (int i = 0; i < n4; ++i) {
            gPixelReference.setOffset(n7);
            int n8 = 0;
            while (n8 < n3) {
                int n9;
                if ((n9 = gBitmap.getByteAt(n6 + n8++)) > 0) {
                    if (n9 >= n5) {
                        gPixelReference.setGray(0);
                    } else {
                        int n10 = nArray[n9];
                        gPixelReference.setBGR(gPixelReference.getBlue() * n10 >> 16, gPixelReference.getGreen() * n10 >> 16, gPixelReference.getRed() * n10 >> 16);
                    }
                }
                gPixelReference.incOffset();
            }
            n7 += this.getRowSize();
            n6 += gBitmap.getRowSize();
        }
    }

    public void blit(GBitmap gBitmap, int n, int n2, GPixel gPixel) {
        int n3;
        int n4;
        if (gPixel == null) {
            return;
        }
        int n5 = n2 + gBitmap.rows();
        if (n5 > this.rows()) {
            n5 = this.rows();
        }
        if (n2 > 0) {
            n5 -= n2;
        }
        if ((n4 = n + gBitmap.columns()) > this.columns()) {
            n4 = this.columns();
        }
        if (n > 0) {
            n4 -= n;
        }
        if (n5 <= 0 || n4 <= 0) {
            return;
        }
        int n6 = gBitmap.getGrays() - 1;
        int[] nArray = new int[n6];
        for (n3 = 0; n3 < n6; ++n3) {
            nArray[n3] = 65536 - (n3 << 16) / n6;
        }
        n3 = gPixel.getRed();
        int n7 = gPixel.getGreen();
        int n8 = gPixel.getBlue();
        int n9 = gBitmap.rowOffset(n2 < 0 ? -n2 : 0) - (n < 0 ? n : 0);
        int n10 = (n2 > 0 ? this.rowOffset(n2) : 0) + (n > 0 ? n : 0);
        GPixelReference gPixelReference = this.createGPixelReference(n10);
        for (int i = 0; i < n5; ++i) {
            gPixelReference.setOffset(n10);
            int n11 = 0;
            while (n11 < n4) {
                int n12;
                if ((n12 = gBitmap.getByteAt(n9 + n11++)) != 0) {
                    if (n12 >= n6) {
                        gPixelReference.setBGR(n8, n7, n3);
                    } else {
                        int n13 = nArray[n12];
                        int n14 = 65536 - n13;
                        gPixelReference.setBGR(clip[gPixelReference.getBlue() * n13 + n8 * n14 >> 16], clip[gPixelReference.getGreen() * n13 + n7 * n14 >> 16], clip[gPixelReference.getRed() * n13 + n3 * n14 >> 16]);
                    }
                }
                gPixelReference.incOffset();
            }
            n10 += this.getRowSize();
            n9 += gBitmap.getRowSize();
        }
    }

    public final void applyGammaCorrection(double d) {
    }

    public void downsample(GMap gMap, int n, GRect gRect) {
        GRect gRect2 = new GRect(0, 0, (gMap.columns() + n - 1) / n, (gMap.rows() + n - 1) / n);
        if (gRect != null) {
            if (gRect.xmin < gRect2.xmin || gRect.ymin < gRect2.ymin || gRect.xmax > gRect2.xmax || gRect.ymax > gRect2.ymax) {
                throw new IllegalArgumentException("(GPixmap::downsample) Specified rectangle overflows destination pixmap");
            }
            gRect2 = gRect;
        }
        this.init(gRect2.height(), gRect2.width(), null);
        int n2 = gRect2.ymin * n;
        int n3 = gRect2.xmin * n;
        int n4 = gMap.rowOffset(n2);
        int n5 = 0;
        GPixelReference gPixelReference = gMap.createGPixelReference(0);
        GPixelReference gPixelReference2 = this.createGPixelReference(0);
        for (int i = 0; i < this.rows(); ++i) {
            int n6 = n3;
            int n7 = this.columns();
            while (n7-- > 0) {
                int n8;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                int n13 = n4;
                int n14 = n2 + n;
                if (n14 > gMap.rows()) {
                    n14 = gMap.rows();
                }
                if ((n8 = n6 + n) > gMap.columns()) {
                    n8 = gMap.columns();
                }
                for (int j = n2; j < n14; ++j) {
                    int n15;
                    gPixelReference.setOffset(n13 + n6);
                    if (!this.isRampNeeded()) {
                        n15 = n8 - n6;
                        while (n15-- > 0) {
                            n9 += gPixelReference.getRed();
                            n10 += gPixelReference.getGreen();
                            n11 += gPixelReference.getBlue();
                            ++n12;
                            gPixelReference.incOffset();
                        }
                    } else {
                        n15 = n8 - n6;
                        while (n15-- > 0) {
                            GPixel gPixel = gMap.ramp(gPixelReference);
                            n9 += gPixel.getRed();
                            n10 += gPixel.getGreen();
                            n11 += gPixel.getBlue();
                            ++n12;
                            gPixelReference.incOffset();
                        }
                    }
                    n13 += gMap.getRowSize();
                }
                if (n12 >= invmap.length) {
                    gPixelReference2.setBGR(n11 / n12, n10 / n12, n9 / n12);
                } else {
                    gPixelReference2.setBGR(n11 * invmap[n12] + 32768 >> 16, n10 * invmap[n12] + 32768 >> 16, n9 * invmap[n12] + 32768 >> 16);
                }
                n6 += n;
                gPixelReference2.incOffset();
            }
            n2 += n;
            n4 += gMap.rowOffset(n);
            gPixelReference2.setOffset(n5 += this.getRowSize());
        }
    }

    public void downsample43(GMap gMap, GRect gRect) {
        int n = gMap.columns();
        int n2 = gMap.rows();
        int n3 = (int)Math.ceil((double)n * 0.75);
        int n4 = (int)Math.ceil((double)n2 * 0.75);
        GRect gRect2 = new GRect(0, 0, n3, n4);
        if (gRect != null) {
            if (gRect.xmin < gRect2.xmin || gRect.ymin < gRect2.ymin || gRect.xmax > gRect2.xmax || gRect.ymax > gRect2.ymax) {
                throw new IllegalArgumentException("rectangle out of boundspdr=(" + gRect.xmin + "," + gRect.ymin + "," + gRect.xmax + "," + gRect.ymax + "),rect=(" + gRect2.xmin + "," + gRect2.ymin + "," + gRect2.xmax + "," + gRect2.ymax + ")");
            }
            gRect2 = gRect;
            n3 = gRect2.width();
            n4 = gRect2.height();
        }
        this.init(n4, n3, null);
        int n5 = gRect2.ymin / 3;
        int n6 = gRect2.ymin - 3 * n5;
        int n7 = gRect2.xmin / 3;
        int n8 = gRect2.xmin - 3 * n7;
        if (n8 < 0) {
            --n7;
            n8 += 3;
        }
        n7 *= 4;
        n5 *= 4;
        GPixelReference gPixelReference = gMap.createGPixelReference(0);
        GPixelReference gPixelReference2 = gMap.createGPixelReference(0);
        GPixelReference gPixelReference3 = gMap.createGPixelReference(0);
        GPixelReference gPixelReference4 = gMap.createGPixelReference(0);
        GPixelReference gPixelReference5 = this.createGPixelReference(0);
        GPixelReference gPixelReference6 = this.createGPixelReference(0);
        GPixelReference gPixelReference7 = this.createGPixelReference(0);
        while (n6 < n4) {
            gPixelReference.setOffset(n5++, n7);
            if (n5 >= n2) {
                // empty if block
            }
            int n9 = --n5;
            gPixelReference2.setOffset(n9, n7);
            if (++n5 >= n2) {
                // empty if block
            }
            int n10 = --n5;
            gPixelReference3.setOffset(n10, n7);
            if (++n5 >= n2) {
                // empty if block
            }
            int n11 = --n5;
            ++n5;
            gPixelReference4.setOffset(n11, n7);
            gPixelReference5.setOffset(n6 < 0 ? 0 : n6, n8);
            if (++n6 >= n4) {
                --n6;
            }
            gPixelReference6.setOffset(n6 < 0 ? 0 : n6, n8);
            if (++n6 >= n4) {
                // empty if block
            }
            int n12 = --n6;
            ++n6;
            gPixelReference7.setOffset(n12, n8);
            int n13 = n8;
            int n14 = n7;
            GPixel gPixel = gMap.ramp(gPixelReference);
            GPixel gPixel2 = gMap.ramp(gPixelReference2);
            GPixel gPixel3 = gMap.ramp(gPixelReference3);
            GPixel gPixel4 = gMap.ramp(gPixelReference4);
            while (n13 < n3) {
                int n15 = gPixel.getBlue();
                int n16 = gPixel.getGreen();
                int n17 = gPixel.getRed();
                int n18 = gPixel2.getBlue();
                int n19 = gPixel2.getGreen();
                int n20 = gPixel2.getRed();
                int n21 = gPixel3.getBlue();
                int n22 = gPixel3.getGreen();
                int n23 = gPixel3.getRed();
                int n24 = gPixel4.getBlue();
                int n25 = gPixel4.getGreen();
                int n26 = gPixel4.getRed();
                if (++n14 < n) {
                    gPixelReference.incOffset();
                    gPixelReference2.incOffset();
                    gPixelReference3.incOffset();
                    gPixelReference4.incOffset();
                    gPixel = gMap.ramp(gPixelReference);
                    gPixel2 = gMap.ramp(gPixelReference2);
                    gPixel3 = gMap.ramp(gPixelReference3);
                    gPixel4 = gMap.ramp(gPixelReference4);
                }
                int n27 = gPixel.getBlue();
                int n28 = gPixel.getGreen();
                int n29 = gPixel.getRed();
                int n30 = gPixel2.getBlue();
                int n31 = gPixel2.getGreen();
                int n32 = gPixel2.getRed();
                int n33 = gPixel3.getBlue();
                int n34 = gPixel3.getGreen();
                int n35 = gPixel3.getRed();
                int n36 = gPixel4.getBlue();
                int n37 = gPixel4.getGreen();
                int n38 = gPixel4.getRed();
                if (++n14 < n) {
                    gPixelReference.incOffset();
                    gPixelReference2.incOffset();
                    gPixelReference3.incOffset();
                    gPixelReference4.incOffset();
                    gPixel = gMap.ramp(gPixelReference);
                    gPixel2 = gMap.ramp(gPixelReference2);
                    gPixel3 = gMap.ramp(gPixelReference3);
                    gPixel4 = gMap.ramp(gPixelReference4);
                }
                int n39 = gPixel.getBlue();
                int n40 = gPixel.getGreen();
                int n41 = gPixel.getRed();
                int n42 = gPixel2.getBlue();
                int n43 = gPixel2.getGreen();
                int n44 = gPixel2.getRed();
                int n45 = gPixel3.getBlue();
                int n46 = gPixel3.getGreen();
                int n47 = gPixel3.getRed();
                int n48 = gPixel4.getBlue();
                int n49 = gPixel4.getGreen();
                int n50 = gPixel4.getRed();
                if (++n14 < n) {
                    gPixelReference.incOffset();
                    gPixelReference2.incOffset();
                    gPixelReference3.incOffset();
                    gPixelReference4.incOffset();
                    gPixel = gMap.ramp(gPixelReference);
                    gPixel2 = gMap.ramp(gPixelReference2);
                    gPixel3 = gMap.ramp(gPixelReference3);
                    gPixel4 = gMap.ramp(gPixelReference4);
                }
                int n51 = gPixel.getBlue();
                int n52 = gPixel.getGreen();
                int n53 = gPixel.getRed();
                int n54 = gPixel2.getBlue();
                int n55 = gPixel2.getGreen();
                int n56 = gPixel2.getRed();
                int n57 = gPixel3.getBlue();
                int n58 = gPixel3.getGreen();
                int n59 = gPixel3.getRed();
                int n60 = gPixel4.getBlue();
                int n61 = gPixel4.getGreen();
                int n62 = gPixel4.getRed();
                if (++n14 < n) {
                    gPixelReference.incOffset();
                    gPixelReference2.incOffset();
                    gPixelReference3.incOffset();
                    gPixelReference4.incOffset();
                    gPixel = gMap.ramp(gPixelReference);
                    gPixel2 = gMap.ramp(gPixelReference2);
                    gPixel3 = gMap.ramp(gPixelReference3);
                    gPixel4 = gMap.ramp(gPixelReference4);
                }
                gPixelReference5.setBlue(11 * n15 + 2 * (n18 + n27) + n30 + 8 >> 4);
                gPixelReference5.setGreen(11 * n16 + 2 * (n19 + n28) + n31 + 8 >> 4);
                gPixelReference5.setRed(11 * n17 + 2 * (n20 + n29) + n32 + 8 >> 4);
                gPixelReference6.setBlue(7 * (n18 + n21) + n30 + n33 + 8 >> 4);
                gPixelReference6.setGreen(7 * (n19 + n22) + n31 + n34 + 8 >> 4);
                gPixelReference6.setRed(7 * (n20 + n23) + n32 + n35 + 8 >> 4);
                gPixelReference7.setBlue(11 * n24 + 2 * (n21 + n36) + n33 + 8 >> 4);
                gPixelReference7.setGreen(11 * n25 + 2 * (n22 + n37) + n34 + 8 >> 4);
                gPixelReference7.setRed(11 * n26 + 2 * (n23 + n38) + n35 + 8 >> 4);
                if (++n13 < n3) {
                    gPixelReference5.incOffset();
                    gPixelReference6.incOffset();
                    gPixelReference7.incOffset();
                }
                gPixelReference5.setBlue(7 * (n27 + n39) + n30 + n42 + 8 >> 4);
                gPixelReference5.setGreen(7 * (n28 + n40) + n31 + n43 + 8 >> 4);
                gPixelReference5.setRed(7 * (n29 + n41) + n32 + n44 + 8 >> 4);
                gPixelReference6.setBlue(n33 + n45 + n30 + n42 + 2 >> 2);
                gPixelReference6.setGreen(n34 + n46 + n31 + n43 + 2 >> 2);
                gPixelReference6.setRed(n35 + n47 + n32 + n44 + 2 >> 2);
                gPixelReference7.setBlue(7 * (n36 + n48) + n33 + n45 + 8 >> 4);
                gPixelReference7.setGreen(7 * (n37 + n49) + n34 + n46 + 8 >> 4);
                gPixelReference7.setRed(7 * (n38 + n50) + n35 + n47 + 8 >> 4);
                if (++n13 < n3) {
                    gPixelReference5.incOffset();
                    gPixelReference6.incOffset();
                    gPixelReference7.incOffset();
                }
                gPixelReference5.setBlue(11 * n51 + 2 * (n54 + n39) + n42 + 8 >> 4);
                gPixelReference5.setGreen(11 * n52 + 2 * (n55 + n40) + n43 + 8 >> 4);
                gPixelReference5.setRed(11 * n53 + 2 * (n56 + n41) + n44 + 8 >> 4);
                gPixelReference6.setBlue(7 * (n54 + n57) + n42 + n45 + 8 >> 4);
                gPixelReference6.setGreen(7 * (n55 + n58) + n43 + n46 + 8 >> 4);
                gPixelReference6.setRed(7 * (n56 + n59) + n44 + n47 + 8 >> 4);
                gPixelReference7.setBlue(11 * n60 + 2 * (n57 + n48) + n45 + 8 >> 4);
                gPixelReference7.setGreen(11 * n61 + 2 * (n58 + n49) + n46 + 8 >> 4);
                gPixelReference7.setRed(11 * n62 + 2 * (n59 + n50) + n47 + 8 >> 4);
                if (++n13 >= n3) continue;
                gPixelReference5.incOffset();
                gPixelReference6.incOffset();
                gPixelReference7.incOffset();
            }
        }
    }

    public void fill(GMap gMap, int n, int n2) {
        int n3;
        int n4 = n > 0 ? n : 0;
        int n5 = n2 > 0 ? n2 : 0;
        int n6 = n < 0 ? -n : 0;
        int n7 = n2 < 0 ? -n2 : 0;
        int n8 = this.columns() - n4;
        int n9 = gMap.columns() - n6;
        int n10 = n8 < n9 ? n8 : n9;
        int n11 = this.rows() - n5;
        int n12 = gMap.rows() - n7;
        int n13 = n3 = n11 < n12 ? n11 : n12;
        if (n10 > 0 && n3 > 0) {
            GPixelReference gPixelReference = this.createGPixelReference(0);
            GPixelReference gPixelReference2 = gMap.createGPixelReference(0);
            do {
                gPixelReference.setOffset(n5++, n4);
                gPixelReference2.setOffset(n7++, n6);
                if (!this.isRampNeeded()) {
                    gPixelReference.setPixels(gPixelReference2, n10);
                    continue;
                }
                int n14 = n10;
                do {
                    gPixelReference.set(gMap.ramp(gPixelReference2));
                    gPixelReference.incOffset();
                    gPixelReference2.incOffset();
                } while (--n14 > 0);
            } while (--n3 > 0);
        }
    }

    GPixmap init(byte[] byArray, int n, int n2) {
        this.nrows = n;
        this.ncolumns = n2;
        this.data = byArray;
        return this;
    }

    public GPixmap init(int n, int n2, GPixel gPixel) {
        int n3;
        if (n != this.nrows || n2 != this.ncolumns) {
            this.data = null;
            this.nrows = n;
            this.ncolumns = n2;
        }
        if ((n3 = this.rowOffset(this.rows())) > 0) {
            if (this.data == null) {
                this.data = new byte[n3 * 3];
            }
            if (gPixel != null) {
                byte by = gPixel.blueByte();
                byte by2 = gPixel.greenByte();
                byte by3 = gPixel.redByte();
                int n4 = 0;
                while (n4 < this.data.length) {
                    this.data[n4++] = by;
                    this.data[n4++] = by2;
                    this.data[n4++] = by3;
                }
            }
        }
        return this;
    }

    public GPixmap init(GMap gMap, GRect gRect) {
        this.init(gRect.height(), gRect.width(), null);
        GRect gRect2 = new GRect(0, 0, gMap.columns(), gMap.rows());
        gRect2.intersect(gRect2, gRect);
        gRect2.translate(-gRect.xmin, -gRect.ymin);
        if (!gRect2.isEmpty()) {
            GPixelReference gPixelReference = this.createGPixelReference(0);
            GPixelReference gPixelReference2 = gMap.createGPixelReference(0);
            for (int i = gRect2.ymin; i < gRect2.ymax; ++i) {
                int n;
                gPixelReference.setOffset(i, gRect2.xmin);
                gPixelReference2.setOffset(i + gRect.ymin, gRect.xmin + gRect2.xmin);
                if (!this.isRampNeeded()) {
                    n = gRect2.xmax - gRect2.xmin;
                    while (n-- > 0) {
                        gPixelReference.set(gPixelReference2);
                        gPixelReference.incOffset();
                        gPixelReference2.incOffset();
                    }
                    continue;
                }
                n = gRect2.xmax - gRect2.xmin;
                while (n-- > 0) {
                    gPixelReference.set(gMap.ramp(gPixelReference2));
                    gPixelReference.incOffset();
                    gPixelReference2.incOffset();
                }
            }
        }
        return this;
    }

    public GPixmap init(GMap gMap) {
        this.init(gMap.rows(), gMap.columns(), null);
        GPixelReference gPixelReference = this.createGPixelReference(0);
        if (this.rows() > 0 && this.columns() > 0) {
            GPixelReference gPixelReference2 = ((GPixmap)gMap).createGPixelReference(0);
            for (int i = 0; i < this.rows(); ++i) {
                int n;
                gPixelReference.setOffset(i, 0);
                gPixelReference2.setOffset(i, 0);
                if (!this.isRampNeeded()) {
                    n = this.columns();
                    while (n-- > 0) {
                        gPixelReference.set(gPixelReference2);
                        gPixelReference.incOffset();
                        gPixelReference2.incOffset();
                    }
                    continue;
                }
                n = this.columns();
                while (n-- > 0) {
                    gPixelReference.set(gMap.ramp(gPixelReference2));
                    gPixelReference.incOffset();
                    gPixelReference2.incOffset();
                }
            }
        }
        return this;
    }

    public void stencil(GBitmap gBitmap, GPixmap gPixmap, int n, int n2, GRect gRect, double d) {
        int n3;
        double d2;
        GRect gRect2 = new GRect(0, 0, (gPixmap.columns() * n + n2 - 1) / n2, (gPixmap.rows() * n + n2 - 1) / n2);
        if (gRect != null) {
            if (gRect.xmin < gRect2.xmin || gRect.ymin < gRect2.ymin || gRect.xmax > gRect2.xmax || gRect.ymax > gRect2.ymax) {
                throw new IllegalArgumentException("rectangle out of boundsbounds=(" + gRect.xmin + "," + gRect.ymin + "," + gRect.xmax + "," + gRect.ymax + "),rect=(" + gRect2.xmin + "," + gRect2.ymin + "," + gRect2.xmax + "," + gRect2.ymax + ")");
            }
            gRect2 = gRect;
        }
        int n4 = this.rows();
        if (gBitmap.rows() < n4) {
            n4 = gBitmap.rows();
        }
        if (gRect2.height() < n4) {
            n4 = gRect2.height();
        }
        int n5 = this.columns();
        if (gBitmap.columns() < n5) {
            n5 = gBitmap.columns();
        }
        if (gRect2.width() < n5) {
            n5 = gRect2.width();
        }
        int n6 = gBitmap.getGrays() - 1;
        int[] nArray = new int[n6];
        for (int i = 1; i < n6; ++i) {
            nArray[i] = 65536 * i / n6;
        }
        int[] nArray2 = GPixmap.getColorCorrection(d);
        double d3 = (double)n / (double)n2;
        int n7 = gRect2.ymin * n2 / n;
        double d4 = (double)gRect2.ymin - d3 * (double)n7;
        if (d4 < 0.0) {
            --n7;
            d4 += d3;
        }
        if ((d2 = (double)gRect2.xmin - d3 * (double)(n3 = gRect2.xmin * n2 / n)) < 0.0) {
            --n3;
            d2 += d3;
        }
        int n8 = gPixmap.rowOffset(n7);
        GPixelReference gPixelReference = gPixmap.createGPixelReference(0);
        GPixelReference gPixelReference2 = this.createGPixelReference(0);
        for (int i = 0; i < n4; ++i) {
            double d5;
            gPixelReference.setOffset(n8 + n3);
            double d6 = d2;
            gPixelReference2.setOffset(i, 0);
            int n9 = gBitmap.rowOffset(i);
            for (int j = 0; j < n5; ++j) {
                double d7;
                int n10 = gBitmap.getByteAt(n9 + j);
                if (n10 > 0) {
                    if (n10 >= n6) {
                        gPixelReference2.setBGR(nArray2[gPixelReference.getBlue()], nArray2[gPixelReference.getGreen()], nArray2[gPixelReference.getRed()]);
                    } else {
                        int n11 = nArray[n10];
                        gPixelReference2.setBGR(gPixelReference2.getBlue() * (65536 - n11) + n11 * nArray2[gPixelReference.getBlue()] >> 16, gPixelReference2.getGreen() * (65536 - n11) + n11 * nArray2[gPixelReference.getGreen()] >> 16, gPixelReference2.getRed() * (65536 - n11) + n11 * nArray2[gPixelReference.getRed()] >> 16);
                    }
                }
                d6 += 1.0;
                if (d7 >= d3) {
                    d6 -= d3;
                    gPixelReference.incOffset();
                }
                gPixelReference2.incOffset();
            }
            d4 += 1.0;
            if (!(d5 >= d3)) continue;
            d4 -= d3;
            n8 += gPixmap.getRowSize();
        }
    }

    public GMap translate(int n, int n2, GMap gMap) {
        if (!(gMap instanceof GPixmap) || gMap.columns() != this.columns() || gMap.rows() != this.rows()) {
            gMap = GPixmap.createGPixmap(this).init(this.rows(), this.columns(), null);
        }
        gMap.fill(this, -n, -n2);
        return gMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        int n;
        invmap = new int[256];
        ctableI = new int[256];
        ctable = new int[256];
        lgamma = -1.0;
        clip = new byte[512];
        multiplierRefArray = new Object[256];
        for (n = 0; n < clip.length; ++n) {
            GPixmap.clip[n] = (byte)(n < 256 ? n : 255);
        }
        for (n = 1; n < invmap.length; ++n) {
            GPixmap.invmap[n] = 65536 / n;
        }
        for (n = 0; n < ctableI.length; ++n) {
            GPixmap.ctableI[n] = n;
        }
        n = 1;
        while (n < multiplierRefArray.length) {
            GPixmap.multiplierRefArray[n++] = null;
        }
    }
}

