/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu;

import com.lizardtech.djvu.BitContext;
import com.lizardtech.djvu.DjVuInterface;
import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvu.ZPCodec;
import java.io.IOException;
import java.io.InputStream;

public final class BSInputStream
extends InputStream
implements DjVuInterface {
    private static final int MINBLOCK = 10;
    private static final int MAXBLOCK = 4096;
    private static final int FREQMAX = 4;
    private static final int CTXIDS = 3;
    private static final byte[] MTF = new byte[256];
    private ZPCodec zp = null;
    private final BitContext[] ctx = new BitContext[300];
    private byte[] data = null;
    private boolean eof = false;
    private int blocksize = 0;
    private int bptr = 0;
    private int size = 0;
    private final DjVuObject djvuObject = new DjVuObject();
    static /* synthetic */ Class class$com$lizardtech$djvu$BSInputStream;

    public BSInputStream() {
    }

    public BSInputStream(InputStream inputStream) throws IOException {
        this.init(inputStream);
    }

    public void setDjVuOptions(DjVuOptions djVuOptions) {
        this.djvuObject.setDjVuOptions(djVuOptions);
    }

    public DjVuOptions getDjVuOptions() {
        return this.djvuObject.getDjVuOptions();
    }

    public static BSInputStream createBSInputStream(DjVuInterface djVuInterface) {
        DjVuOptions djVuOptions = djVuInterface.getDjVuOptions();
        return (BSInputStream)DjVuObject.create(djVuOptions, djVuOptions.getBSInputStreamClass(), class$com$lizardtech$djvu$BSInputStream == null ? (class$com$lizardtech$djvu$BSInputStream = BSInputStream.class$("com.lizardtech.djvu.BSInputStream")) : class$com$lizardtech$djvu$BSInputStream);
    }

    private int decode() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        this.size = this.decode_raw(24);
        if (this.size == 0) {
            return 0;
        }
        if (this.size > 0x400000) {
            throw new IOException("ByteStream.corrupt");
        }
        if (this.blocksize < this.size) {
            this.blocksize = this.size;
            this.data = new byte[this.blocksize];
        } else if (this.data == null) {
            this.data = new byte[this.blocksize];
        }
        int n5 = 0;
        if (this.zp.decoder() != 0) {
            ++n5;
            if (this.zp.decoder() != 0) {
                ++n5;
            }
        }
        byte[] byArray = (byte[])MTF.clone();
        int[] nArray = new int[4];
        int n6 = 0;
        while (n6 < 4) {
            nArray[n6++] = 0;
        }
        n6 = 4;
        int n7 = 3;
        int n8 = -1;
        for (int i = 0; i < this.size; ++i) {
            n4 = 2;
            if (n4 > n7) {
                n4 = n7;
            }
            n3 = 0;
            switch (0) {
                default: 
            }
            if (this.zp.decoder(this.ctx[n3 + n4]) != 0) {
                n7 = 0;
                this.data[i] = byArray[n7];
            } else if (this.zp.decoder(this.ctx[(n3 += 3) + n4]) != 0) {
                n7 = 1;
                this.data[i] = byArray[n7];
            } else if (this.zp.decoder(this.ctx[(n3 += 3) + 0]) != 0) {
                n7 = 2 + this.decode_binary(n3 + 1, 1);
                this.data[i] = byArray[n7];
            } else if (this.zp.decoder(this.ctx[(n3 += 2) + 0]) != 0) {
                n7 = 4 + this.decode_binary(n3 + 1, 2);
                this.data[i] = byArray[n7];
            } else if (this.zp.decoder(this.ctx[(n3 += 4) + 0]) != 0) {
                n7 = 8 + this.decode_binary(n3 + 1, 3);
                this.data[i] = byArray[n7];
            } else if (this.zp.decoder(this.ctx[(n3 += 8) + 0]) != 0) {
                n7 = 16 + this.decode_binary(n3 + 1, 4);
                this.data[i] = byArray[n7];
            } else if (this.zp.decoder(this.ctx[(n3 += 16) + 0]) != 0) {
                n7 = 32 + this.decode_binary(n3 + 1, 5);
                this.data[i] = byArray[n7];
            } else if (this.zp.decoder(this.ctx[(n3 += 32) + 0]) != 0) {
                n7 = 64 + this.decode_binary(n3 + 1, 6);
                this.data[i] = byArray[n7];
            } else if (this.zp.decoder(this.ctx[(n3 += 64) + 0]) != 0) {
                n7 = 128 + this.decode_binary(n3 + 1, 7);
                this.data[i] = byArray[n7];
            } else {
                n7 = 256;
                this.data[i] = 0;
                n8 = i;
                continue;
            }
            n6 += n6 >> n5;
            if (n6 > 0x10000000) {
                n6 >>= 24;
                nArray[0] = nArray[0] >> 24;
                nArray[1] = nArray[1] >> 24;
                nArray[2] = nArray[2] >> 24;
                nArray[3] = nArray[3] >> 24;
                n2 = 4;
                while (n2 < 4) {
                    int n9 = n2++;
                    nArray[n9] = nArray[n9] >> 24;
                }
            }
            n = n6;
            if (n7 < 4) {
                n += nArray[n7];
            }
            for (n2 = n7; n2 >= 4; --n2) {
                byArray[n2] = byArray[n2 - 1];
            }
            while (n2 > 0 && (0xFFFFFFFFL & (long)n) >= (0xFFFFFFFFL & (long)nArray[n2 - 1])) {
                byArray[n2] = byArray[n2 - 1];
                nArray[n2] = nArray[n2 - 1];
                --n2;
            }
            byArray[n2] = this.data[i];
            nArray[n2] = n;
        }
        if (n8 < 1 || n8 >= this.size) {
            throw new IOException("ByteStream.corrupt");
        }
        int[] nArray2 = new int[this.size];
        n4 = 0;
        while (n4 < this.size) {
            nArray2[n4++] = 0;
        }
        int[] nArray3 = new int[256];
        n3 = 0;
        while (n3 < 256) {
            nArray3[n3++] = 0;
        }
        for (n3 = 0; n3 < n8; ++n3) {
            n2 = this.data[n3];
            nArray2[n3] = n2 << 24 | nArray3[0xFF & n2] & 0xFFFFFF;
            int n10 = 0xFF & n2;
            nArray3[n10] = nArray3[n10] + 1;
        }
        for (n3 = n8 + 1; n3 < this.size; ++n3) {
            n2 = this.data[n3];
            nArray2[n3] = n2 << 24 | nArray3[0xFF & n2] & 0xFFFFFF;
            int n11 = 0xFF & n2;
            nArray3[n11] = nArray3[n11] + 1;
        }
        n3 = 1;
        for (n2 = 0; n2 < 256; ++n2) {
            n = nArray3[n2];
            nArray3[n2] = n3;
            n3 += n;
        }
        n2 = 0;
        n3 = this.size - 1;
        while (n3 > 0) {
            n = nArray2[n2];
            byte by = (byte)(nArray2[n2] >> 24);
            this.data[--n3] = by;
            n2 = nArray3[0xFF & by] + (n & 0xFFFFFF);
        }
        if (n2 != n8) {
            throw new IOException("ByteStream.corrupt");
        }
        return this.size;
    }

    public void flush() {
        this.bptr = 0;
        this.size = 0;
    }

    public BSInputStream init(InputStream inputStream) throws IOException {
        this.zp = ZPCodec.createZPCodec(this).init(inputStream);
        int n = 0;
        while (n < this.ctx.length) {
            this.ctx[n++] = new BitContext();
        }
        return this;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.eof) {
            return 0;
        }
        int n3 = 0;
        while (n2 > 0 && !this.eof) {
            int n4;
            if (this.size == 0) {
                this.bptr = 0;
                if (this.decode() == 0) {
                    this.size = 1;
                    this.eof = true;
                }
                --this.size;
            }
            int n5 = n4 = this.size > n2 ? n2 : this.size;
            if (n4 > 0) {
                System.arraycopy(this.data, this.bptr, byArray, n, n4);
                n += n4;
            }
            this.size -= n4;
            this.bptr += n4;
            n2 -= n4;
            n3 += n4;
        }
        return n3;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        return this.read(byArray) == 1 ? 0xFF & byArray[0] : -1;
    }

    private int decode_binary(int n, int n2) throws IOException {
        int n3 = 1;
        int n4 = 1 << n2;
        --n;
        while (n3 < n4) {
            int n5 = this.zp.decoder(this.ctx[n + n3]);
            n3 = n3 << 1 | n5;
        }
        return n3 - n4;
    }

    private int decode_raw(int n) throws IOException {
        int n2 = 1;
        int n3 = 1 << n;
        while (n2 < n3) {
            int n4 = this.zp.decoder();
            n2 = n2 << 1 | n4;
        }
        return n2 - n3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        for (int i = 0; i < MTF.length; ++i) {
            BSInputStream.MTF[i] = (byte)i;
        }
    }
}

