/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvubean.toolbar;

import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvubean.DjVuBean;
import com.lizardtech.djvubean.toolbar.ComboBox;
import com.lizardtech.djvubean.toolbar.Finder;
import com.lizardtech.djvubean.toolbar.ToggleButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Toolbar
extends Container
implements ActionListener,
ItemListener,
PropertyChangeListener {
    public static final Object[] FIRST_PAGE_BUTTON = new Object[]{"First Page", "|<<", "firstpage.djvu", new Dimension(24, 24)};
    public static final Object[] SEARCH_DOCUMENT_BACK_BUTTON = new Object[]{"Search To First Page", "<<", "searchbackdoc.djvu", new Dimension(24, 24)};
    public static final Object[] LAST_PAGE_BUTTON = new Object[]{"Last Page", ">>|", "lastpage.djvu", new Dimension(24, 24)};
    public static final Object[] SEARCH_DOCUMENT_FWD_BUTTON = new Object[]{"Search To Last Page", ">>", "searchfwddoc.djvu", new Dimension(24, 24)};
    public static final Object[] LOGO_BUTTON = new Object[]{"LizardTech Inc.", "LizardTech", "lizardtech.djvu", new Dimension(98, 24)};
    public static final Object[] SEPARATOR_BUTTON = new Object[]{"", "", null, new Dimension(1, 1)};
    public static final Object[] NEXT_PAGE_BUTTON = new Object[]{"Next Page", ">", "nextpage.djvu", new Dimension(24, 24)};
    public static final Object[] SEARCH_FORWARD_BUTTON = new Object[]{"Search Forward", "?>", "searchfwd.djvu", new Dimension(24, 24)};
    public static final Object[] PREVIOUS_PAGE_BUTTON = new Object[]{"Prev Page", "<", "prevpage.djvu", new Dimension(24, 24)};
    public static final Object[] SEARCH_BACK_BUTTON = new Object[]{"Search Backwards", "<?", "searchback.djvu", new Dimension(24, 24)};
    public static final Object[] ZOOMIN_BUTTON = new Object[]{"ZoomIn", "+", "zoomin.djvu", new Dimension(24, 24)};
    public static final Object[] ZOOMOUT_BUTTON = new Object[]{"ZoomOut", "-", "zoomout.djvu", new Dimension(24, 24)};
    public static final Object[] PAGE_SELECT = new Object[]{"Select Page", "-", "select.djvu", new Dimension(16, 16)};
    public static final Object[] ZOOM_SELECT = new Object[]{"Select Zoom", "-", "select.djvu", new Dimension(24, 24)};
    public static final Object[] ACTUAL_SIZE_BUTTON = new Object[]{"100%", "100%", "actualsi.djvu", new Dimension(24, 24)};
    public static final Object[] FIT_PAGE_BUTTON = new Object[]{"Fit Page", "FitPage", "fitpage.djvu", new Dimension(24, 24)};
    public static final Object[] FIT_WIDTH_BUTTON = new Object[]{"Fit Width", "FitWidth", "fitwidth.djvu", new Dimension(24, 24)};
    public static final Object[] SEARCH_BUTTON = new Object[]{"Search", "Search", "search.djvu", new Dimension(24, 24)};
    public static final Object[] PAN_MODE_BUTTON = new Object[]{"Pan Mode", "Pan", "hand.djvu", new Dimension(24, 24)};
    public static final Object[] ZOOM_MODE_BUTTON = new Object[]{"Zoom Mode", "Zoom", "zoomselect.djvu", new Dimension(24, 24)};
    public static final Object[] TEXT_MODE_BUTTON = new Object[]{"Text Mode", "Text", "textselect.djvu", new Dimension(24, 24)};
    public static final String SEARCH_SELECTED_STRING = "SearchSelected";
    public static final String SEARCH_NOT_SELECTED_STRING = "SearchNotSelected";
    public static final Color BLACK = new Color(0, 0, 0);
    public static final Color LIGHT_GRAY = new Color(192, 192, 192);
    private static final Class classComboBox;
    private static Method addItemMethod;
    private static Method addItemListenerMethod;
    private static Method removeItemListenerMethod;
    private static Method setSelectedItemMethod;
    private static Method setPreferredSizeMethod;
    private static Method setEditableMethod;
    private static Method getEditorMethod;
    private static Method addActionListenerMethod;
    protected final Container pageSelect;
    protected final Container zoomSelect;
    protected final Panel modeButtonPanel = new Panel();
    protected final Panel pagePanel = new Panel();
    protected final Panel zoomPagePanel = new Panel();
    protected final Panel zoomPanel = new Panel();
    protected final ToggleButton actualSize;
    protected final ToggleButton firstPage;
    protected final ToggleButton fitPage;
    protected final ToggleButton fitWidth;
    protected final ToggleButton lastPage;
    protected final ToggleButton logo;
    protected final ToggleButton logo2;
    protected final ToggleButton nextPage;
    protected final ToggleButton panMode;
    protected final ToggleButton prevPage;
    protected final ToggleButton searchMode;
    protected final ToggleButton textMode;
    protected final ToggleButton zoomIn;
    protected final ToggleButton zoomMode;
    protected final ToggleButton zoomOut;
    protected ActionListener pageSelectEditorActionListener;
    private DjVuBean djvuBean = null;
    private Vector buttonList = new Vector();
    private Vector toggleButtonList = new Vector();
    private boolean toolbar = false;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$awt$event$ItemListener;
    static /* synthetic */ Class class$java$awt$event$ActionListener;
    static /* synthetic */ Class class$java$awt$Dimension;
    static /* synthetic */ Class class$com$lizardtech$djvubean$toolbar$ComboBox;
    static /* synthetic */ Class class$java$awt$TextField;

    public Toolbar(DjVuBean djVuBean) {
        ToggleButton toggleButton;
        this.djvuBean = djVuBean;
        this.pageSelect = this.createComboBox(PAGE_SELECT);
        this.zoomSelect = this.createComboBox(ZOOM_SELECT);
        this.firstPage = this.createButton(FIRST_PAGE_BUTTON);
        this.lastPage = this.createButton(LAST_PAGE_BUTTON);
        this.logo = this.createButton(LOGO_BUTTON);
        this.logo2 = this.createButton(LOGO_BUTTON);
        this.nextPage = this.createButton(NEXT_PAGE_BUTTON);
        this.prevPage = this.createButton(PREVIOUS_PAGE_BUTTON);
        this.zoomIn = this.createButton(ZOOMIN_BUTTON);
        this.zoomOut = this.createButton(ZOOMOUT_BUTTON);
        this.searchMode = this.createToggleButton(SEARCH_BUTTON);
        this.actualSize = this.createToggleButton(ACTUAL_SIZE_BUTTON);
        this.fitPage = this.createToggleButton(FIT_PAGE_BUTTON);
        this.fitWidth = this.createToggleButton(FIT_WIDTH_BUTTON);
        this.panMode = this.createToggleButton(PAN_MODE_BUTTON);
        this.zoomMode = this.createToggleButton(ZOOM_MODE_BUTTON);
        this.textMode = this.createToggleButton(TEXT_MODE_BUTTON);
        this.logo.setBorderType(0);
        this.logo2.setBorderType(0);
        this.modeButtonPanel.setLayout(new FlowLayout(0, 1, 1));
        this.modeButtonPanel.add(this.panMode);
        this.modeButtonPanel.add(this.zoomMode);
        this.modeButtonPanel.add(this.textMode);
        this.modeButtonPanel.add(this.searchMode);
        this.modeButtonPanel.setLayout(new GridLayout(1, 4));
        this.zoomPagePanel.setLayout(new GridLayout(1, 2));
        this.zoomPagePanel.add(this.zoomPanel);
        this.zoomPagePanel.add(this.pagePanel);
        this.setLayout(new BorderLayout());
        if (djVuBean.getTextSearchObject() != null) {
            this.add((Component)new Finder(djVuBean), "South");
        }
        this.add((Component)this.zoomPagePanel, "Center");
        this.add((Component)this.modeButtonPanel, "West");
        this.add((Component)this.logo, "East");
        try {
            this.toolbar = DjVuBean.stringToBoolean(djVuBean.properties.getProperty("toolbar"), true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.zoomPagePanel.setVisible(this.toolbar);
        this.modeButtonPanel.setVisible(this.toolbar);
        this.logo.setVisible(this.toolbar);
        this.setBackground(LIGHT_GRAY);
        this.setForeground(BLACK);
        Enumeration enumeration = this.buttonList.elements();
        while (enumeration.hasMoreElements()) {
            toggleButton = (ToggleButton)enumeration.nextElement();
            toggleButton.setBackground(LIGHT_GRAY);
            toggleButton.setForeground(BLACK);
            toggleButton.addActionListener(this);
        }
        enumeration = this.toggleButtonList.elements();
        while (enumeration.hasMoreElements()) {
            toggleButton = (ToggleButton)enumeration.nextElement();
            toggleButton.setBackground(LIGHT_GRAY);
            toggleButton.setForeground(BLACK);
            toggleButton.addItemListener(this);
        }
        int n = 0;
        while (n < DjVuBean.ZOOM_STANDARD_LIST.length) {
            Toolbar.addItemComboBox(this.zoomSelect, DjVuBean.ZOOM_STANDARD_LIST[n++]);
        }
        n = 0;
        while (n < DjVuBean.ZOOM_SPECIAL_LIST.length) {
            Toolbar.addItemComboBox(this.zoomSelect, DjVuBean.ZOOM_SPECIAL_LIST[n++]);
        }
        this.editorActionListener(this.zoomSelect, "%");
        Toolbar.addItemListenerComboBox(this.zoomSelect, this);
        n = djVuBean.getDocumentSize();
        int n2 = 0;
        while (n2 < n) {
            Toolbar.addItemComboBox(this.pageSelect, new Integer(++n2));
        }
        Toolbar.setSelectedItemComboBox(this.pageSelect, new Integer(1));
        this.editorActionListener(this.pageSelect, " ");
        this.pageSelect.setEnabled(n > 1);
        Toolbar.addItemListenerComboBox(this.pageSelect, this);
        this.pageSelect.setVisible(n > 1);
        this.firstPage.setVisible(n > 1);
        this.prevPage.setVisible(n > 1);
        this.lastPage.setVisible(n > 1);
        this.nextPage.setVisible(n > 1);
        djVuBean.addPropertyChangeListener(this);
        this.updatePage(new Integer(djVuBean.getPage()));
        this.updateMode(djVuBean.getMode());
        this.updateSearchMode();
        this.updateZoom();
        this.updateTargetWidth(-1, djVuBean.getTargetWidth());
    }

    public void setSize(int n, int n2) {
        this.djvuBean.setTargetWidth(n);
        super.setSize(n, n2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof ToggleButton) {
                if (this.lastPage == object) {
                    this.djvuBean.setPageString("Last Page");
                } else if (this.logo == object || this.logo2 == object) {
                    this.djvuBean.setSubmit(this.djvuBean.properties.getProperty("logourl", "http://www.lizardtech.com"));
                } else if (this.firstPage == object) {
                    this.djvuBean.setPageString("First Page");
                } else if (this.prevPage == object) {
                    this.djvuBean.setPageString("Previous Page");
                } else if (this.nextPage == object) {
                    this.djvuBean.setPageString("Next Page");
                } else if (this.fitWidth == object) {
                    this.djvuBean.setZoom("Fit Width");
                } else if (this.fitPage == object) {
                    this.djvuBean.setZoom("Fit Page");
                } else if (this.actualSize == object) {
                    this.djvuBean.setZoom("100%");
                } else if (this.zoomIn == object) {
                    this.djvuBean.setZoom("Zoom In");
                } else if (this.zoomOut == object) {
                    this.djvuBean.setZoom("Zoom Out");
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(DjVuOptions.err);
            System.gc();
        }
    }

    public static ToggleButton createButton(Vector vector, Object[] objectArray) {
        String string = objectArray.length > 0 && objectArray[0] != null ? objectArray[0].toString() : null;
        String string2 = objectArray.length > 1 && objectArray[1] != null ? objectArray[1].toString() : null;
        Object object = objectArray[2];
        Dimension dimension = objectArray.length > 3 && objectArray[3] instanceof Dimension ? (Dimension)objectArray[3] : new Dimension(-1, -1);
        ToggleButton toggleButton = new ToggleButton(string, object == null ? string2 : null, object, dimension);
        toggleButton.setActionCommand(string);
        vector.addElement(toggleButton);
        return toggleButton;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        try {
            Object object = itemEvent.getSource();
            if (object == null) {
                return;
            }
            if (this.panMode == object) {
                if (this.panMode.isSelected()) {
                    this.djvuBean.setMode(1);
                } else if (!this.textMode.isSelected() && !this.zoomMode.isSelected()) {
                    this.djvuBean.setMode(0);
                }
            } else if (this.textMode == object) {
                if (this.textMode.isSelected()) {
                    this.djvuBean.setMode(2);
                } else if (!this.panMode.isSelected() && !this.zoomMode.isSelected()) {
                    this.djvuBean.setMode(0);
                }
            } else if (this.zoomMode == object) {
                if (this.zoomMode.isSelected()) {
                    this.djvuBean.setMode(3);
                } else if (!this.panMode.isSelected() && !this.textMode.isSelected()) {
                    this.djvuBean.setMode(0);
                }
            } else if (this.searchMode == object) {
                ((Hashtable)this.djvuBean.properties).put("addOn.finder", this.searchMode.isSelected() ? "true" : "false");
            } else if (itemEvent.getStateChange() == 1) {
                if (this.pageSelect == object) {
                    this.djvuBean.setPageString(itemEvent.getItem().toString());
                } else if (this.zoomSelect == object) {
                    Object object2 = itemEvent.getItem();
                    this.djvuBean.setZoom(object2 != null ? object2.toString() : null);
                } else if (this.fitWidth == object) {
                    this.djvuBean.setZoom("Fit Width");
                } else if (this.fitPage == object) {
                    this.djvuBean.setZoom("Fit Page");
                } else if (this.actualSize == object) {
                    this.djvuBean.setZoom("100%");
                }
            } else if (this.fitWidth == object || this.actualSize == this.fitWidth || this.fitPage == object) {
                this.updateZoom();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(DjVuOptions.err);
            System.gc();
        }
    }

    public void paint(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(this.getBackground());
        graphics.fill3DRect(0, 0, this.getSize().width - 1, this.getSize().height - 1, true);
        graphics.setColor(color);
        super.paint(graphics);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        try {
            String string = propertyChangeEvent.getPropertyName();
            if ("text".equalsIgnoreCase(string)) {
                boolean bl;
                boolean bl2 = this.textMode.isEnabled();
                boolean bl3 = bl = this.textMode.isSelected() || this.djvuBean.getTextCodec(0L) != null;
                if (bl2 != bl) {
                    this.textMode.setEnabled(bl);
                    this.repaint(20L);
                }
            } else if ("TargetWidth".equalsIgnoreCase(string)) {
                this.updateTargetWidth(((Number)propertyChangeEvent.getOldValue()).intValue(), ((Number)propertyChangeEvent.getNewValue()).intValue());
            } else if ("zoom".equalsIgnoreCase(string)) {
                this.updateZoom();
            } else if ("page".equalsIgnoreCase(string)) {
                this.updatePage((Integer)propertyChangeEvent.getNewValue());
            } else if ("mode".equalsIgnoreCase(string)) {
                this.updateMode(((Number)propertyChangeEvent.getNewValue()).intValue());
            } else if ("propertyName".equalsIgnoreCase(string)) {
                boolean bl;
                String string2 = (String)propertyChangeEvent.getNewValue();
                if ("addOn.finder".equalsIgnoreCase(string2)) {
                    this.updateSearchMode();
                } else if ("addOn.toolbar.page".equalsIgnoreCase(string2) && (bl = DjVuBean.stringToBoolean(this.djvuBean.properties.getProperty(string2), false))) {
                    this.pageSelect.requestFocus();
                    ((Hashtable)this.djvuBean.properties).put(string2, "false");
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(DjVuOptions.err);
            System.gc();
        }
    }

    public void updateTargetWidth(int n, int n2) {
        if (n2 > 0 && n2 != n && (n2 < 750 || n < 750)) {
            if (n2 < 480 || n < 480) {
                Serializable serializable;
                double d = Math.min((double)(n2 - 60) / 400.0, 1.0);
                Object object = this.buttonList.elements();
                while (object.hasMoreElements()) {
                    serializable.setScaleFactor((serializable = (ToggleButton)object.nextElement()) == this.logo2 ? d * d : d);
                    serializable.setSize(serializable.getPreferredSize());
                }
                object = this.toggleButtonList.elements();
                while (object.hasMoreElements()) {
                    serializable = (ToggleButton)object.nextElement();
                    serializable.setScaleFactor(d);
                    serializable.setSize(serializable.getPreferredSize());
                }
                object = this.pageSelect.getPreferredSize();
                if (((Dimension)object).width > 60) {
                    ((Dimension)object).width = 60;
                }
                Toolbar.setPreferredSizeComboBox(this.pageSelect, (Dimension)object);
                this.pageSelect.setSize((Dimension)object);
                serializable = this.pageSelect.getPreferredSize();
                if (((Dimension)serializable).width > 72) {
                    ((Dimension)serializable).width = 72;
                }
                Toolbar.setPreferredSizeComboBox(this.zoomSelect, (Dimension)serializable);
                this.zoomSelect.setSize((Dimension)serializable);
            }
            this.logo.setVisible(this.toolbar && n2 > 500);
            this.logo2.setVisible(n2 > 220 && n2 <= 500);
            if (n2 >= 750) {
                if (n < 750) {
                    this.modeButtonPanel.removeAll();
                    this.zoomPanel.removeAll();
                    this.pagePanel.removeAll();
                    this.modeButtonPanel.setLayout(new GridLayout(1, 4));
                    this.modeButtonPanel.add(this.panMode);
                    this.modeButtonPanel.add(this.zoomMode);
                    this.modeButtonPanel.add(this.textMode);
                    this.modeButtonPanel.add(this.searchMode);
                    this.zoomPanel.setLayout(new FlowLayout(0, 1, 1));
                    this.zoomPanel.add(this.actualSize);
                    this.zoomPanel.add(this.fitWidth);
                    this.zoomPanel.add(this.fitPage);
                    this.zoomPanel.add(this.zoomIn);
                    this.zoomPanel.add(this.zoomSelect);
                    this.zoomPanel.add(this.zoomOut);
                    this.pagePanel.setLayout(new FlowLayout(0, 1, 1));
                    this.pagePanel.add(this.firstPage);
                    this.pagePanel.add(this.prevPage);
                    this.pagePanel.add(this.pageSelect);
                    this.pagePanel.add(this.nextPage);
                    this.pagePanel.add(this.lastPage);
                }
            } else if (n2 < 750 && (n <= 0 || n >= 750)) {
                this.modeButtonPanel.removeAll();
                this.zoomPanel.removeAll();
                this.pagePanel.removeAll();
                this.modeButtonPanel.setLayout(new GridLayout(2, 2));
                this.modeButtonPanel.add(this.panMode);
                this.modeButtonPanel.add(this.searchMode);
                this.modeButtonPanel.add(this.zoomMode);
                this.modeButtonPanel.add(this.textMode);
                Panel panel = new Panel();
                panel.setLayout(new GridLayout(1, 5));
                panel.add(this.actualSize);
                panel.add(this.fitWidth);
                panel.add(this.fitPage);
                panel.add(this.zoomIn);
                panel.add(this.zoomOut);
                Panel panel2 = new Panel();
                panel2.setLayout(new FlowLayout(2, 1, 1));
                panel2.add(this.zoomSelect);
                this.zoomPanel.setLayout(new GridLayout(2, 1));
                this.zoomPanel.add(panel);
                this.zoomPanel.add(panel2);
                panel = new Panel();
                panel.setLayout(new GridLayout(1, 5));
                panel.add(this.firstPage);
                panel.add(this.prevPage);
                panel.add(this.nextPage);
                panel.add(this.lastPage);
                panel2 = new Panel();
                this.add((Component)this.modeButtonPanel, "West");
                this.add((Component)this.logo, "East");
                panel2.setLayout(new BorderLayout());
                panel2.add((Component)this.logo2, "West");
                panel2.add((Component)this.pageSelect, "Center");
                this.pagePanel.setLayout(new GridLayout(2, 1));
                this.pagePanel.add(panel);
                this.pagePanel.add(panel2);
            }
            this.invalidate();
            this.validate();
        }
    }

    protected void setZoomEnabled(boolean bl) {
        this.zoomIn.setEnabled(bl);
        this.zoomOut.setEnabled(bl);
        this.fitWidth.setEnabled(bl);
        this.fitPage.setEnabled(bl);
        this.actualSize.setEnabled(bl);
        this.zoomSelect.setEnabled(bl);
        this.repaint(20L);
    }

    protected ToggleButton createButton(Object[] objectArray) {
        return Toolbar.createButton(this.buttonList, objectArray);
    }

    protected Container createComboBox(Object[] objectArray) {
        String string = objectArray.length > 0 && objectArray[0] != null ? objectArray[0].toString() : null;
        String string2 = objectArray.length > 1 && objectArray[1] != null ? objectArray[1].toString() : null;
        Object object = objectArray[2];
        Dimension dimension = objectArray.length > 3 && objectArray[3] instanceof Dimension ? (Dimension)objectArray[3] : new Dimension(-1, -1);
        if (classComboBox != (class$com$lizardtech$djvubean$toolbar$ComboBox == null ? (class$com$lizardtech$djvubean$toolbar$ComboBox = Toolbar.class$("com.lizardtech.djvubean.toolbar.ComboBox")) : class$com$lizardtech$djvubean$toolbar$ComboBox)) {
            try {
                return (Container)classComboBox.newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new ComboBox(string, object == null ? string2 : null, object, dimension);
    }

    protected ToggleButton createToggleButton(Object[] objectArray) {
        String string = objectArray.length > 0 && objectArray[0] != null ? objectArray[0].toString() : null;
        String string2 = objectArray.length > 1 && objectArray[1] != null ? objectArray[1].toString() : null;
        Object object = objectArray[2];
        Dimension dimension = objectArray.length > 3 && objectArray[3] instanceof Dimension ? (Dimension)objectArray[3] : new Dimension(-1, -1);
        ToggleButton toggleButton = new ToggleButton(string, object == null ? string2 : null, object, dimension, false);
        toggleButton.setActionCommand(string);
        this.toggleButtonList.addElement(toggleButton);
        return toggleButton;
    }

    protected void editorActionListener(final Container container, final String string) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Toolbar.setSelectedItemComboBox(container, actionEvent.getActionCommand() + string);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(DjVuOptions.err);
                    System.gc();
                }
            }
        };
        Toolbar.setEditableComboBox(container, true);
        Toolbar.addActionListenerEditor(Toolbar.getEditorComboBox(container), actionListener);
    }

    private static void setEditableComboBox(Container container, boolean bl) {
        if ((class$com$lizardtech$djvubean$toolbar$ComboBox == null ? (class$com$lizardtech$djvubean$toolbar$ComboBox = Toolbar.class$("com.lizardtech.djvubean.toolbar.ComboBox")) : class$com$lizardtech$djvubean$toolbar$ComboBox).isAssignableFrom(container.getClass())) {
            ((ComboBox)container).setEditable(bl);
        } else {
            Object[] objectArray = new Object[]{new Boolean(bl)};
            DjVuObject.invoke(setEditableMethod, container, objectArray);
        }
    }

    private static Object getEditorComboBox(Container container) {
        return (class$com$lizardtech$djvubean$toolbar$ComboBox == null ? (class$com$lizardtech$djvubean$toolbar$ComboBox = Toolbar.class$("com.lizardtech.djvubean.toolbar.ComboBox")) : class$com$lizardtech$djvubean$toolbar$ComboBox).isAssignableFrom(container.getClass()) ? ((ComboBox)container).getEditor() : DjVuObject.invoke(getEditorMethod, container, null);
    }

    private static void setPreferredSizeComboBox(Container container, Dimension dimension) {
        if (setPreferredSizeMethod != null) {
            try {
                Object[] objectArray = new Object[]{dimension};
                setPreferredSizeMethod.invoke((Object)container, objectArray);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void setSelectedItemComboBox(Container container, Object object) {
        if ((class$com$lizardtech$djvubean$toolbar$ComboBox == null ? (class$com$lizardtech$djvubean$toolbar$ComboBox = Toolbar.class$("com.lizardtech.djvubean.toolbar.ComboBox")) : class$com$lizardtech$djvubean$toolbar$ComboBox).isAssignableFrom(container.getClass())) {
            ((ComboBox)container).setSelectedItem(object);
        } else {
            Object[] objectArray = new Object[]{object};
            DjVuObject.invoke(setSelectedItemMethod, container, objectArray);
        }
    }

    private static void addActionListenerEditor(Object object, ActionListener actionListener) {
        if ((class$java$awt$TextField == null ? (class$java$awt$TextField = Toolbar.class$("java.awt.TextField")) : class$java$awt$TextField).isAssignableFrom(object.getClass())) {
            ((TextField)object).addActionListener(actionListener);
        } else {
            Object[] objectArray = new Object[]{actionListener};
            DjVuObject.invoke(addActionListenerMethod, object, objectArray);
        }
    }

    private void addComponent(Container container, Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        if (component != null) {
            component.setBackground(this.getBackground());
            component.setForeground(this.getForeground());
            gridBagLayout.setConstraints(component, gridBagConstraints);
            container.add(component);
        }
    }

    private static void addItemComboBox(Container container, Object object) {
        if ((class$com$lizardtech$djvubean$toolbar$ComboBox == null ? (class$com$lizardtech$djvubean$toolbar$ComboBox = Toolbar.class$("com.lizardtech.djvubean.toolbar.ComboBox")) : class$com$lizardtech$djvubean$toolbar$ComboBox).isAssignableFrom(container.getClass())) {
            ((ComboBox)container).addItem(object);
        } else {
            Object[] objectArray = new Object[]{object};
            DjVuObject.invoke(addItemMethod, container, objectArray);
        }
    }

    private static void addItemListenerComboBox(Container container, ItemListener itemListener) {
        if ((class$com$lizardtech$djvubean$toolbar$ComboBox == null ? (class$com$lizardtech$djvubean$toolbar$ComboBox = Toolbar.class$("com.lizardtech.djvubean.toolbar.ComboBox")) : class$com$lizardtech$djvubean$toolbar$ComboBox).isAssignableFrom(container.getClass())) {
            ((ComboBox)container).addItemListener(itemListener);
        } else {
            Object[] objectArray = new Object[]{itemListener};
            DjVuObject.invoke(addItemListenerMethod, container, objectArray);
        }
    }

    private static void removeItemListenerComboBox(Container container, ItemListener itemListener) {
        if ((class$com$lizardtech$djvubean$toolbar$ComboBox == null ? (class$com$lizardtech$djvubean$toolbar$ComboBox = Toolbar.class$("com.lizardtech.djvubean.toolbar.ComboBox")) : class$com$lizardtech$djvubean$toolbar$ComboBox).isAssignableFrom(container.getClass())) {
            ((ComboBox)container).removeItemListener(itemListener);
        } else {
            Object[] objectArray = new Object[]{itemListener};
            DjVuObject.invoke(removeItemListenerMethod, container, objectArray);
        }
    }

    private void updateMode(int n) {
        switch (n) {
            case 2: {
                this.textMode.setSelected(true);
                if (this.panMode.isSelected()) {
                    this.panMode.setSelected(false);
                }
                if (this.zoomMode.isSelected()) {
                    this.zoomMode.setSelected(false);
                }
                this.setZoomEnabled(false);
                break;
            }
            case 3: {
                this.zoomMode.setSelected(true);
                if (this.panMode.isSelected()) {
                    this.panMode.setSelected(false);
                }
                if (this.textMode.isSelected()) {
                    this.textMode.setSelected(false);
                }
                this.setZoomEnabled(true);
                break;
            }
            default: {
                this.panMode.setSelected(true);
                if (this.zoomMode.isSelected()) {
                    this.zoomMode.setSelected(false);
                }
                if (this.textMode.isSelected()) {
                    this.textMode.setSelected(false);
                }
                this.setZoomEnabled(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePage(Integer n) {
        int n2 = n;
        Toolbar.removeItemListenerComboBox(this.pageSelect, this);
        try {
            Toolbar.setSelectedItemComboBox(this.pageSelect, n);
        }
        finally {
            Toolbar.addItemListenerComboBox(this.pageSelect, this);
        }
        int n3 = this.djvuBean.getDocumentSize();
        this.firstPage.setEnabled(n2 != 1);
        this.prevPage.setEnabled(n2 != 1);
        this.lastPage.setEnabled(n2 != n3);
        this.nextPage.setEnabled(n2 != n3);
        this.textMode.setEnabled(this.textMode.isSelected() || !this.djvuBean.isDecoding() && this.djvuBean.getTextCodec(0L) != null);
    }

    private void updateSearchMode() {
        String string = this.djvuBean.properties.getProperty("addOn.finder");
        if (string != null) {
            this.searchMode.setEnabled(true);
            boolean bl = DjVuBean.stringToBoolean(string, false);
            this.searchMode.setSelected(bl);
            if (!bl) {
                this.djvuBean.setSearchMask(-1);
            }
        } else {
            this.searchMode.setEnabled(false);
        }
    }

    private void updateZoom() {
        String string = this.djvuBean.getZoom();
        Toolbar.setSelectedItemComboBox(this.zoomSelect, string);
        if ("100%".equals(string)) {
            this.actualSize.setSelected(true);
            this.fitWidth.setSelected(false);
            this.fitPage.setSelected(false);
        } else if ("Fit Width".equals(string)) {
            this.fitWidth.setSelected(true);
            this.fitPage.setSelected(false);
            this.actualSize.setSelected(false);
        } else if ("Fit Page".equals(string)) {
            this.fitPage.setSelected(true);
            this.fitWidth.setSelected(false);
            this.actualSize.setSelected(false);
        } else {
            this.fitPage.setSelected(false);
            this.fitWidth.setSelected(false);
            this.actualSize.setSelected(false);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = null;
        try {
            Class<?> clazz2 = Class.forName("javax.swing.ComboBoxEditor");
            clazz = Class.forName("javax.swing.JComboBox");
            Class[] classArray = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = Toolbar.class$("java.lang.Object")) : class$java$lang$Object};
            addItemMethod = clazz.getMethod("addItem", classArray);
            setSelectedItemMethod = clazz.getMethod("setSelectedItem", classArray);
            Class[] classArray2 = new Class[]{class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = Toolbar.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener};
            addItemListenerMethod = clazz.getMethod("addItemListener", classArray2);
            removeItemListenerMethod = clazz.getMethod("removeItemListener", classArray2);
            Class[] classArray3 = new Class[]{Boolean.TYPE};
            setEditableMethod = clazz.getMethod("setEditable", classArray3);
            getEditorMethod = clazz.getMethod("getEditor", null);
            Class[] classArray4 = new Class[]{class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = Toolbar.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener};
            addActionListenerMethod = clazz2.getMethod("addActionListener", classArray4);
            try {
                Class[] classArray5 = new Class[]{class$java$awt$Dimension == null ? (class$java$awt$Dimension = Toolbar.class$("java.awt.Dimension")) : class$java$awt$Dimension};
                setPreferredSizeMethod = clazz.getMethod("setPreferredSize", classArray5);
            }
            catch (Throwable throwable) {
                setPreferredSizeMethod = null;
            }
        }
        catch (Throwable throwable) {
            clazz = class$com$lizardtech$djvubean$toolbar$ComboBox == null ? (class$com$lizardtech$djvubean$toolbar$ComboBox = Toolbar.class$("com.lizardtech.djvubean.toolbar.ComboBox")) : class$com$lizardtech$djvubean$toolbar$ComboBox;
            addItemMethod = null;
            addItemListenerMethod = null;
            removeItemListenerMethod = null;
            setSelectedItemMethod = null;
            setEditableMethod = null;
            getEditorMethod = null;
            addActionListenerMethod = null;
            setPreferredSizeMethod = null;
        }
        classComboBox = clazz;
    }
}

