/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvubean.toolbar;

import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvubean.toolbar.GrayFilter;
import com.lizardtech.djvubean.toolbar.ListenerSupport;
import com.lizardtech.djvubean.toolbar.ToolbarImages;
import com.lizardtech.djvubean.toolbar.TransparentFilter;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;

public class ToggleButton
extends Container
implements ItemSelectable {
    public static final boolean OLD_JAVA = System.getProperty("java.version").startsWith("1.1.");
    public static final int NOBORDER = 0;
    public static final int RAISED_BORDER = 1;
    public static final int SIMPLE_BORDER = 2;
    private Image gray = null;
    private Image image = null;
    private ListenerSupport actionPerformed = new ListenerSupport(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = ToggleButton.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener);
    private ListenerSupport itemState = new ListenerSupport(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = ToggleButton.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener);
    private Object repaintLock = new Object();
    private String actionCommand = null;
    private String label = null;
    private boolean isSelectable = false;
    private boolean isSelected = false;
    private double scaleFactor = 1.0;
    private int borderType = 1;
    private int imageHeight = 0;
    private int imageWidth = 0;
    static /* synthetic */ Class class$java$awt$event$ActionListener;
    static /* synthetic */ Class class$java$awt$event$ItemListener;

    public ToggleButton(String string, String string2, Object object, Dimension dimension) {
        this.image = this.getImage(object);
        this.setLabel(string2);
        if (this.image != null) {
            this.setImageWidth(this.image.getWidth(this));
            this.setImageHeight(this.image.getHeight(this));
            if (dimension != null) {
                if (this.getImageWidth() < 0) {
                    this.setImageWidth(dimension.width);
                }
                if (this.getImageHeight() < 0) {
                    this.setImageHeight(dimension.height);
                }
            }
            this.prepareImage(this.image, this);
        }
        this.setBackground(new Color(192, 192, 192));
        this.setForeground(new Color(0, 0, 0));
        this.enableEvents(144L);
    }

    public ToggleButton(String string, String string2, Object object, Dimension dimension, boolean bl) {
        this(string, string2, object, dimension);
        this.isSelected = bl;
        this.isSelectable = true;
        this.enableEvents(144L);
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.actionPerformed.getListeners();
    }

    public void setBorderType(int n) {
        if (n != this.borderType) {
            this.borderType = n;
            this.repaint();
        }
    }

    public int getBorderType() {
        return this.borderType;
    }

    public int getBorderX() {
        return 2 + (int)(3.0 * this.getScaleFactor() + 0.5);
    }

    public int getBorderY() {
        return 2 + (int)(3.0 * this.getScaleFactor() + 0.5);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.repaint(20L);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.itemState.getListeners();
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        String string;
        Dimension dimension = new Dimension(this.getBorderX() * 2, 0);
        if (this.image != null) {
            if (this.getImageWidth() > 0) {
                dimension.width += this.getImageWidthScaled();
            }
            if (this.getImageHeight() > 0) {
                dimension.height = this.getImageHeightScaled();
            }
        }
        if ((string = this.getLabel()) != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            dimension.width += fontMetrics.stringWidth(string) + this.getBorderX();
            int n = fontMetrics.getHeight();
            if (n > dimension.height) {
                dimension.height = n;
            }
        }
        dimension.height += this.getBorderY() * 2;
        return dimension;
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setSelected(boolean bl) {
        if (bl != this.isSelected()) {
            if (this.isSelectable) {
                this.isSelected = bl;
                this.processEvent(new ItemEvent(this, 701, this, this.isSelected ? 1 : 2));
            } else {
                this.processEvent(new ActionEvent(this, 1001, this.getActionCommand()));
            }
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public Object[] getSelectedObjects() {
        if (!this.isSelected) {
            return new Object[0];
        }
        Object[] objectArray = new Object[]{this};
        return objectArray;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionPerformed.addListener(actionListener);
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemState.addListener(itemListener);
    }

    public void drawIcon(Graphics graphics) {
        String string;
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (n < 2 * (1 + this.getBorderX()) || n2 < 2 * (1 + this.getBorderY())) {
            return;
        }
        Color color = graphics.getColor();
        switch (this.getBorderType()) {
            case 1: {
                graphics.setColor(this.getBackground());
                graphics.fill3DRect(0, 0, n - 1, n2 - 1, !this.isSelected);
                break;
            }
            case 2: {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, n, n2);
                graphics.setColor(this.getForeground());
                graphics.drawRect(0, 0, n - 1, n2 - 1);
                graphics.setColor(this.getBackground());
                break;
            }
            default: {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, n, n2);
            }
        }
        int n3 = this.getBorderX();
        if (this.image != null) {
            if (this.isEnabled()) {
                this.drawImage(graphics, this.image, n3);
            } else {
                if (this.gray == null) {
                    this.gray = this.createImage(new FilteredImageSource(this.image.getSource(), new GrayFilter()));
                }
                this.drawImage(graphics, this.gray, n3);
            }
            n3 += this.getImageWidthScaled() + this.getBorderX();
        }
        if ((string = this.getLabel()) != null) {
            Color color2 = this.getForeground();
            if (!this.isEnabled()) {
                color2 = color2.darker();
            }
            graphics.setColor(color2);
            Font font = graphics.getFont();
            graphics.setFont(this.getFont());
            graphics.drawBytes(string.getBytes(), 0, string.getBytes().length, n3, n2 - 1 - this.getBorderY());
            graphics.setFont(font);
        }
        graphics.setColor(color);
    }

    public void drawImage(Graphics graphics, Image image, int n) {
        if (this.getScaleFactor() == 1.0) {
            graphics.drawImage(image, n, this.getBorderY(), this.getImageWidth(), this.getImageHeight(), this);
        } else {
            graphics.drawImage(image, n, this.getBorderY(), n + this.getImageWidthScaled(), this.getBorderY() + this.getImageHeightScaled(), 0, 0, this.getImageWidth(), this.getImageHeight(), this);
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (this.image == image && (this.getImageWidth() != n4 || this.getImageHeight() != n5) && n4 != -1 && n5 != -1) {
            Container container;
            this.setImageWidth(n4);
            this.setImageHeight(n5);
            this.invalidate();
            if (this.isShowing() && (container = this.getParent()) != null) {
                ((Component)container).validate();
            }
            this.repaint(20L);
        }
        return super.imageUpdate(image, n, n2, n3, n4, n5);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void paintAll(Graphics graphics) {
        this.update(graphics);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionPerformed.removeListener(actionListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemState.removeListener(itemListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaintWait(long l) {
        Object object = this.repaintLock;
        synchronized (object) {
            this.repaint();
            try {
                this.repaintLock.wait(l);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Graphics graphics) {
        Object object;
        if (!this.isValid()) {
            object = this.getParent();
            if (object != null) {
                ((Component)object).validate();
                this.repaint();
            }
        } else {
            this.drawIcon(graphics);
        }
        object = this.repaintLock;
        synchronized (object) {
            try {
                this.repaintLock.notifyAll();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected Image getImage(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Image) {
            return (Image)object;
        }
        Image image = null;
        try {
            image = this.createImage(new FilteredImageSource(ToolbarImages.createImage(this, object.toString()).getSource(), new TransparentFilter()));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(DjVuOptions.err);
        }
        return image;
    }

    protected void setImageHeight(int n) {
        this.imageHeight = n;
    }

    protected int getImageHeight() {
        return this.imageHeight;
    }

    protected int getImageHeightScaled() {
        return (int)(this.getScaleFactor() * (double)this.getImageHeight() + 0.5);
    }

    protected void setImageWidth(int n) {
        this.imageWidth = n;
    }

    protected int getImageWidth() {
        return this.imageWidth;
    }

    protected int getImageWidthScaled() {
        return (int)(this.getScaleFactor() * (double)this.getImageWidth() + 0.5);
    }

    protected void processActionEvent(final ActionEvent actionEvent) {
        if (this.isEnabled()) {
            if (this.isSelectable) {
                this.setSelected(!this.isSelected);
            } else {
                this.isSelected = true;
                final ListenerSupport listenerSupport = this.actionPerformed;
                Thread thread = new Thread(){

                    public void run() {
                        ToggleButton.this.repaintWait(50L);
                        listenerSupport.fireActionEvent(actionEvent);
                        ToggleButton.this.isSelected = false;
                        ToggleButton.this.repaint();
                    }
                };
                thread.start();
            }
        }
        this.repaint(20L);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
        } else if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processItemEvent(final ItemEvent itemEvent) {
        if (this.isEnabled()) {
            boolean bl;
            boolean bl2 = bl = itemEvent.getStateChange() == 1;
            if (this.isSelectable || bl) {
                this.isSelected = bl;
                final ListenerSupport listenerSupport = this.itemState;
                Thread thread = new Thread(){

                    public void run() {
                        ToggleButton.this.repaintWait(50L);
                        listenerSupport.fireItemEvent(itemEvent);
                    }
                };
                thread.start();
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.isEnabled() && mouseEvent.getID() == 500) {
            this.setSelected(!this.isSelected());
        }
        super.processMouseEvent(mouseEvent);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

