/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvubean.toolbar;

import com.lizardtech.djvubean.toolbar.ComboBox;
import java.awt.AWTEvent;
import java.awt.Choice;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;

public class PopupChoice
extends Choice {
    private final ComboBox reference;

    public PopupChoice(ComboBox comboBox) {
        this.reference = comboBox;
        this.enableEvents(532L);
    }

    public Dimension getMaximumSize() {
        return this.adjustSize(super.getMaximumSize(), this.reference.getButton().getMaximumSize(), this.reference.getEditor().getMaximumSize());
    }

    public Dimension getMinimumSize() {
        return this.adjustSize(super.getMinimumSize(), this.reference.getButton().getMinimumSize(), this.reference.getEditor().getMinimumSize());
    }

    public Dimension getPreferredSize() {
        return this.adjustSize(super.getPreferredSize(), this.reference.getButton().getPreferredSize(), this.reference.getEditor().getPreferredSize());
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.paintArea(graphics, this.getSize());
    }

    public void update(Graphics graphics) {
        super.update(graphics);
        this.paintArea(graphics, this.getSize());
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent.getSource() == this && aWTEvent instanceof ItemEvent) {
            aWTEvent = new ItemEvent(this.reference, aWTEvent.getID(), ((ItemEvent)aWTEvent).getItem(), ((ItemEvent)aWTEvent).getStateChange());
        }
        super.processEvent(aWTEvent);
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        if (focusEvent.getID() == 1005) {
            this.reference.setIsPopupVisible(false);
            this.reference.showEditor();
            if (!this.reference.isEditable()) {
                this.reference.showChoice();
            }
        }
        super.processFocusEvent(focusEvent);
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this) {
            itemEvent = new ItemEvent(this.reference, itemEvent.getID(), itemEvent.getItem(), itemEvent.getStateChange());
        }
        this.reference.setIsPopupVisible(false);
        this.reference.showEditor();
        if (!this.reference.isEditable()) {
            this.reference.showChoice();
        }
        Object object = itemEvent.getItem();
        if (itemEvent.getStateChange() == 1) {
            this.reference.setSelectedItem(this.reference.getItemMap().get(object));
        } else {
            this.reference.processEvent(this.reference.replaceItemEvent(itemEvent));
        }
        super.processItemEvent(itemEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 502: {
                if (mouseEvent.isPopupTrigger()) {
                    this.reference.setIsPopupVisible(true);
                    break;
                }
            }
            case 500: {
                this.reference.setIsPopupVisible(false);
                this.reference.showEditor();
                if (!this.reference.isEditable()) {
                    this.reference.showChoice();
                    break;
                }
                this.reference.getEditor().requestFocus();
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    private Dimension adjustSize(Dimension dimension, Dimension dimension2, Dimension dimension3) {
        int n = dimension2.width + dimension3.width;
        int n2 = Math.max(dimension2.height, dimension3.height);
        if (n > dimension.width) {
            dimension.width = n;
        }
        if (n2 > dimension.height) {
            dimension.height = n2;
        }
        return dimension;
    }

    private void paintArea(Graphics graphics, Dimension dimension) {
        int n = dimension.width;
        int n2 = dimension.height;
        int n3 = this.reference.getButton().getPreferredSize().width;
        int n4 = this.reference.getButton().getPreferredSize().height;
        graphics.clearRect(n - n3, 0, n3, n2);
        this.reference.getButton().update(graphics.create(n - n3, (n2 - n4) / 2, n3, n4));
        graphics.clearRect(0, 0, n - n3, n2);
        graphics.drawRect(0, 0, n - 1, n2 - 1);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n5 = fontMetrics.getHeight();
        byte[] byArray = this.reference.getEditor().getText().getBytes();
        Font font = graphics.getFont();
        graphics.setFont(this.getFont());
        graphics.drawBytes(byArray, 0, byArray.length, 2, n5);
        graphics.setFont(font);
    }
}

