/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvubean.keys;

import com.lizardtech.djvubean.DjVuBean;
import java.awt.TextArea;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Hashtable;

public class DjVuKeys
implements KeyListener {
    protected final DjVuBean bean;

    public DjVuKeys(DjVuBean djVuBean) {
        this.bean = djVuBean;
        djVuBean.addKeyListener(this);
        TextArea textArea = djVuBean.getTextArea();
        if (textArea != null) {
            textArea.addKeyListener(this);
        }
        ((Hashtable)djVuBean.properties).put("addOn.keys", djVuBean.properties.getProperty("keys", "true"));
    }

    public boolean isEnabled() {
        return DjVuBean.stringToBoolean(this.bean.properties.getProperty("addOn.keys"), true);
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.isEnabled()) {
            switch (keyEvent.getKeyChar()) {
                case '1': {
                    this.bean.setZoom("100%");
                    break;
                }
                case '2': {
                    this.bean.setZoom("150%");
                    break;
                }
                case '3': {
                    this.bean.setZoom("300%");
                    break;
                }
                case '4': {
                    this.bean.setZoom("400%");
                    break;
                }
                case '5': {
                    this.bean.setZoom("500%");
                    break;
                }
                case '6': {
                    this.bean.setZoom("600%");
                    break;
                }
                case '7': {
                    this.bean.setZoom("700%");
                    break;
                }
                case '8': {
                    this.bean.setZoom("800%");
                    break;
                }
                case '9': {
                    this.bean.setZoom("900%");
                    break;
                }
                case '-': 
                case '_': {
                    this.bean.setZoom("Zoom Out");
                    break;
                }
                case '+': 
                case '=': {
                    this.bean.setZoom("Zoom In");
                    break;
                }
                case ' ': {
                    this.bean.setPage(this.bean.getPage() + this.bean.getVisiblePageCount());
                    break;
                }
                case 'g': {
                    ((Hashtable)this.bean.properties).put("addOn.toolbar.page", "true");
                    break;
                }
                case 'f': {
                    String string = this.bean.properties.getProperty("addOn.finder");
                    if ("true".equalsIgnoreCase(string)) {
                        ((Hashtable)this.bean.properties).put("addOn.finder", "false");
                        break;
                    }
                    if (!"false".equalsIgnoreCase(string)) break;
                    ((Hashtable)this.bean.properties).put("addOn.finder", "true");
                    break;
                }
                case '0': 
                case 'p': {
                    this.bean.setZoom("Fit Page");
                    break;
                }
                case 'w': {
                    this.bean.setZoom("Fit Width");
                    break;
                }
                case '\b': {
                    this.bean.setPage(this.bean.getPage() - this.bean.getVisiblePageCount());
                }
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.isEnabled()) {
            switch (keyEvent.getKeyCode()) {
                case 34: {
                    this.bean.setScroll("page down");
                    break;
                }
                case 33: {
                    this.bean.setScroll("page up");
                    break;
                }
                case 40: {
                    this.bean.setScroll("down");
                    break;
                }
                case 38: {
                    this.bean.setScroll("up");
                    break;
                }
                case 37: {
                    this.bean.setScroll("left");
                    break;
                }
                case 39: {
                    this.bean.setScroll("right");
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

