/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvubean;

import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvubean.DjVuBean;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class PanMode
implements MouseListener,
MouseMotionListener {
    protected final DjVuBean djvuBean;
    protected Point start = null;

    public PanMode(DjVuBean djVuBean) {
        this.djvuBean = djVuBean;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.djvuBean.requestFocus();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.start != null) {
            Point point = this.djvuBean.getScrollPosition();
            Point point2 = new Point(mouseEvent.getX() - point.x, mouseEvent.getY() - point.y);
            if (!this.start.equals(point2)) {
                this.djvuBean.setScrollPosition(point.x + (this.start.x - point2.x), point.y + (this.start.y - point2.y));
                this.start = point2;
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        try {
            this.djvuBean.requestFocus();
            Point point = this.djvuBean.getScrollPosition();
            this.start = new Point(mouseEvent.getX() - point.x, mouseEvent.getY() - point.y);
            this.djvuBean.addMouseMotionListener(this);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(DjVuOptions.err);
            System.gc();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        try {
            this.start = null;
            this.djvuBean.removeMouseMotionListener(this);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(DjVuOptions.err);
            System.gc();
        }
    }
}

