/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvubean;

import com.irex.mobipocket.reader.Utils;
import com.irex.sdk.DisplayUpdate;
import com.lizardtech.djvu.Codec;
import com.lizardtech.djvu.DjVuInterface;
import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvu.DjVuPage;
import com.lizardtech.djvu.Document;
import com.lizardtech.djvubean.DjVuImage;
import com.lizardtech.djvubean.PanMode;
import com.lizardtech.djvubean.ZoomMode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class DjVuBean
extends Container
implements PropertyChangeListener,
DjVuInterface,
Runnable {
    private static final String NILL = "";
    public static final String SCROLL_UP = "up";
    public static final String SCROLL_DOWN = "down";
    public static final String SCROLL_LEFT = "left";
    public static final String SCROLL_RIGHT = "right";
    public static final String SCROLL_PAGE_UP = "page up";
    public static final String SCROLL_PAGE_DOWN = "page down";
    public static final int FIT_WIDTH = -1;
    public static final int FIT_PAGE = -2;
    public static final int SINGLE_PAGE_LAYOUT = 0;
    public static final int BOOK_PAGE_LAYOUT = 1;
    public static final int COVER_PAGE_LAYOUT = 2;
    public static final int LAST_MODE = 0;
    public static final int PAN_MODE = 1;
    public static final int TEXT_MODE = 2;
    public static final int ZOOM_MODE = 3;
    public static final String ZOOM300 = "300%";
    public static final String ZOOM150 = "150%";
    public static final String ZOOM100 = "100%";
    public static final String ZOOM75 = "75%";
    public static final String ZOOM50 = "50%";
    public static final String ZOOM25 = "25%";
    public static final String ZOOM_FIT_WIDTH = "Fit Width";
    public static final String ZOOM_FIT_PAGE = "Fit Page";
    public static final String ZOOM_ONE_TO_ONE = "One to One";
    public static final String ZOOM_STRETCH = "Stretch";
    public static final String ZOOM_IN = "Zoom In";
    public static final String ZOOM_OUT = "Zoom Out";
    public static final String[] ZOOM_STANDARD_LIST = new String[]{"300%", "150%", "100%", "75%", "50%", "25%"};
    public static final String[] ZOOM_SPECIAL_LIST = new String[]{"Fit Width", "Fit Page", "One to One"};
    public static final String[] ZOOM_BUTTON_LIST = new String[]{"Zoom In", "Zoom Out"};
    public static final String FIRST_PAGE = "First Page";
    public static final String PREV_PAGE = "Previous Page";
    public static final String NEXT_PAGE = "Next Page";
    public static final String LAST_PAGE = "Last Page";
    public static final String[] NAVIGATE_LIST = new String[]{"First Page", "Previous Page", "Next Page", "Last Page"};
    public static final String SINGLE = "single";
    public static final String BOOK = "book";
    public static final String COVER = "cover";
    public static final String[] PAGE_LAYOUT_LIST = new String[]{"single", "book", "cover"};
    public static final int SEARCH_BACKWARD_MASK = 1;
    public static final int MATCH_CASE_MASK = 2;
    public static final int WHOLE_WORD_MASK = 4;
    public static final int WHOLE_DOCUMENT_MASK = 8;
    public static final boolean NEED_PAINT_STATUS = System.getProperty("java.version").startsWith("1.3.");
    private String status = null;
    public final Properties properties;
    protected MouseListener mlistener = null;
    protected int zoom = 0;
    private DjVuObject djvuObject = new DjVuObject();
    private final PropertyChangeSupport change;
    private Component outline = null;
    private Component toolBar = null;
    private Object annoManager = null;
    private Method drawMapAreaMethod = null;
    protected DjVuImage image = null;
    private DjVuPage nextPage = null;
    private DjVuPage prevPage = null;
    private Document document = null;
    private int caretIndex = -1;
    private int caretPosition = -1;
    private Integer page = new Integer(1);
    private Integer searchMask = new Integer(0);
    private Number lastMode = new Integer(-1);
    private Number mode = new Integer(3);
    private Number pageLayout = new Integer(0);
    private Rectangle select = new Rectangle();
    private Runnable textSearchObject = null;
    private String oldZoom = null;
    private String searchText = null;
    private int currentIndex = 0;
    private Number targetWidth = new Integer(-1);
    private String text = null;
    private URL url = null;
    private boolean defereRepaint = false;
    private long clearPage = 0L;
    private boolean firstTime = true;
    private int oViewportHeight = 0;
    private int oViewportWidth = 0;
    protected Thread getImageThread = null;
    private int pageOffset = 0;
    static /* synthetic */ Class class$java$awt$Point;
    static /* synthetic */ Class class$java$awt$Dimension;
    static /* synthetic */ Class class$com$lizardtech$djvubean$DjVuBean;
    static /* synthetic */ Class class$java$awt$Graphics;

    public DjVuBean() {
        this.properties = new Properties(){

            public Object put(Object object, Object object2) {
                String string = this.getProperty((String)object);
                if (!object2.equals(string)) {
                    string = super.put(object, (String)object2);
                    DjVuBean.this.setPropertyName((String)object);
                }
                return string;
            }
        };
        this.change = new PropertyChangeSupport(this);
        this.setMode(1);
    }

    public void setStatus(String string) {
        String string2 = this.status;
        this.status = string;
        this.change.firePropertyChange("status", string2, string);
    }

    public String getStatus() {
        return this.status;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
    }

    public int getCaretIndex() {
        return this.caretIndex;
    }

    public int getCaretPosition() {
        return this.caretPosition;
    }

    public int getDPI() {
        return this.getImageWait().getMaxDPI();
    }

    public void setDjVuOptions(DjVuOptions djVuOptions) {
        this.djvuObject.setDjVuOptions(djVuOptions);
    }

    public DjVuOptions getDjVuOptions() {
        return this.djvuObject.getDjVuOptions();
    }

    public final Document getDocument() {
        return this.document;
    }

    public int getVisiblePageCount() {
        return this.mode.intValue() == 2 || this.pageLayout.intValue() == 0 ? 1 : 2;
    }

    public int getPageOffset() {
        return this.pageLayout.intValue() == 2 ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DjVuImage getImageWait() {
        DjVuImage djVuImage;
        DjVuPage[] djVuPageArray = null;
        while (true) {
            int n = this.page;
            int n2 = this.zoom;
            djVuImage = this.image;
            if (djVuImage == null && this.document != null) {
                DjVuBean djVuBean = this;
                synchronized (djVuBean) {
                    this.currentIndex = 0;
                    djVuImage = this.image;
                    if (djVuImage == null) {
                        int n3;
                        int n4 = this.getVisiblePageCount();
                        int n5 = this.getPageOffset() % n4;
                        int n6 = n - (n4 + n - n5 - 1) % n4;
                        if (djVuPageArray == null || djVuPageArray.length != n4) {
                            djVuPageArray = new DjVuPage[n4];
                            for (n3 = 0; n3 < n4; ++n3) {
                                djVuPageArray[n3] = null;
                            }
                        }
                        try {
                            n3 = 0;
                            int n7 = n6 - 1;
                            while (n3 < n4) {
                                if (n7 >= this.document.size()) {
                                    int n8 = n3;
                                    do {
                                        djVuPageArray[n8++] = null;
                                    } while (n8 < n4);
                                    break;
                                }
                                if (n7 >= 0) {
                                    djVuPageArray[n3] = this.document.getPage(n7, DjVuPage.MAX_PRIORITY, false);
                                    if (n7 == this.page - 1) {
                                        this.currentIndex = n3;
                                    }
                                } else {
                                    djVuPageArray[n3] = null;
                                }
                                ++n3;
                                ++n7;
                            }
                            while (n3-- > 0 && (n3 + n6 <= n5 || djVuPageArray[n3] != null)) {
                            }
                            if (n3 >= 0) {
                                try {
                                    Thread.sleep(20L);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                continue;
                            }
                            djVuImage = new DjVuImage(djVuPageArray, DjVuBean.stringToBoolean(this.properties.getProperty("zoomfast"), false), n2, this.getViewportSize());
                            if (n2 != this.zoom || n != this.page) {
                                continue;
                            }
                            this.setImage(djVuImage);
                            Rectangle rectangle = djVuImage.getBounds();
                            this.setImageSize(rectangle.width, rectangle.height);
                            this.setScrollPosition(0, 0);
                            this.propertyChange(null);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace(DjVuOptions.err);
                            System.gc();
                        }
                    }
                }
            }
            if (n2 == this.zoom && n == this.page) break;
        }
        return djVuImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImageSize(int n, int n2) {
        DjVuImage djVuImage = this.getImageWait();
        Dimension dimension = djVuImage.getSize();
        int n3 = dimension.width;
        int n4 = dimension.height;
        if (n != n3 || n2 != n4) {
            DjVuBean djVuBean = this;
            synchronized (djVuBean) {
                djVuImage = djVuImage.getScaledInstance(n, n2);
                if (djVuImage == null) {
                    djVuImage = this.getImageWait();
                }
                n = djVuImage.getBounds().width;
                n2 = djVuImage.getBounds().height;
                this.setImage(djVuImage);
                this.setPanelSize(djVuImage.getSize());
                this.scaleScrollPosition(n3, n4, n, n2);
            }
            this.recursiveRevalidate();
        }
    }

    public final void setImageSize(Dimension dimension) {
        this.setImageSize(dimension.width, dimension.height);
    }

    public Number getLastMode() {
        return this.lastMode;
    }

    public Dimension getMaximumSize() {
        return this.getImageWait().getSize();
    }

    public Dimension getMinimumPanelSize() {
        return super.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return this.getImageWait().getSize();
    }

    public void setPageLayout(Object object) {
        if (object instanceof Number) {
            this.setPageLayout(((Number)object).intValue());
        } else if (object instanceof String) {
            if (BOOK.equalsIgnoreCase((String)object)) {
                this.setPageLayout(1);
            } else if (COVER.equalsIgnoreCase((String)object)) {
                this.setPageLayout(2);
            } else if (SINGLE.equalsIgnoreCase((String)object)) {
                this.setPageLayout(0);
            } else {
                try {
                    this.setPageLayout(Integer.parseInt((String)object));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPageLayout(int n) {
        if (n != this.pageLayout.intValue()) {
            DjVuBean djVuBean = this;
            synchronized (djVuBean) {
                if (n != this.pageLayout.intValue()) {
                    Number number = this.pageLayout;
                    this.pageLayout = new Integer(n);
                    this.change.firePropertyChange("pagelayout", number, this.pageLayout);
                    this.setImage(null);
                    this.getImage();
                    this.repaint(50L);
                }
            }
        }
    }

    public void setMode(Object object) {
        if (object instanceof Number) {
            this.setMode(((Number)object).intValue());
        } else if (object instanceof String) {
            if ("pan".equalsIgnoreCase((String)object)) {
                this.setMode(1);
            } else if ("zoom".equalsIgnoreCase((String)object)) {
                this.setMode(3);
            } else if ("text".equalsIgnoreCase((String)object)) {
                this.setMode(2);
            } else {
                try {
                    this.setMode(Integer.parseInt((String)object));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMode(int n) {
        if (n != this.mode.intValue()) {
            DjVuBean djVuBean = this;
            synchronized (djVuBean) {
                if (n != this.mode.intValue()) {
                    Number number = this.mode;
                    this.mode = n != 0 ? (Number)new Integer(n) : (Number)this.getLastMode();
                    switch (this.mode.intValue()) {
                        case 3: {
                            if (this.mlistener instanceof ZoomMode) break;
                            if (this.mlistener != null) {
                                this.removeMouseListener(this.mlistener);
                            }
                            this.mlistener = new ZoomMode(this);
                            if (this.image == null) break;
                            this.addMouseListener(this.mlistener);
                            break;
                        }
                        case 1: {
                            if (this.mlistener instanceof PanMode) break;
                            if (this.mlistener != null) {
                                this.removeMouseListener(this.mlistener);
                            }
                            this.mlistener = new PanMode(this);
                            if (this.image == null) break;
                            this.addMouseListener(this.mlistener);
                            break;
                        }
                        default: {
                            if (this.mlistener != null) {
                                this.removeMouseListener(this.mlistener);
                            }
                            this.mlistener = null;
                        }
                    }
                    if (this.mode.intValue() != number.intValue()) {
                        this.lastMode = number;
                        this.change.firePropertyChange("mode", number, this.mode);
                    }
                }
            }
        }
    }

    public int getMode() {
        return this.mode.intValue();
    }

    public String getPageLayout() {
        return PAGE_LAYOUT_LIST[this.pageLayout.intValue()];
    }

    public boolean isOpaque() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPage(int n) {
        if (n != this.getPage()) {
            int n2;
            DjVuImage djVuImage = this.getImage();
            if (djVuImage != null) {
                DjVuPage djVuPage = this.prevPage = DjVuBean.stringToBoolean(this.properties.getProperty("cache"), DjVuObject.hasReferences) ? djVuImage.getDjVuPage(djVuImage.getIndexMax() - 1) : null;
            }
            if ((n2 = this.zoom) == 0) {
                n2 = 100;
            }
            Integer n3 = this.page;
            this.clearPage = 50L;
            this.defereRepaint = true;
            try {
                int n4 = Math.max(1, Math.min(n, this.getDocumentSize()));
                if (n4 != this.page) {
                    this.page = new Integer(n4);
                    this.setImage(null);
                    this.text = null;
                    this.setSearchText(null);
                }
                this.zoom(n2);
                this.getImage();
            }
            finally {
                this.defereRepaint = false;
                this.change.firePropertyChange("page", n3, this.page);
                this.repaint(50L);
            }
        }
    }

    public final int getPage() {
        return this.page;
    }

    public void setPageString(String string) {
        if (FIRST_PAGE.equals(string)) {
            this.setPage(1);
        } else if (PREV_PAGE.equals(string)) {
            this.setPage(this.getPage() - this.getVisiblePageCount());
        } else if (NEXT_PAGE.equals(string)) {
            this.setPage(this.getPage() + this.getVisiblePageCount());
        } else if (LAST_PAGE.equals(string)) {
            this.setPage(Integer.MAX_VALUE);
        } else if (string != null) {
            String string2 = string;
            int n = string2.indexOf(32);
            try {
                this.setPage(Integer.parseInt(n > 0 ? string2.substring(0, n) : string2));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public Dimension getPreferredSize() {
        return this.getImageWait().getSize();
    }

    public final void setScrollPosition(Point point) {
        this.setScrollPosition(point.x, point.y);
    }

    public void setSearchMask(int n) {
        if (n == -1) {
            this.change.firePropertyChange("searchMask", new Integer(-1), this.searchMask);
        } else if (this.searchMask != n) {
            Integer n2 = this.searchMask;
            this.searchMask = new Integer(n);
            this.change.firePropertyChange("searchMask", n2, this.searchMask);
        }
    }

    public int getSearchMask() {
        return this.searchMask;
    }

    public final void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public void setScrollPosition(int n, int n2) {
        DjVuImage djVuImage = this.getImage();
        if (djVuImage != null) {
            Dimension dimension = djVuImage.getSize();
            Dimension dimension2 = this.getViewportSize();
            n = Math.max(0, Math.min(dimension.width - dimension2.width, n));
            n2 = Math.max(0, Math.min(dimension.height - dimension2.height, n2));
            String[] stringArray = new String[]{"setScrollPosition", "setViewPosition"};
            Class[] classArray = new Class[]{class$java$awt$Point == null ? (class$java$awt$Point = DjVuBean.class$("java.awt.Point")) : class$java$awt$Point};
            Object[] objectArray = new Object[]{new Point(n, n2)};
            this.invokeParentsMethod(stringArray, classArray, objectArray, 2);
        }
    }

    public void setScroll(String string) {
        Point point = this.getScrollPosition();
        Dimension dimension = this.getViewportSize();
        if (SCROLL_PAGE_UP.equalsIgnoreCase(string)) {
            this.setScrollPosition(point.x, point.y - (int)Math.ceil(0.9 * (double)dimension.height));
        } else if (SCROLL_PAGE_DOWN.equalsIgnoreCase(string)) {
            this.setScrollPosition(point.x, point.y + (int)Math.ceil(0.9 * (double)dimension.height));
        } else if (SCROLL_UP.equalsIgnoreCase(string)) {
            this.setScrollPosition(point.x, point.y - (int)Math.ceil(0.05 * (double)dimension.height));
        } else if (SCROLL_DOWN.equalsIgnoreCase(string)) {
            this.setScrollPosition(point.x, point.y + (int)Math.ceil(0.05 * (double)dimension.height));
        } else if (SCROLL_LEFT.equalsIgnoreCase(string)) {
            this.setScrollPosition(point.x - (int)Math.ceil(0.05 * (double)dimension.width), point.y);
        } else if (SCROLL_RIGHT.equalsIgnoreCase(string)) {
            this.setScrollPosition(point.x + (int)Math.ceil(0.05 * (double)dimension.width), point.y);
        }
    }

    public Point getScrollPosition() {
        Point point = null;
        try {
            String[] stringArray = new String[]{"getScrollPosition", "getViewPosition"};
            point = (Point)this.invokeParentsMethod(stringArray, null, null, 3);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (point == null) {
            point = new Point(0, 0);
        }
        return point;
    }

    public void setSearchText(String string) {
        if (!(this.searchText == string || string != null && string.equals(this.searchText))) {
            String string2 = this.searchText;
            this.searchText = string;
            this.setCaretPosition(-1);
            this.setCaretIndex(-1);
            this.change.firePropertyChange("searchText", string2, string);
        }
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSelect(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(this.getSelect());
        if (rectangle != null) {
            this.select.setBounds(rectangle);
            if (rectangle2.width > 0 && rectangle2.height > 0) {
                rectangle2.union(rectangle);
            } else {
                rectangle2.setBounds(rectangle);
            }
        } else {
            this.select.setBounds(0, 0, 0, 0);
        }
        rectangle2.setBounds(rectangle2.x - 3, rectangle2.y - 3, rectangle2.width + 6, rectangle2.height + 6);
        this.repaintImageCoordinates(rectangle2);
    }

    public Rectangle getSelect() {
        return this.select;
    }

    public void setSize(int n, int n2) {
        this.setImageSize(n, n2);
        DjVuImage djVuImage = this.getImageWait();
        if (djVuImage != null) {
            this.setPanelSize(djVuImage.getSize());
        }
    }

    public void setSubmit(Object object) {
        this.change.firePropertyChange("submit", null, object);
    }

    public final TextArea getTextArea() {
        return null;
    }

    public Runnable getTextSearchObject() {
        Runnable runnable = this.textSearchObject;
        if (runnable == null) {
            this.textSearchObject = runnable = (Runnable)this.createAddOn("com.lizardtech.djvubean.text.TextSearch");
        }
        return runnable;
    }

    public void setURL(URL uRL) throws IOException {
        URL uRL2 = this.url;
        if (!(uRL2 == uRL || uRL != null && uRL.equals(uRL2))) {
            Document document = this.document;
            if (document != null) {
                document.removePropertyChangeListener(this);
                document = null;
            }
            if (uRL != null) {
                document = Document.createDocument(this.djvuObject);
                document.addPropertyChangeListener(this);
                document.init(uRL);
                document.setAsync(true);
                if (DjVuBean.stringToBoolean(this.properties.getProperty("prefetch"), false)) {
                    // empty if block
                }
            }
            this.document = document;
            this.url = uRL;
            this.change.firePropertyChange("URL", uRL2, uRL);
            this.setPageString(this.properties.getProperty("page", this.page.toString()));
            this.zoom = 0;
            this.setZoom(this.properties.getProperty("zoom", ZOOM100));
            this.setPageLayout(this.properties.getProperty("pagelayout", PAGE_LAYOUT_LIST[0]));
            this.setSearchText(this.properties.getProperty("searchtext"));
        }
    }

    public final URL getURL() {
        return this.url;
    }

    public final void setViewportSize(Dimension dimension) {
        this.setViewportSize(dimension.width, dimension.height);
    }

    public void setCaretIndex(int n) {
        if (n != this.caretIndex) {
            this.caretIndex = n;
        }
    }

    public void setCaretPosition(int n) {
        if (n != this.caretPosition) {
            this.caretPosition = n;
        }
    }

    public boolean isDecoding() {
        DjVuImage djVuImage = this.image;
        return djVuImage == null || djVuImage.isDecoding();
    }

    public Component getOutline() {
        Component component = this.outline;
        if (component == null) {
            this.outline = component = (Component)this.createAddOn("com.lizardtech.djvubean.outline.OutlineScrollPane");
        }
        return component;
    }

    public int getDocumentSize() {
        return this.document != null ? this.document.size() : 0;
    }

    public void setProperties(Properties properties) {
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                ((Hashtable)this.properties).put(string, properties.getProperty(string));
            }
        }
    }

    public final Properties getProperties() {
        return this.properties;
    }

    public void setPropertyName(String string) {
        this.change.firePropertyChange("propertyName", null, string);
        if ("page".equalsIgnoreCase(string)) {
            this.setPageString(this.properties.getProperty("page", this.page.toString()));
        } else if ("zoom".equalsIgnoreCase(string)) {
            this.setZoom(this.properties.getProperty("zoom", this.getZoom()));
        } else if ("mousemode".equalsIgnoreCase(string)) {
            this.setMode(this.properties.getProperty("mousemode", Integer.toString(this.getMode())));
        } else if ("pagelayout".equalsIgnoreCase(string)) {
            this.setPageLayout(this.properties.getProperty("pagelayout", this.getPageLayout()));
        }
    }

    public void setSelectionList(int n, Vector vector) {
        DjVuImage djVuImage = this.getImageWait();
        Rectangle rectangle = djVuImage.getHighlightBounds();
        if (!rectangle.isEmpty()) {
            rectangle = new Rectangle(rectangle);
            djVuImage.setHighlightList(n, vector);
            this.repaintImageCoordinates(rectangle);
        } else if (vector != null && vector.size() > 0) {
            djVuImage.setHighlightList(n, vector);
        } else {
            return;
        }
        this.repaintImageCoordinates(djVuImage.getHighlightBounds());
    }

    public void setTargetWidth(int n) {
        if (n != this.targetWidth.intValue() && n > 0) {
            Number number = this.targetWidth;
            this.targetWidth = new Integer(n);
            this.change.firePropertyChange("TargetWidth", number, this.targetWidth);
        }
    }

    public int getTargetWidth() {
        return this.targetWidth.intValue();
    }

    public String getText() {
        Codec codec;
        String string = this.text;
        if (string == null && (codec = this.getTextCodec(this.currentIndex, 0L)) != null) {
            this.text = string = codec.toString();
        }
        return string;
    }

    public Codec getTextCodec(int n, long l) {
        DjVuImage djVuImage = this.image;
        return djVuImage != null ? djVuImage.getTextCodec(n, l) : null;
    }

    public Codec getTextCodec(long l) {
        DjVuImage djVuImage = this.image;
        return djVuImage != null ? djVuImage.getTextCodec(this.currentIndex, l) : null;
    }

    public Component getToolbar() {
        Component component = this.toolBar;
        if (component == null) {
            this.toolBar = component = (Component)this.createAddOn("com.lizardtech.djvubean.toolbar.Toolbar");
        }
        return component;
    }

    public void setViewportSize(int n, int n2) {
        try {
            String[] stringArray = new String[]{"setViewportSize", "setViewSize"};
            Class[] classArray = new Class[]{class$java$awt$Dimension == null ? (class$java$awt$Dimension = DjVuBean.class$("java.awt.Dimension")) : class$java$awt$Dimension};
            Object[] objectArray = new Object[]{new Dimension(n, n2)};
            this.invokeParentsMethod(stringArray, classArray, objectArray, 3);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Dimension getViewportSize() {
        Dimension dimension = null;
        try {
            String[] stringArray = new String[]{"getViewportSize", "getViewSize"};
            dimension = (Dimension)this.invokeParentsMethod(stringArray, null, null, 3);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return dimension == null ? this.getSize() : dimension;
    }

    public void setZoom(String string) {
        if (!this.getZoom().equals(string)) {
            int n = string.indexOf(37);
            if (n > 0) {
                try {
                    this.zoom(Integer.parseInt(string.substring(0, n)));
                }
                catch (Throwable throwable) {}
            } else if (ZOOM_ONE_TO_ONE.equalsIgnoreCase(string)) {
                this.zoom(this.getDPI());
            } else if (ZOOM_FIT_WIDTH.equalsIgnoreCase(string)) {
                this.zoom(-1);
            } else if (ZOOM_FIT_PAGE.equalsIgnoreCase(string)) {
                this.zoom(-2);
            } else if (ZOOM_IN.equalsIgnoreCase(string)) {
                int n2;
                int n3 = n2 = this.zoom <= 0 ? Math.min(this.getXScale(), this.getYScale()) : this.zoom;
                int n4 = n2 >= 1051 ? 1200 : (n2 >= 370 ? 100 * ((n2 + 149) / 100) : (n2 >= 270 ? 400 : (n2 >= 170 ? 300 : (n2 >= 135 ? 200 : (n2 >= 85 ? 150 : (n2 >= 65 ? 100 : (n2 >= 40 ? 75 : 50)))))));
                this.zoom(n4);
            } else if (ZOOM_OUT.equalsIgnoreCase(string)) {
                int n5;
                int n6 = n5 = this.zoom <= 0 ? Math.max(this.getXScale(), this.getYScale()) : this.zoom;
                int n7 = n5 < 60 ? 25 : (n5 < 85 ? 50 : (n5 < 120 ? 75 : (n5 < 165 ? 100 : (n5 < 225 ? 150 : (n5 < 325 ? 200 : (n5 < 450 ? 300 : 100 * ((n5 - 51) / 100)))))));
                this.zoom(n7);
            } else if ("width".equalsIgnoreCase(string)) {
                this.zoom(-1);
            } else if ("page".equalsIgnoreCase(string)) {
                this.zoom(-2);
            } else {
                try {
                    this.zoom(Integer.parseInt(string));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public String getZoom() {
        int n = this.zoom;
        switch (n) {
            case -1: {
                return ZOOM_FIT_WIDTH;
            }
            case -2: {
                return ZOOM_FIT_PAGE;
            }
        }
        return n + "%";
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.change.addPropertyChangeListener(propertyChangeListener);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x30) != 0) {
            this.repaint(20L);
            DisplayUpdate.dispMainWinFullQ();
            Utils.busyOff();
            return true;
        }
        if ((n & 8) != 0) {
            return true;
        }
        return super.imageUpdate(image, n, n2, n3, n4, n5);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        block7: {
            try {
                DjVuImage djVuImage;
                String string;
                String string2 = string = propertyChangeEvent != null ? propertyChangeEvent.getPropertyName() : null;
                if ("status".equalsIgnoreCase(string)) {
                    Object object = propertyChangeEvent.getNewValue();
                    this.setStatus(object != null ? object.toString() : NILL);
                    break block7;
                }
                if (!DjVuImage.isDoneDecodingEvent(this.image, this, propertyChangeEvent) || (djVuImage = this.image) == null || djVuImage.isDecoding()) break block7;
                int n = this.getPage();
                if (!DjVuBean.stringToBoolean(this.properties.getProperty("cache"), DjVuObject.hasReferences)) break block7;
                try {
                    this.nextPage = this.getDocument().getPage(n + this.getVisiblePageCount() - 1, DjVuPage.MIN_PRIORITY, false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.prevPage = this.getDocument().getPage(n - this.getVisiblePageCount() - 1, DjVuPage.MIN_PRIORITY, false);
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(DjVuOptions.err);
            }
        }
    }

    public static boolean stringToBoolean(String string, boolean bl) {
        try {
            if ("yes".equalsIgnoreCase(string) || "true".equalsIgnoreCase(string)) {
                return true;
            }
            if ("no".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string)) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    public Object createAddOn(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{class$com$lizardtech$djvubean$DjVuBean == null ? (class$com$lizardtech$djvubean$DjVuBean = DjVuBean.class$("com.lizardtech.djvubean.DjVuBean")) : class$com$lizardtech$djvubean$DjVuBean};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this};
            return constructor.newInstance(objectArray);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void paint(Graphics graphics) {
        if (NEED_PAINT_STATUS) {
            this.setStatus("paint called");
        }
        if (this.isShowing()) {
            this.paintComponent(graphics);
        }
    }

    public DjVuImage getImage() {
        DjVuImage djVuImage = this.image;
        if (djVuImage == null && this.getImageThread == null && !this.firstTime) {
            Thread thread;
            this.getImageThread = thread = new Thread(this);
            thread.start();
        }
        return djVuImage;
    }

    public void paintComponent(Graphics graphics) {
        if (this.isShowing()) {
            int n;
            Dimension dimension = this.getViewportSize();
            if ((dimension.width != this.oViewportWidth || dimension.height != this.oViewportHeight) && (n = this.zoom) < 0) {
                this.zoom = 0;
                this.zoom(n);
            }
            if (this.firstTime) {
                this.firstTime = false;
                this.createAddOn("com.lizardtech.djvubean.menu.DjVuMenu");
                this.createAddOn("com.lizardtech.djvubean.keys.DjVuKeys");
                this.annoManager = this.createAddOn("com.lizardtech.djvubean.anno.AnnoManager");
                try {
                    this.drawMapAreaMethod = this.annoManager.getClass().getMethod("draw", class$java$awt$Graphics == null ? (class$java$awt$Graphics = DjVuBean.class$("java.awt.Graphics")) : class$java$awt$Graphics);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.repaint(30L);
                return;
            }
            try {
                Rectangle rectangle = new Rectangle(this.getScrollPosition(), this.getViewportSize());
                DjVuImage djVuImage = this.getImage();
                if (djVuImage == null) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.repaint(30L);
                    return;
                }
                djVuImage.setBufferBounds(this, rectangle);
                boolean bl = false;
                Throwable throwable = null;
                try {
                    djVuImage.draw(this, graphics, this);
                    bl = true;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
                if (!this.isDecoding()) {
                    try {
                        if (this.drawMapAreaMethod != null) {
                            this.drawMapAreaMethod.invoke(this.annoManager, graphics);
                        }
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                    djVuImage.drawHighlight(graphics, bl);
                }
                Rectangle rectangle2 = this.getSelect();
                if (rectangle2.width > 1 && rectangle2.height > 1) {
                    if (bl) {
                        graphics.setXORMode(DjVuImage.WHITE);
                        graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                        if (rectangle2.width > 3 && rectangle2.height > 3) {
                            graphics.drawRect(rectangle2.x + 1, rectangle2.y + 1, rectangle2.width - 2, rectangle2.height - 2);
                        }
                    }
                    graphics.setPaintMode();
                    graphics.setColor(DjVuImage.BLUE);
                    graphics.drawRect(rectangle2.x - 1, rectangle2.y - 1, rectangle2.width + 2, rectangle2.height + 2);
                }
                if (throwable != null) {
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                this.setStatus("error " + throwable.toString());
                throwable.printStackTrace(DjVuOptions.err);
            }
            if (NEED_PAINT_STATUS) {
                this.setStatus("screen updated");
            }
        }
    }

    public void run() {
        if (this.getImageThread == Thread.currentThread()) {
            this.getImageWait();
            this.getImageThread = null;
        }
    }

    public void recursiveRevalidate() {
        this.invalidate();
        try {
            for (Container container = this; container != null && container.isShowing(); container = container.getParent()) {
                ((Component)container).validate();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.change.removePropertyChangeListener(propertyChangeListener);
    }

    public void repaintImageCoordinates(Rectangle rectangle) {
        if (rectangle != null && !rectangle.isEmpty() && this.isShowing()) {
            try {
                Rectangle rectangle2 = new Rectangle(this.getScrollPosition(), this.getViewportSize());
                if (rectangle2.intersects(rectangle)) {
                    this.repaint(20L, rectangle.x - rectangle2.x, rectangle.y - rectangle2.y, rectangle.width, rectangle.height);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(DjVuOptions.err);
                System.gc();
            }
        }
    }

    public void scaleScrollPosition(int n, int n2, int n3, int n4) {
        Point point = this.getScrollPosition();
        Dimension dimension = this.getViewportSize();
        long l = 2L * (long)point.x + (long)dimension.width;
        long l2 = l * (long)n3 / (long)n - (long)dimension.width;
        long l3 = 2L * (long)point.y + (long)dimension.height;
        long l4 = l3 * (long)n4 / (long)n2 - (long)dimension.height;
        this.setScrollPosition((int)(l2 / 2L), (int)(l4 / 2L));
    }

    public void update(Graphics graphics) {
        if (this.isShowing()) {
            if (NEED_PAINT_STATUS) {
                this.setStatus("update called");
            }
            if (this.clearPage-- == 0L) {
                graphics.clearRect(0, 0, 65535, 65535);
            }
            if (this.defereRepaint) {
                try {
                    Thread.sleep(20L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.repaint(30L);
            } else {
                this.paintComponent(graphics);
            }
        }
    }

    public void validate() {
        if (!this.isValid()) {
            super.validate();
            this.repaint(50L);
        }
    }

    public void zoomSelect() {
        Rectangle rectangle = this.getSelect();
        if (rectangle.width > 0 && rectangle.height > 0) {
            Dimension dimension = this.getViewportSize();
            double d = Math.min(this.getXScale(), this.getYScale());
            Dimension dimension2 = this.getImageWait().getBorderNW();
            double d2 = 2 * (rectangle.x - dimension2.width);
            double d3 = 2 * (rectangle.y - dimension2.height);
            double d4 = rectangle.width;
            double d5 = rectangle.height;
            this.setImage(null);
            this.zoom((int)(Math.min((double)dimension.width / d4, (double)dimension.height / d5) * d));
            dimension = this.getViewportSize();
            this.image = this.getImageWait();
            dimension2 = this.getImageWait().getBorderNW();
            double d6 = (double)Math.min(this.getXScale(), this.getYScale()) / d;
            this.setScrollPosition(dimension2.width + (int)((d2 + d4) * d6 - (double)dimension.width) / 2, dimension2.height + (int)((d3 + d5) * d6 - (double)dimension.height) / 2);
        }
        this.setSelect(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setImage(DjVuImage djVuImage) {
        int n;
        Object object;
        DjVuImage djVuImage2 = this.image;
        if (djVuImage2 != null) {
            object = this.mlistener;
            if (object != null) {
                this.removeMouseListener((MouseListener)object);
            }
            int n2 = djVuImage2.getIndexMax();
            for (n = 0; n < n2; ++n) {
                DjVuPage djVuPage = djVuImage2.getDjVuPage(n);
                if (djVuPage == null) continue;
                djVuPage.removePropertyChangeListener(this);
            }
            this.image = null;
        }
        if (djVuImage != null) {
            object = null;
            DjVuBean djVuBean = this;
            synchronized (djVuBean) {
                this.image = djVuImage;
                if (this.mlistener != null) {
                    this.addMouseListener(this.mlistener);
                }
                n = djVuImage.getIndexMax();
                for (int i = 0; i < n; ++i) {
                    DjVuPage djVuPage = djVuImage.getDjVuPage(i);
                    if (djVuPage == null) continue;
                    djVuPage.addPropertyChangeListener(this);
                    String string = djVuPage.getStatus();
                    if (string == null) continue;
                    object = object == null ? string : (String)object + ":" + string;
                }
            }
            if (object != null) {
                this.setStatus((String)object);
            }
        }
        this.change.firePropertyChange("image", djVuImage2, djVuImage);
    }

    protected Dimension getMaximumPanelSize() {
        return super.getMaximumSize();
    }

    protected final void setPanelSize(Dimension dimension) {
        this.setPanelSize(dimension.width, dimension.height);
    }

    protected void setPanelSize(int n, int n2) {
        Dimension dimension = this.getSize();
        if (dimension.width != n || dimension.height != n2) {
            super.setSize(n, n2);
        }
    }

    protected Dimension getPreferredPanelSize() {
        return super.getPreferredSize();
    }

    protected int getXScale() {
        DjVuImage djVuImage = this.getImageWait();
        return (int)Math.ceil(djVuImage.getHorizontalScale());
    }

    protected int getYScale() {
        DjVuImage djVuImage = this.getImageWait();
        return (int)Math.ceil(djVuImage.getVerticalScale());
    }

    protected Object invokeMethod(Object object, String[] stringArray, Class[] classArray, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object object2 = null;
        int n = 0;
        while (n < stringArray.length) {
            try {
                Method method = object.getClass().getMethod(stringArray[n++], classArray);
                object2 = method.invoke(object, objectArray);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (n != stringArray.length) continue;
                throw noSuchMethodException;
            }
            catch (InvocationTargetException invocationTargetException) {
                if (n != stringArray.length) continue;
                throw invocationTargetException;
            }
            catch (IllegalAccessException illegalAccessException) {
                if (n != stringArray.length) continue;
                throw illegalAccessException;
            }
        }
        return object2;
    }

    protected Object invokeParentsMethod(String[] stringArray, Class[] classArray, Object[] objectArray, int n) {
        Object object = null;
        for (Container container = this.getParent(); container != null && n-- > 0; container = container.getParent()) {
            try {
                object = this.invokeMethod(container, stringArray, classArray, objectArray);
                break;
            }
            catch (Throwable throwable) {
                continue;
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zoom(int n) {
        boolean bl = this.oldZoom == null;
        int n2 = n = n > 0 ? Math.min(Math.max(25, n), 1200) : n;
        if (bl) {
            this.oldZoom = this.getZoom();
            this.defereRepaint = true;
        }
        try {
            if (this.zoom != n && this.zoom != n) {
                Dimension dimension = this.getViewportSize();
                DjVuImage djVuImage = this.getImage();
                if (djVuImage != null) {
                    Rectangle rectangle = djVuImage.computeScaledBounds(n, dimension);
                    this.setImageSize(rectangle.width, rectangle.height);
                }
                this.zoom = n;
            }
        }
        finally {
            if (bl) {
                this.change.firePropertyChange("zoom", this.oldZoom, this.getZoom());
                this.oldZoom = null;
                this.defereRepaint = false;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

