/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu.anno;

import com.lizardtech.djvu.GRect;

public class Mapper {
    private static final int MIRRORX = 1;
    private static final int MIRRORY = 2;
    private static final int SWAPXY = 4;
    private final int[] rh = new int[]{0, 1};
    private final int[] rw = new int[]{0, 1};
    private GRect rectFrom = new GRect(0, 0, 1, 1);
    private GRect rectTo = new GRect(0, 0, 1, 1);
    private int code = 0;

    public void clear() {
        this.rectFrom = new GRect(0, 0, 1, 1);
        this.rectTo = new GRect(0, 0, 1, 1);
        this.code = 0;
    }

    public GRect getInput() {
        return this.rectFrom;
    }

    public GRect getOutput() {
        return this.rectTo;
    }

    public void map(GRect gRect) {
        int n = this.mapX(gRect.xmin, gRect.ymin);
        int n2 = this.mapY(gRect.xmin, gRect.ymin);
        int n3 = this.mapX(gRect.xmax, gRect.ymax);
        int n4 = this.mapY(gRect.xmax, gRect.ymax);
        if (n < n3) {
            gRect.xmin = n;
            gRect.xmax = n3;
        } else {
            gRect.xmin = n3;
            gRect.xmax = n;
        }
        if (n2 < n2) {
            gRect.ymin = n2;
            gRect.ymax = n4;
        } else {
            gRect.ymin = n4;
            gRect.ymax = n2;
        }
    }

    public int mapX(int n, int n2) {
        return this.map(n, n2, true);
    }

    public int mapY(int n, int n2) {
        return this.map(n, n2, false);
    }

    public void mirrorx() {
        this.code ^= 1;
    }

    public void mirrory() {
        this.code ^= 2;
    }

    public void rotate(int n) {
        int n2 = this.code;
        switch (n & 3) {
            case 1: {
                this.code ^= (this.code & 4) != 0 ? 2 : 1;
                this.code ^= 4;
                break;
            }
            case 2: {
                this.code ^= 3;
                break;
            }
            case 3: {
                this.code ^= (this.code & 4) != 0 ? 1 : 2;
                this.code ^= 4;
            }
        }
        if (((n2 ^ this.code) & 4) != 0) {
            int n3 = this.rectFrom.xmin;
            this.rectFrom.xmin = this.rectFrom.ymin;
            this.rectFrom.ymin = n3;
            n3 = this.rectFrom.xmax;
            this.rectFrom.xmax = this.rectFrom.ymax;
            this.rectFrom.ymax = n3;
            this.rw[0] = 0;
            this.rw[1] = 1;
            this.rh[0] = 0;
            this.rh[1] = 1;
        }
    }

    public void rotate() {
        this.rotate(1);
    }

    public void setInput(GRect gRect) {
        if (gRect.isEmpty()) {
            throw new IllegalArgumentException("GRect.empty_rect1");
        }
        this.rectFrom = gRect;
        if ((this.code & 4) != 0) {
            int n = this.rectFrom.xmin;
            this.rectFrom.xmin = this.rectFrom.ymin;
            this.rectFrom.ymin = n;
            n = this.rectFrom.xmax;
            this.rectFrom.xmax = this.rectFrom.ymax;
            this.rectFrom.ymax = n;
        }
        this.rw[0] = 0;
        this.rw[1] = 1;
        this.rh[0] = 0;
        this.rh[1] = 1;
    }

    public void setOutput(GRect gRect) {
        if (gRect.isEmpty()) {
            throw new IllegalArgumentException("GRect.empty_rect2");
        }
        this.rectTo = gRect;
        this.rw[0] = 0;
        this.rw[1] = 1;
        this.rh[0] = 0;
        this.rh[1] = 1;
    }

    public int unmap(int n, int n2, boolean bl) {
        if (this.rw[0] == 0 || this.rh[0] == 0) {
            this.precalc();
        }
        int n3 = this.rectFrom.xmin + Mapper.DIVI(n - this.rectTo.xmin, this.rw);
        int n4 = this.rectFrom.ymin + Mapper.DIVI(n2 - this.rectTo.ymin, this.rh);
        if ((this.code & 1) != 0) {
            n3 = this.rectFrom.xmin + this.rectFrom.xmax - n3;
        }
        if ((this.code & 2) != 0) {
            n4 = this.rectFrom.ymin + this.rectFrom.ymax - n4;
        }
        if ((this.code & 4) != 0) {
            int n5 = n3;
            n3 = n4;
            n4 = n5;
        }
        return bl ? n3 : n4;
    }

    public void unmap(GRect gRect) {
        int n = this.unmapX(gRect.xmin, gRect.ymin);
        int n2 = this.unmapY(gRect.xmin, gRect.ymin);
        int n3 = this.unmapX(gRect.xmax, gRect.ymax);
        int n4 = this.unmapY(gRect.xmax, gRect.ymax);
        if (n < n3) {
            gRect.xmin = n;
            gRect.xmax = n3;
        } else {
            gRect.xmin = n3;
            gRect.xmax = n;
        }
        if (n2 < n4) {
            gRect.ymin = n2;
            gRect.ymax = n4;
        } else {
            gRect.ymin = n4;
            gRect.ymax = n2;
        }
    }

    public int unmapX(int n, int n2) {
        return this.unmap(n, n2, true);
    }

    public int unmapY(int n, int n2) {
        return this.unmap(n, n2, false);
    }

    static int DIVI(int n, int[] nArray) {
        return (int)(((double)n * (double)nArray[1] + (double)nArray[0] / 2.0) / (double)nArray[0]);
    }

    private static int MULT(int n, int[] nArray) {
        return (int)(((double)n * (double)nArray[0] + (double)nArray[1] / 2.0) / (double)nArray[1]);
    }

    private int map(int n, int n2, boolean bl) {
        int n3 = n;
        int n4 = n2;
        if (this.rw[0] == 0 || this.rh[0] == 0) {
            this.precalc();
        }
        if ((this.code & 4) != 0) {
            int n5 = n3;
            n3 = n4;
            n4 = n5;
        }
        if ((this.code & 1) != 0) {
            n3 = this.rectFrom.xmin + this.rectFrom.xmax - n3;
        }
        if ((this.code & 2) != 0) {
            n4 = this.rectFrom.ymin + this.rectFrom.ymax - n4;
        }
        return bl ? this.rectTo.xmin + Mapper.MULT(n3 - this.rectFrom.xmin, this.rw) : this.rectTo.ymin + Mapper.MULT(n4 - this.rectFrom.ymin, this.rh);
    }

    private static void ratio(int[] nArray, int n, int n2) {
        if (n2 == 0) {
            new IllegalStateException("GRect.div_zero");
        }
        if (n == 0) {
            n2 = 1;
        }
        if (n2 < 0) {
            n = -n;
            n2 = -n2;
        }
        int n3 = 1;
        int n4 = n;
        int n5 = n2;
        if (n4 > n5) {
            n3 = n4;
            n4 = n5;
            n5 = n3;
        }
        while (n4 > 0) {
            n3 = n4;
            n4 = n5 % n4;
            n5 = n3;
        }
        nArray[0] = n / n3;
        nArray[1] = n2 / n3;
    }

    private void precalc() {
        if (this.rectTo.isEmpty() || this.rectFrom.isEmpty()) {
            throw new IllegalStateException("GRect.empty_rect3");
        }
        Mapper.ratio(this.rw, this.rectTo.width(), this.rectFrom.width());
        Mapper.ratio(this.rh, this.rectTo.height(), this.rectFrom.height());
    }
}

