/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu;

import com.lizardtech.djvu.CachedInputStream;
import com.lizardtech.djvu.DjVuInterface;
import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.DjVuOptions;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class IFFEnumeration
extends DjVuObject
implements Enumeration {
    static String[] szComposite = new String[]{"FORM", "LIST", "PROP", "CAT "};
    static String[] szReserved = new String[]{"FOR", "LIS", "CAT"};
    protected CachedInputStream input;
    protected CachedInputStream next = null;
    private byte[] bufA = new byte[4];
    private byte[] bufB = new byte[4];
    static /* synthetic */ Class class$com$lizardtech$djvu$IFFEnumeration;

    public static IFFEnumeration createIFFEnumeration(DjVuInterface djVuInterface) {
        DjVuOptions djVuOptions = djVuInterface.getDjVuOptions();
        return (IFFEnumeration)DjVuObject.create(djVuOptions, djVuOptions.getIFFEnumerationClass(), class$com$lizardtech$djvu$IFFEnumeration == null ? (class$com$lizardtech$djvu$IFFEnumeration = IFFEnumeration.class$("com.lizardtech.djvu.IFFEnumeration")) : class$com$lizardtech$djvu$IFFEnumeration);
    }

    public IFFEnumeration init(CachedInputStream cachedInputStream) {
        this.input = (CachedInputStream)cachedInputStream.clone();
        return this;
    }

    public boolean hasMoreElements() {
        if (this.next == null) {
            try {
                this.next = this.openChunk();
            }
            catch (IOException iOException) {
                iOException.printStackTrace(DjVuOptions.err);
                this.next = null;
            }
        }
        return this.next != null;
    }

    public Object nextElement() throws NoSuchElementException {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException("EOF");
        }
        CachedInputStream cachedInputStream = this.next;
        this.next = null;
        return cachedInputStream;
    }

    private CachedInputStream openChunk() throws IOException {
        do {
            if (this.input.read(this.bufA) >= 4) continue;
            return null;
        } while (this.bufA[0] == 65 && this.bufA[1] == 84 && this.bufA[2] == 38 && this.bufA[3] == 84);
        if (this.input.read(this.bufB) < 4) {
            return null;
        }
        int n = (0xFF & this.bufB[0]) << 24 | (0xFF & this.bufB[1]) << 16 | (0xFF & this.bufB[2]) << 8 | 0xFF & this.bufB[3];
        if (n < 0) {
            return null;
        }
        String string = IFFEnumeration.genId(this.bufA);
        String string2 = null;
        if (IFFEnumeration.check_id(string)) {
            if (n < 4) {
                return null;
            }
            if (this.input.read(this.bufB) < 4) {
                return null;
            }
            n -= 4;
            string2 = IFFEnumeration.genId(this.bufB);
            IFFEnumeration.check_id(string2);
        }
        CachedInputStream cachedInputStream = this.input.createCachedInputStream(n);
        cachedInputStream.setName(string2 != null ? string + ":" + string2 : string);
        this.input.skip(n + (n & 1));
        return cachedInputStream;
    }

    private static String genId(byte[] byArray) {
        return byArray != null && byArray.length > 0 ? (new String(byArray, 0, byArray.length) + "\u0000\u0000\u0000\u0000").substring(0, 4) : "\u0000\u0000\u0000\u0000";
    }

    public static boolean check_id(String string) throws IOException {
        int n;
        for (n = 0; n < 4; ++n) {
            if (string.charAt(n) >= ' ' && string.charAt(n) <= '~') continue;
            throw new IOException("Illegal chunk id");
        }
        for (n = 0; n < szComposite.length; ++n) {
            if (!string.equals(szComposite[n])) continue;
            return true;
        }
        String string2 = string.substring(0, 3);
        for (int i = 0; i < szReserved.length; ++i) {
            if (!string2.equals(szReserved[i]) || string.charAt(3) < '1' || string.charAt(3) > '9') continue;
            throw new IOException("Illegal chunk id");
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

