/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu;

import com.lizardtech.djvu.GPixel;
import com.lizardtech.djvu.GPixelReference;
import com.lizardtech.djvu.GPixmap;
import com.lizardtech.djvu.GRect;

class GPixmapScaler {
    private static final int FRACBITS = 4;
    private static final int FRACSIZE = 16;
    private static final int FRACSIZE2 = 8;
    private static final int FRACMASK = 15;
    private static final short[][] interp = new short[16][512];
    private GPixmap p1 = null;
    private GPixmap p2 = null;
    private int[] hcoord = null;
    private int[] vcoord = null;
    private int destHeight = 0;
    private int destWidth = 0;
    private int l1 = -1;
    private int l2 = -1;
    private int redh = 0;
    private int redw = 0;
    private int srcHeight = 0;
    private int srcWidth = 0;
    private int xshift = 0;
    private int yshift = 0;

    public GPixmapScaler() {
    }

    public GPixmapScaler(int n, int n2, int n3, int n4) {
        this.setSrcSize(n, n2);
        this.setDestSize(n3, n4);
    }

    final void setDestSize(int n, int n2) {
        this.destWidth = n;
        this.destHeight = n2;
        this.vcoord = null;
        this.hcoord = null;
    }

    final void setHorzRatio(int n, int n2) {
        if (this.srcWidth <= 0 || this.srcHeight <= 0 || this.destWidth <= 0 || this.destHeight <= 0) {
            throw new IllegalStateException("Scaler undefined size");
        }
        if (n == 0 && n2 == 0) {
            n = this.destWidth;
            n2 = this.srcWidth;
        } else if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Scaler illegal ratio");
        }
        this.xshift = 0;
        this.redw = this.srcWidth;
        while (n + n < n2) {
            ++this.xshift;
            this.redw = this.redw + 1 >> 1;
            n <<= 1;
        }
        if (this.hcoord == null) {
            this.hcoord = new int[this.destWidth];
        }
        GPixmapScaler.prepare_coord(this.hcoord, this.redw, this.destWidth, n2, n);
    }

    final GRect getRequiredRect(GRect gRect) {
        GRect gRect2 = new GRect();
        return this.createRectangles(gRect, gRect2);
    }

    final void setSrcSize(int n, int n2) {
        this.srcWidth = n;
        this.srcHeight = n2;
        this.vcoord = null;
        this.hcoord = null;
    }

    final void setVertRatio(int n, int n2) {
        if (this.srcWidth <= 0 || this.srcHeight <= 0 || this.destWidth <= 0 || this.destHeight <= 0) {
            throw new IllegalStateException("Scaler undefined size");
        }
        if (n == 0 && n2 == 0) {
            n = this.destHeight;
            n2 = this.srcHeight;
        } else if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Scaler illegal ratio");
        }
        this.yshift = 0;
        this.redh = this.srcHeight;
        while (n + n < n2) {
            ++this.yshift;
            this.redh = this.redh + 1 >> 1;
            n <<= 1;
        }
        if (this.vcoord == null) {
            this.vcoord = new int[this.destHeight];
        }
        GPixmapScaler.prepare_coord(this.vcoord, this.redh, this.destHeight, n2, n);
    }

    final GRect createRectangles(GRect gRect, GRect gRect2) {
        GRect gRect3 = new GRect();
        if (gRect.xmin < 0 || gRect.ymin < 0 || gRect.xmax > this.destWidth || gRect.ymax > this.destHeight) {
            throw new IllegalArgumentException("desired rectangle too big: " + gRect.xmin + "," + gRect.ymin + "," + gRect.xmax + "," + gRect.ymax + "," + this.destWidth + "," + this.destHeight);
        }
        if (this.vcoord == null) {
            this.setVertRatio(0, 0);
        }
        if (this.hcoord == null) {
            this.setHorzRatio(0, 0);
        }
        gRect2.xmin = this.hcoord[gRect.xmin] >> 4;
        gRect2.ymin = this.vcoord[gRect.ymin] >> 4;
        gRect2.xmax = this.hcoord[gRect.xmax - 1] + 16 - 1 >> 4;
        gRect2.ymax = this.vcoord[gRect.ymax - 1] + 16 - 1 >> 4;
        gRect2.xmin = gRect2.xmin > 0 ? gRect2.xmin : 0;
        gRect2.xmax = gRect2.xmax < this.redw ? gRect2.xmax + 1 : this.redw;
        gRect2.ymin = gRect2.ymin > 0 ? gRect2.ymin : 0;
        gRect2.ymax = gRect2.ymax < this.redh ? gRect2.ymax + 1 : this.redh;
        gRect3.xmin = gRect2.xmin << this.xshift;
        if (gRect3.xmin < 0) {
            gRect3.xmin = 0;
        }
        gRect3.xmax = gRect2.xmax << this.xshift;
        if (gRect3.xmax > this.srcWidth) {
            gRect3.xmax = this.srcWidth;
        }
        gRect3.ymin = gRect2.ymin << this.yshift;
        if (gRect3.ymin < 0) {
            gRect3.ymin = 0;
        }
        gRect3.ymax = gRect2.ymax << this.yshift;
        if (gRect3.ymax > this.srcHeight) {
            gRect3.ymax = this.srcHeight;
        }
        return gRect3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void scale(GRect gRect, GPixmap gPixmap, GRect gRect2, GPixmap gPixmap2) {
        GRect gRect3 = new GRect();
        GRect gRect4 = this.createRectangles(gRect2, gRect3);
        if (gRect.width() != gPixmap.columns() || gRect.height() != gPixmap.rows()) {
            throw new IllegalArgumentException("invalid rectangle");
        }
        if (gRect.xmin > gRect4.xmin || gRect.ymin > gRect4.ymin || gRect.xmax < gRect4.xmax || gRect.ymax < gRect4.ymax) {
            throw new IllegalStateException("invalid rectangle");
        }
        if (gRect2.width() != gPixmap2.columns() || gRect2.height() != gPixmap2.rows()) {
            gPixmap2.init(gRect2.height(), gRect2.width(), null);
        }
        int n = gRect3.width();
        GPixel[] gPixelArray = new GPixel[n + 2];
        int n2 = 0;
        while (n2 < gPixelArray.length) {
            gPixelArray[n2++] = new GPixel();
        }
        try {
            if (this.xshift > 0 || this.yshift > 0) {
                this.p1 = GPixmap.createGPixmap(gPixmap2).init(1, n, null);
                this.p2 = GPixmap.createGPixmap(gPixmap2).init(2, n, null);
                this.l2 = -1;
                this.l1 = -1;
            }
            for (n2 = gRect2.ymin; n2 < gRect2.ymax; ++n2) {
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                int n8;
                GPixelReference gPixelReference;
                GPixelReference gPixelReference2;
                int n9 = this.vcoord[n2];
                int n10 = n9 >> 4;
                int n11 = n10 + 1;
                if (this.xshift > 0 || this.yshift > 0) {
                    gPixelReference2 = this.get_line(n10, gRect3, gRect, gPixmap);
                    gPixelReference = this.get_line(n11, gRect3, gRect, gPixmap);
                } else {
                    n8 = gRect3.xmin - gRect.xmin;
                    if (gRect3.ymin > n10) {
                        n10 = gRect3.ymin;
                    }
                    if (gRect3.ymax <= n11) {
                        n11 = gRect3.ymax - 1;
                    }
                    gPixelReference2 = gPixmap.createGPixelReference(n10 - gRect.ymin, n8);
                    gPixelReference = gPixmap.createGPixelReference(n11 - gRect.ymin, n8);
                }
                n8 = 1;
                Object object = interp[n9 & 0xF];
                int n12 = n8 + n;
                while (n8 < n12) {
                    GPixel gPixel = gPixelArray[n8++];
                    n7 = gPixelReference2.getRed();
                    n6 = object[256 + gPixelReference.getRed() - n7];
                    n5 = gPixelReference2.getGreen();
                    n4 = object[256 + gPixelReference.getGreen() - n5];
                    n3 = gPixelReference2.getBlue();
                    short s = object[256 + gPixelReference.getBlue() - n3];
                    gPixel.setBGR(n3 + s, n5 + n4, n7 + n6);
                    gPixelReference.incOffset();
                    gPixelReference2.incOffset();
                }
                gPixelArray[0] = gPixelArray[1];
                n9 = 1 - gRect3.xmin;
                GPixelReference gPixelReference3 = gPixmap2.createGPixelReference(n2 - gRect2.ymin, 0);
                for (n11 = gRect2.xmin; n11 < gRect2.xmax; ++n11) {
                    int n13 = this.hcoord[n11];
                    int n14 = n9 + (n13 >> 4);
                    GPixel gPixel = gPixelArray[n14];
                    object = gPixelArray[n14 + 1];
                    short[] sArray = interp[n13 & 0xF];
                    int n15 = gPixel.getRed();
                    n7 = sArray[256 + ((GPixel)object).getRed() - n15];
                    n6 = gPixel.getGreen();
                    n5 = sArray[256 + ((GPixel)object).getGreen() - n6];
                    n4 = gPixel.getBlue();
                    n3 = sArray[256 + ((GPixel)object).getBlue() - n4];
                    gPixelReference3.setBGR(n4 + n3, n6 + n5, n15 + n7);
                    gPixelReference3.incOffset();
                }
            }
        }
        finally {
            this.p1 = null;
            this.p2 = null;
        }
    }

    private static void prepare_coord(int[] nArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n3 * 16;
        int n7 = n5 = (n6 + n4) / (2 * n4) - 8;
        int n8 = n4 / 2;
        int n9 = (n - 1) * 16;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n7 < n9 ? n7 : n9;
            n7 += (n8 += n6) / n4;
            n8 %= n4;
        }
        if (n4 == n2 && n7 != n5 + n6) {
            throw new IllegalStateException("Scaler assertion");
        }
    }

    private GPixelReference get_line(int n, GRect gRect, GRect gRect2, GPixmap gPixmap) {
        if (n < gRect.ymin) {
            n = gRect.ymin;
        } else if (n >= gRect.ymax) {
            n = gRect.ymax - 1;
        }
        if (n == this.l2) {
            return this.p2.createGPixelReference(0);
        }
        if (n == this.l1) {
            return this.p1.createGPixelReference(0);
        }
        GPixmap gPixmap2 = this.p1;
        this.p1 = this.p2;
        this.l1 = this.l2;
        this.p2 = gPixmap2;
        this.l2 = n;
        GRect gRect3 = new GRect();
        gRect3.xmin = gRect.xmin << this.xshift;
        gRect3.xmax = gRect.xmax << this.xshift;
        gRect3.ymin = n << this.yshift;
        gRect3.ymax = n + 1 << this.yshift;
        gRect3.intersect(gRect3, gRect2);
        gRect3.translate(-gRect2.xmin, -gRect2.ymin);
        int n2 = gPixmap.rowOffset(gRect3.ymin);
        int n3 = gPixmap.getRowSize();
        int n4 = 1 << this.xshift;
        int n5 = this.xshift + this.yshift;
        int n6 = 1 << n5 - 1;
        int n7 = n6 + n6;
        GPixelReference gPixelReference = gPixmap.createGPixelReference(0);
        GPixelReference gPixelReference2 = gPixmap2.createGPixelReference(0);
        for (int i = gRect3.xmin; i < gRect3.xmax; i += n4) {
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = n2 + i;
            int n13 = 1 << this.yshift;
            int n14 = gRect3.height();
            if (n13 > n14) {
                n13 = n14;
            }
            int n15 = 0;
            while (n15 < n13) {
                int n16 = i + n4;
                gPixelReference.setOffset(n12);
                if (n16 > gRect3.xmax) {
                    n16 = gRect3.xmax;
                }
                int n17 = n16 - i;
                while (n17-- > 0) {
                    n8 += gPixelReference.getRed();
                    n9 += gPixelReference.getGreen();
                    n10 += gPixelReference.getBlue();
                    ++n11;
                    gPixelReference.incOffset();
                }
                ++n15;
                n12 += n3;
            }
            if (n11 == n7) {
                gPixelReference2.setBGR(n10 + n6 >> n5, n9 + n8 >> n5, n8 + n6 >> n5);
            } else {
                gPixelReference2.setBGR((n10 + n11 / 2) / 2, (n9 + n11 / 2) / n11, (n8 + n11 / 2) / n11);
            }
            gPixelReference2.incOffset();
        }
        return this.p2.createGPixelReference(0);
    }

    static {
        for (int i = 0; i < 16; ++i) {
            short[] sArray = interp[i];
            for (int j = -255; j <= 255; ++j) {
                sArray[256 + j] = (short)(j * i + 8 >> 4);
            }
        }
    }
}

