/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvu;

import com.lizardtech.djvu.DjVuInterface;
import com.lizardtech.djvu.DjVuObject;
import com.lizardtech.djvu.DjVuOptions;
import com.lizardtech.djvu.GMap;
import com.lizardtech.djvu.GPixel;
import com.lizardtech.djvu.GPixelReference;
import com.lizardtech.djvu.GRect;

public class GBitmap
extends GMap
implements Cloneable {
    static Object[] rampRefArray = new Object[256];
    protected int grays = 0;
    private int border = 0;
    private int rowSize = 0;
    private int maxRowOffset = 0;
    private GPixel[] ramp = null;
    static /* synthetic */ Class class$com$lizardtech$djvu$GBitmap;

    public GBitmap() {
        super(1, 0, 0, 0, true);
    }

    public GPixel[] getRamp() {
        GPixel[] gPixelArray = this.ramp;
        if (gPixelArray == null) {
            int n = this.grays;
            gPixelArray = (GPixel[])DjVuObject.getFromReference(rampRefArray[n]);
            if (gPixelArray == null) {
                gPixelArray = new GPixel[256];
                gPixelArray[0] = GPixel.WHITE;
                int n2 = 0xFF0000;
                int n3 = n > 1 ? n - 1 : 1;
                int n4 = 1;
                if (n3 > 1) {
                    int n5 = n2 / n3;
                    do {
                        byte by = (byte)((n2 -= n5) >> 16);
                        gPixelArray[n4++] = new GPixel(by, by, by);
                    } while (n4 < n3);
                }
                while (n4 < gPixelArray.length) {
                    gPixelArray[n4++] = GPixel.BLACK;
                }
                GBitmap.rampRefArray[n] = DjVuObject.createSoftReference(gPixelArray, null);
            }
            this.ramp = gPixelArray;
        }
        return gPixelArray;
    }

    public static GBitmap createGBitmap(DjVuInterface djVuInterface) {
        DjVuOptions djVuOptions = djVuInterface.getDjVuOptions();
        return (GBitmap)DjVuObject.create(djVuOptions, djVuOptions.getGBitmapClass(), class$com$lizardtech$djvu$GBitmap == null ? (class$com$lizardtech$djvu$GBitmap = GBitmap.class$("com.lizardtech.djvu.GBitmap")) : class$com$lizardtech$djvu$GBitmap);
    }

    public final boolean getBooleanAt(int n) {
        return n < this.border || n >= this.maxRowOffset || this.data[n] == 0;
    }

    public final void setByteAt(int n, int n2) {
        if (n >= this.border || n < this.maxRowOffset) {
            this.data[n] = (byte)n2;
        }
    }

    public final int getByteAt(int n) {
        return n < this.border || n >= this.maxRowOffset ? 0 : 0xFF & this.data[n];
    }

    public int getBytesPerRow() {
        return this.rowSize;
    }

    public final int getGrays() {
        return this.grays;
    }

    public void setGrays(int n) {
        if (n < 2 || n > 256) {
            throw new IllegalArgumentException("(GBitmap::set_grays) Illegal number of gray levels");
        }
        this.grays = n;
        this.ramp = null;
    }

    private final void setRowSize(int n) {
        this.rowSize = n;
        this.maxRowOffset = this.rowOffset(this.nrows);
    }

    private final void setRows(int n) {
        if (n != this.nrows) {
            this.nrows = n;
            this.maxRowOffset = this.rowOffset(this.nrows);
        }
    }

    public boolean blit(GBitmap gBitmap, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        if (n3 == 1) {
            return this.insertMap(gBitmap, n, n2, true);
        }
        if (n >= this.ncolumns * n3 || n2 >= this.nrows * n3 || n + gBitmap.columns() < 0 || n2 + gBitmap.rows() < 0) {
            return false;
        }
        if (gBitmap.data != null) {
            int n6;
            int n7;
            int n8 = n2 / n3;
            int n9 = n2 - n3 * n8;
            if (n9 < 0) {
                --n8;
                n9 += n3;
            }
            if ((n7 = n - n3 * (n6 = n / n3)) < 0) {
                --n6;
                n7 += n3;
            }
            int n10 = 0;
            for (int i = 0; i < gBitmap.rows(); ++i) {
                if (n8 >= 0 && n8 < this.nrows) {
                    int n11 = n6;
                    int n12 = n7;
                    n5 = gBitmap.rowOffset(i);
                    n4 = this.rowOffset(n8);
                    for (int j = 0; j < gBitmap.columns(); ++j) {
                        if (n11 >= 0 && n11 < this.ncolumns) {
                            int n13 = n4 + n11;
                            this.data[n13] = (byte)(this.data[n13] + gBitmap.data[n5 + j]);
                        }
                        if (++n12 < n3) continue;
                        n12 = 0;
                        ++n11;
                    }
                }
                if (++n9 < n3) continue;
                n9 = 0;
                ++n8;
                ++n10;
            }
        }
        return true;
    }

    public final int rowOffset(int n) {
        return n * this.rowSize + this.border;
    }

    public final int getRowSize() {
        return this.rowSize;
    }

    public void fill(short s) {
        int n = 0;
        byte by = (byte)s;
        for (int i = 0; i < this.rows(); ++i) {
            n = this.rowOffset(i);
            for (int j = 0; j < this.ncolumns; ++j) {
                this.data[n + j] = by;
            }
        }
    }

    public void fill(GMap gMap, int n, int n2) {
        this.insertMap((GBitmap)gMap, n, n2, false);
    }

    public boolean insertMap(GBitmap gBitmap, int n, int n2, boolean bl) {
        int n3;
        int n4 = n > 0 ? n : 0;
        int n5 = n2 > 0 ? n2 : 0;
        int n6 = n < 0 ? -n : 0;
        int n7 = n2 < 0 ? -n2 : 0;
        int n8 = this.columns() - n4;
        int n9 = gBitmap.columns() - n6;
        int n10 = n8 < n9 ? n8 : n9;
        int n11 = this.rows() - n5;
        int n12 = gBitmap.rows() - n7;
        int n13 = n3 = n11 < n12 ? n11 : n12;
        if (n10 > 0 && n3 > 0) {
            byte by = (byte)(this.grays - 1);
            do {
                int n14 = this.rowOffset(n5++) + n4;
                int n15 = gBitmap.rowOffset(n7++) + n6;
                int n16 = n10;
                if (bl) {
                    do {
                        int n17 = this.data[n14] + gBitmap.data[n15++];
                        byte by2 = this.data[n14++] = n17 < this.grays ? (byte)n17 : by;
                    } while (--n16 > 0);
                    continue;
                }
                do {
                    this.data[n14++] = gBitmap.data[n15++];
                } while (--n16 > 0);
            } while (--n3 > 0);
            return true;
        }
        return false;
    }

    public GBitmap init(int n, int n2, int n3) {
        this.data = null;
        this.grays = 2;
        this.setRows(n);
        this.ncolumns = n2;
        this.border = n3;
        this.setRowSize(this.ncolumns + this.border);
        int n4 = this.rowOffset(this.nrows);
        if (n4 > 0) {
            this.data = new byte[n4];
            for (int i = 0; i < n4; ++i) {
                this.data[i] = 0;
            }
        }
        return this;
    }

    public final GBitmap init(GBitmap gBitmap) {
        return this.init(gBitmap, 0);
    }

    public GBitmap init(GBitmap gBitmap, int n) {
        if (this != gBitmap) {
            this.init(gBitmap.rows(), gBitmap.columns(), n);
            this.grays = gBitmap.grays;
            for (int i = 0; i < this.nrows; ++i) {
                int n2 = this.ncolumns;
                int n3 = this.rowOffset(i);
                int n4 = gBitmap.rowOffset(i);
                while (n2-- > 0) {
                    this.data[n3++] = gBitmap.data[n4++];
                }
            }
        } else if (n > this.border) {
            this.setMinimumBorder(n);
        }
        return this;
    }

    public GBitmap init(GBitmap gBitmap, GRect gRect, int n) {
        if (this == gBitmap) {
            GBitmap gBitmap2 = new GBitmap();
            gBitmap2.setGrays(this.grays);
            gBitmap2.setBorder((short)n);
            gBitmap2.setRowSize(this.rowSize);
            gBitmap2.ncolumns = this.ncolumns;
            gBitmap2.setRows(this.nrows);
            gBitmap2.data = this.data;
            this.data = null;
            this.init(gBitmap2, gRect, n);
        } else {
            this.init(gRect.height(), gRect.width(), n);
            this.grays = gBitmap.grays;
            GRect gRect2 = new GRect(0, 0, gBitmap.columns(), gBitmap.rows());
            gRect2.intersect(gRect2, gRect);
            gRect2.translate(-gRect.xmin, -gRect.ymin);
            if (!gRect2.isEmpty()) {
                int n2 = 0;
                int n3 = 0;
                for (int i = gRect2.ymin; i < gRect2.ymax; ++i) {
                    n2 = this.rowOffset(i);
                    n3 = gBitmap.rowOffset(i + gRect.ymin);
                    for (int j = gRect2.xmin; j < gRect2.ymax; ++j) {
                        this.data[n2 + j] = gBitmap.data[n3 + j];
                    }
                }
            }
        }
        return this;
    }

    public void setMinimumBorder(int n) {
        if (this.border < n) {
            if (this.data != null) {
                GBitmap gBitmap = new GBitmap().init(this, n);
                this.setRowSize(gBitmap.getRowSize());
                this.data = gBitmap.data;
                gBitmap.data = null;
                if (DjVuOptions.COLLECT_GARBAGE) {
                    System.gc();
                }
            }
            this.setBorder(n);
        }
    }

    public GMap translate(int n, int n2, GMap gMap) {
        if (!(gMap instanceof GBitmap) || gMap.columns() != this.columns() || gMap.rows() != this.rows()) {
            GBitmap gBitmap = new GBitmap().init(this.rows(), this.columns(), 0);
            if (this.grays >= 2 && this.grays <= 256) {
                gBitmap.setGrays(this.grays);
            }
            gMap = gBitmap;
        }
        gMap.fill(this, -n, -n2);
        return gMap;
    }

    private void setBorder(int n) {
        this.border = n;
        this.maxRowOffset = this.rowOffset(this.nrows);
    }

    protected final int getBorder() {
        return this.border;
    }

    public GPixel ramp(GPixelReference gPixelReference) {
        return this.getRamp()[gPixelReference.getBlue()];
    }

    public boolean isRampNeeded() {
        return true;
    }

    public synchronized GRect compute_bounding_box() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = this.columns();
        int n8 = this.rows();
        int n9 = this.getRowSize();
        for (n6 = n7 - 1; n6 >= 0; --n6) {
            n4 = n5 + n9 * n8;
            for (n5 = this.rowOffset(0) + n6; n5 < n4 && this.getBooleanAt(n5); n5 += n9) {
            }
            if (n5 < n4) break;
        }
        for (n3 = n8 - 1; n3 >= 0; --n3) {
            n4 = n5 + n7;
            for (n5 = this.rowOffset(n3); n5 < n4 && this.getBooleanAt(n5); ++n5) {
            }
            if (n5 < n4) break;
        }
        for (n2 = 0; n2 <= n6; ++n2) {
            n4 = n5 + n9 * n8;
            for (n5 = this.rowOffset(0) + n2; n5 < n4 && this.getBooleanAt(n5); n5 += n9) {
            }
            if (n5 < n4) break;
        }
        for (n = 0; n <= n3; ++n) {
            n4 = n5 + n7;
            for (n5 = this.rowOffset(n); n5 < n4 && this.getBooleanAt(n5); ++n5) {
            }
            if (n5 < n4) break;
        }
        GRect gRect = new GRect();
        gRect.xmin = n2;
        gRect.xmax = n6;
        gRect.ymin = n;
        gRect.ymax = n3;
        return gRect;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        int n = 0;
        while (n < rampRefArray.length) {
            GBitmap.rampRefArray[n++] = null;
        }
    }
}

