/*
 * Decompiled with CFR 0.152.
 */
package jecomics;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class JEImagePanel
extends JPanel {
    private String path = null;
    private boolean fitimage = true;
    private BufferedImage img = null;

    public void setFitImage(boolean n2) {
        this.fitimage = n2;
    }

    public JEImagePanel() {
        this.fitimage = true;
    }

    public JEImagePanel(boolean fit) {
        this.fitimage = fit;
    }

    public void setImage(BufferedImage image) {
        this.img = image;
        if (!this.fitimage && this.img != null) {
            this.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
        } else {
            this.setPreferredSize(null);
        }
        this.repaint();
        this.invalidate();
    }

    public void setImage(String path) {
        BufferedImage appo = null;
        this.path = path;
        if (path != null) {
            try {
                appo = ImageIO.read(new File(path));
                this.setImage(appo);
            }
            catch (Exception E) {
                this.setImage((BufferedImage)null);
            }
        } else {
            this.setImage((BufferedImage)null);
        }
    }

    public void paint(Graphics g2) {
        if (this.img != null) {
            float s2;
            int newwidth = 0;
            int newheight = 0;
            int offsetx = 0;
            int offsety = 0;
            float r2 = 1.0f * (float)this.img.getWidth() / (float)this.img.getHeight();
            if (r2 > (s2 = 1.0f * (float)this.getWidth() / (float)this.getHeight())) {
                newwidth = this.getWidth();
                newheight = Math.round((float)this.getWidth() / r2);
                offsety = (this.getHeight() - newheight) / 2;
            } else {
                newwidth = Math.round((float)this.getHeight() * r2);
                newheight = this.getHeight();
                offsetx = (this.getWidth() - newwidth) / 2;
            }
            g2.draw3DRect(0, 0, this.getWidth(), this.getHeight(), true);
            super.paint(g2);
            if (this.fitimage) {
                g2.drawImage(this.img, offsetx, offsety, newwidth, newheight, null);
            } else {
                g2.drawImage(this.img, offsetx, offsety, null);
            }
        }
    }
}

