/*
 * Decompiled with CFR 0.152.
 */
package jecomics.JECEngine;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import jecomics.JECEngine.JECImageFilters;
import jecomics.JECEngine.JECOutputType;

public class JECImageProcessor {
    private int mode = 0;
    private int width = 768;
    private int height = 935;
    private int croptop = 10;
    private int cropbottom = 10;
    private int cropleft = 0;
    private int cropright = 0;
    public float brightness = 1.0f;
    public float contrast = 1.0f;
    public boolean errorDiffusion = false;
    public boolean smartSmooth = false;
    public boolean sharpening = false;
    public boolean resize = true;
    public boolean deshade = true;
    private boolean lossless = true;
    protected JECOutputType output = null;
    private boolean bw = true;

    public void setLossless(boolean n2) {
        this.lossless = n2;
    }

    public boolean getLossless() {
        return this.lossless;
    }

    public void doProcess(BufferedImage source, OutputStream Out) throws IOException {
        BufferedImage image = this.doProcess(source);
        if (!this.lossless) {
            JPEGImageEncoder enc = JPEGCodec.createJPEGEncoder((OutputStream)Out);
            JPEGEncodeParam prm = enc.getDefaultJPEGEncodeParam(image);
            prm.setQuality(0.78f, false);
            enc.encode(image, prm);
        } else {
            ImageIO.write((RenderedImage)image, "png", Out);
        }
    }

    public BufferedImage doProcess(BufferedImage source) throws IOException {
        boolean debug = false;
        this.bw = this.output.isBlackAndWhite();
        BufferedImage image = null;
        if (!this.resize) {
            this.width = source.getWidth();
            this.height = source.getHeight();
        }
        if (this.bw) {
            source = JECImageFilters.convertToGrayscale(source);
            image = new BufferedImage(this.width, this.height, 11);
        } else {
            image = new BufferedImage(this.width, this.height, 1);
        }
        int newwidth = 0;
        int newheight = 0;
        int offsetx = 0;
        int offsety = 0;
        float r2 = 1.0f * (float)source.getWidth() / (float)source.getHeight();
        float s2 = 1.0f * (float)this.width / (float)this.height;
        if (r2 > s2) {
            newwidth = this.width;
            newheight = Math.round((float)this.width / r2);
            offsety = (this.height - newheight) / 2;
        } else {
            newwidth = Math.round((float)this.height * r2);
            newheight = this.height;
            offsetx = (this.width - newwidth) / 2;
        }
        Graphics2D GImage = image.createGraphics();
        GImage.setColor(new Color(255, 255, 255));
        GImage.draw(new Rectangle(0, 0, this.width, this.height));
        GImage.fill(new Rectangle(0, 0, this.width, this.height));
        if (this.resize) {
            Image app = JECImageFilters.Resize(source, newwidth, newheight);
            GImage.drawImage(app, offsetx, offsety, null);
        } else {
            GImage.drawImage((Image)source, 0, 0, null);
        }
        GImage.dispose();
        if (debug) {
            ImageIO.write((RenderedImage)image, "png", new File("BaseImage.png"));
        }
        if (this.brightness != 1.0f || this.contrast != 1.0f) {
            image = JECImageFilters.filterImageBC(image, this.contrast, this.brightness);
        }
        if (this.sharpening) {
            image = JECImageFilters.sharpImage(image);
        }
        if (this.smartSmooth) {
            image = JECImageFilters.smartBlur(image);
        }
        if (debug) {
            ImageIO.write((RenderedImage)image, "png", new File("filtered.png"));
        }
        if (this.bw && this.deshade && this.errorDiffusion) {
            image = JECImageFilters.ditherImage(image, this.output.getShadesCount() * 2, this.bw);
        }
        if (!this.lossless) {
            if (this.bw && this.deshade) {
                image = JECImageFilters.reduceGrayscale(image, this.output.Colormodel(), false);
                if (debug) {
                    ImageIO.write((RenderedImage)image, "png", new File("reducedl.png"));
                }
            }
            return image;
        }
        if (this.bw && this.deshade) {
            image = JECImageFilters.reduceGrayscale(image, this.output.Colormodel(), true);
            if (debug) {
                ImageIO.write((RenderedImage)image, "png", new File("reduced.png"));
            }
        }
        return image;
    }

    public JECImageProcessor(JECOutputType om) {
        this.output = om;
        this.width = this.output.getImageWidth();
        this.height = this.output.getImageHeight();
        this.resize = om.getResize();
        this.deshade = om.getDeshade();
    }
}

