/*
 * Decompiled with CFR 0.152.
 */
package jecomics.JECEngine;

import com.jhlabs.image.ContrastFilter;
import com.jhlabs.image.DiffusionFilter;
import com.jhlabs.image.EdgeFilter;
import com.jhlabs.image.InvertFilter;
import com.jhlabs.image.SharpenFilter;
import com.jhlabs.image.SmartBlurFilter;
import com.jhlabs.image.UnsharpFilter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public abstract class JECImageFilters {
    public static BufferedImage reduceGrayscaleOrig(BufferedImage source, IndexColorModel cm) {
        BufferedImage image = new BufferedImage(source.getWidth(), source.getHeight(), 13, cm);
        Graphics2D outg = image.createGraphics();
        outg.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        outg.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        outg.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        outg.drawImage((Image)source, 0, 0, null);
        outg.dispose();
        BufferedImage gray = new BufferedImage(source.getWidth(), source.getHeight(), 10);
        Graphics2D out2d = gray.createGraphics();
        out2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        out2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        out2d.drawImage((Image)image, 0, 0, null);
        out2d.dispose();
        return image;
    }

    public static BufferedImage reduceGrayscale(BufferedImage source, IndexColorModel cm, boolean fullgray) {
        BufferedImage image = source;
        if (!fullgray) {
            return image;
        }
        BufferedImage gray = new BufferedImage(source.getWidth(), source.getHeight(), 10);
        Graphics2D out2d = gray.createGraphics();
        out2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        out2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        out2d.drawImage((Image)image, 0, 0, null);
        out2d.dispose();
        return gray;
    }

    public static BufferedImage reduceGrayscale(BufferedImage source, IndexColorModel cm) {
        return JECImageFilters.reduceGrayscale(source, cm, true);
    }

    public static BufferedImage convertToGrayscale(BufferedImage source) {
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        return op.filter(source, null);
    }

    public static BufferedImage doEdgeEnhanceOLD(BufferedImage source) {
        BufferedImage out = null;
        BufferedImage appo = null;
        BufferedImage edges = null;
        EdgeFilter ef = new EdgeFilter();
        ef.setHEdgeMatrix(EdgeFilter.ROBERTS_H);
        ef.setVEdgeMatrix(EdgeFilter.ROBERTS_V);
        appo = ef.createCompatibleDestImage(source, null);
        edges = ef.createCompatibleDestImage(source, null);
        InvertFilter iv = new InvertFilter();
        ef.filter(source, appo);
        iv.filter(appo, edges);
        edges = JECImageFilters.convertToGrayscale(edges);
        out = ef.createCompatibleDestImage(source, null);
        Graphics2D G = out.createGraphics();
        G.drawImage((Image)source, 0, 0, null);
        G.setComposite(AlphaComposite.getInstance(4, 0.7f));
        G.drawImage((Image)edges, 0, 0, null);
        return out;
    }

    public static BufferedImage doEdgeEnhance(BufferedImage source) {
        BufferedImage out = null;
        BufferedImage edges = null;
        EdgeFilter ef = new EdgeFilter();
        edges = ef.createCompatibleDestImage(source, null);
        ef.setHEdgeMatrix(EdgeFilter.PREWITT_H);
        ef.setVEdgeMatrix(EdgeFilter.PREWITT_V);
        edges = JECImageFilters.convertToGrayscale(source);
        out = ef.createCompatibleDestImage(source, null);
        Graphics2D GDest = out.createGraphics();
        GDest.drawImage((Image)source, 0, 0, null);
        int i2 = 0;
        int j2 = 0;
        int c1 = 0;
        int c2 = 0;
        int c3 = 0;
        int ca = 0;
        int cb = 0;
        for (j2 = 0; j2 < edges.getHeight(); ++j2) {
            for (i2 = 1; i2 < edges.getWidth() - 1; ++i2) {
                c1 = edges.getRGB(i2 - 1, j2) & 0xFF;
                c2 = edges.getRGB(i2, j2) & 0xFF;
                c1 = edges.getRGB(i2 + 1, j2) & 0xFF;
                ca = c2 - c1;
                cb = c3 - c2;
                if (ca <= 160 && (ca <= 60 || cb >= 15)) continue;
                out.setRGB(i2, j2, 0);
            }
        }
        return out;
    }

    public static BufferedImage rotateImage(BufferedImage bi, boolean right) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        BufferedImage biFlip = new BufferedImage(height, width, 1);
        if (!right) {
            for (int i2 = 0; i2 < width; ++i2) {
                for (int j2 = 0; j2 < height; ++j2) {
                    biFlip.setRGB(j2, width - i2 - 1, bi.getRGB(i2, j2));
                }
            }
        } else {
            for (int i3 = 0; i3 < width; ++i3) {
                for (int j3 = 0; j3 < height; ++j3) {
                    biFlip.setRGB(height - 1 - j3, i3, bi.getRGB(i3, j3));
                }
            }
        }
        return biFlip;
    }

    public static BufferedImage rotateImageOld(BufferedImage source, boolean right) {
        try {
            ImageIO.write((RenderedImage)source, "jpg", new File("SourceRotate.jpg"));
        }
        catch (IOException E) {
            // empty catch block
        }
        BufferedImage image = new BufferedImage(source.getHeight(), source.getWidth(), 1);
        Graphics2D g2 = image.createGraphics();
        g2.drawImage((Image)source, 0, 0, null);
        try {
            ImageIO.write((RenderedImage)image, "jpg", new File("OutRotatepre.jpg"));
        }
        catch (IOException E) {
            // empty catch block
        }
        if (right) {
            g2.rotate(Math.toRadians(90.0));
        } else {
            g2.rotate(Math.toRadians(-90.0));
        }
        g2.drawRenderedImage(source, AffineTransform.getRotateInstance(Math.toRadians(-90.0)));
        try {
            ImageIO.write((RenderedImage)image, "jpg", new File("OutRotate.jpg"));
        }
        catch (IOException E) {
            // empty catch block
        }
        return image;
    }

    public static BufferedImage sharpImage(BufferedImage source) {
        BufferedImage out = null;
        SharpenFilter sf = new SharpenFilter();
        out = sf.createCompatibleDestImage(source, null);
        sf.filter(source, out);
        return out;
    }

    public static BufferedImage ditherImage(BufferedImage source, int colors, boolean bw) {
        BufferedImage out = null;
        DiffusionFilter f2 = new DiffusionFilter();
        if (colors > 255) {
            colors = 255;
        }
        f2.setLevels(colors);
        f2.setColorDither(!bw);
        f2.setSerpentine(true);
        out = f2.createCompatibleDestImage(source, null);
        f2.filter(source, out);
        return out;
    }

    public static BufferedImage doubleSize(BufferedImage source) {
        BufferedImage appo = new BufferedImage(source.getWidth() * 2, source.getHeight() * 2, 1);
        Graphics2D g2 = appo.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g2.drawImage(source, 0, 0, source.getWidth() * 2, source.getHeight() * 2, null);
        return appo;
    }

    public static Image Resize(BufferedImage source, int width, int height) {
        if (source.getWidth() < width || source.getHeight() < height) {
            BufferedImage appo = JECImageFilters.doubleSize(source);
            return appo.getScaledInstance(width, height, 4);
        }
        return source.getScaledInstance(width, height, 4);
    }

    public static BufferedImage filterImageBC(BufferedImage source, float contrast, float brightness) {
        BufferedImage out = null;
        ContrastFilter cf = new ContrastFilter();
        out = cf.createCompatibleDestImage(source, null);
        cf.setContrast(contrast);
        cf.setBrightness(brightness);
        cf.filter(source, out);
        return out;
    }

    public static BufferedImage smartBlur(BufferedImage source) {
        BufferedImage out = null;
        SmartBlurFilter f2 = new SmartBlurFilter();
        f2.setRadius(4);
        f2.setThreshold(8);
        out = f2.createCompatibleDestImage(source, null);
        f2.filter(source, out);
        return out;
    }

    public static BufferedImage split(BufferedImage source, boolean isfirst) {
        int w = source.getWidth() / 2;
        int h2 = source.getHeight();
        int x = isfirst ? 0 : w;
        BufferedImage out = new BufferedImage(w, h2, 1);
        Graphics2D g2 = out.createGraphics();
        g2.setColor(new Color(255, 255, 255));
        g2.draw(new Rectangle(0, 0, w, h2));
        g2.fill(new Rectangle(0, 0, w, h2));
        g2.drawImage(source, 0, 0, w, h2, x, 0, x + w, h2, null);
        g2.dispose();
        return out;
    }

    public static BufferedImage unsharpImage(BufferedImage source) {
        BufferedImage out = null;
        UnsharpFilter f2 = new UnsharpFilter();
        out = f2.createCompatibleDestImage(source, null);
        f2.filter(source, out);
        return out;
    }
}

