/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.PngConfig;
import com.sixlegs.png.PngConstants;
import com.sixlegs.png.PngException;
import com.sixlegs.png.TextChunk;
import com.sixlegs.png.d;
import com.sixlegs.png.e;
import com.sixlegs.png.h;
import com.sixlegs.png.i;
import com.sixlegs.png.j;
import com.sixlegs.png.m;
import java.awt.Color;
import java.awt.Transparency;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PngImage
implements Transparency {
    private static final PngConfig a = new PngConfig.Builder().build();
    private final PngConfig b;
    private Map c;

    public PngImage() {
        this(a);
    }

    public PngImage(PngConfig pngConfig) {
        this.b = pngConfig;
    }

    public PngConfig getConfig() {
        return this.b;
    }

    public BufferedImage read(File file) throws IOException {
        return this.read(new BufferedInputStream(new FileInputStream(file)), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage read(InputStream inputStream, boolean bl) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("InputStream is null");
        }
        BufferedImage bufferedImage = null;
        h h2 = new h(this);
        try {
            this.c = new HashMap();
            i i2 = new i(inputStream);
            HashSet<Object> hashSet = new HashSet<Object>();
            while (h2.a() != 6) {
                int n2;
                block20: {
                    Object object;
                    n2 = i2.a();
                    h2.a(n2);
                    if (n2 == 1229209940) {
                        if (this.b.getReadLimit() == 2) {
                            object = null;
                            return object;
                        }
                        object = new e(i2, h2);
                        bufferedImage = this.createImage((InputStream)object);
                        if (((e)object).read() != -1) {
                            PngImage.a((InputStream)object, i2.b());
                        }
                        n2 = h2.b();
                    }
                    object = j.a(n2);
                    if (!this.isMultipleOK(n2)) {
                        if (hashSet.contains(object)) {
                            String string = "Multiple " + PngConstants.getChunkName(n2) + " chunks are not allowed";
                            if (PngConstants.isAncillary(n2)) {
                                throw new PngException(string, false);
                            }
                            throw new PngException(string, true);
                        }
                        hashSet.add(object);
                    }
                    if (!this.readChunk(n2, i2, i2.b())) break block20;
                    if (n2 == 1229472850 && this.b.getReadLimit() == 1) {
                        BufferedImage bufferedImage2 = null;
                        return bufferedImage2;
                    }
                }
                try {
                    if (!PngConstants.isAncillary(n2)) {
                        throw new PngException("Critical chunk " + PngConstants.getChunkName(n2) + " cannot be skipped", true);
                    }
                    PngImage.a(i2, i2.b());
                }
                catch (PngException pngException) {
                    if (pngException.isFatal()) {
                        throw pngException;
                    }
                    PngImage.a(i2, i2.b());
                    this.handleWarning(pngException);
                }
                i2.a(n2);
            }
            BufferedImage bufferedImage3 = bufferedImage;
            return bufferedImage3;
        }
        finally {
            if (bl) {
                inputStream.close();
            }
        }
    }

    protected BufferedImage createImage(InputStream inputStream) throws IOException {
        if (this.b.getReadLimit() == 3) {
            return null;
        }
        return m.a(this, inputStream);
    }

    protected boolean handlePass(BufferedImage bufferedImage, int n2) {
        return true;
    }

    protected boolean handleProgress(BufferedImage bufferedImage, float f2) {
        return true;
    }

    protected void handleWarning(PngException pngException) throws PngException {
        if (this.b.getWarningsFatal()) {
            throw pngException;
        }
    }

    public int getWidth() {
        return this.a("width");
    }

    public int getHeight() {
        return this.a("height");
    }

    public int getBitDepth() {
        return this.a("bit_depth");
    }

    public boolean isInterlaced() {
        return this.a("interlace") != 0;
    }

    public int getColorType() {
        return this.a("color_type");
    }

    public int getTransparency() {
        int n2 = this.getColorType();
        return n2 == 6 || n2 == 4 || this.c.containsKey("transparency") || this.c.containsKey("palette_alpha") ? 3 : 1;
    }

    public int getSamples() {
        switch (this.getColorType()) {
            case 4: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 6: {
                return 4;
            }
        }
        return 1;
    }

    public float getGamma() {
        this.a();
        if (this.c.containsKey("gamma")) {
            return ((Number)this.c.get("gamma")).floatValue();
        }
        return this.b.getDefaultGamma();
    }

    public short[] getGammaTable() {
        this.a();
        return PngImage.a(this.getGamma(), this.b.getDisplayExponent(), this.getBitDepth() == 16 && !this.b.getReduce16());
    }

    static short[] a(float f2, float f3, boolean bl) {
        int n2 = 1 << (bl ? 16 : 8);
        short[] sArray = new short[n2];
        double d2 = 1.0 / ((double)f2 * (double)f3);
        for (int i2 = 0; i2 < n2; ++i2) {
            sArray[i2] = (short)(Math.pow((double)i2 / (double)(n2 - 1), d2) * (double)(n2 - 1));
        }
        return sArray;
    }

    public Color getBackground() {
        this.a();
        int[] nArray = (int[])this.c.get("background_rgb");
        if (nArray == null) {
            return null;
        }
        switch (this.getColorType()) {
            case 3: {
                byte[] byArray = (byte[])this.c.get("palette");
                int n2 = nArray[0] * 3;
                return new Color(0xFF & byArray[n2 + 0], 0xFF & byArray[n2 + 1], 0xFF & byArray[n2 + 2]);
            }
            case 0: 
            case 4: {
                int n3 = nArray[0] * 255 / ((1 << this.getBitDepth()) - 1);
                return new Color(n3, n3, n3);
            }
        }
        if (this.getBitDepth() == 16) {
            return new Color(nArray[0] >> 8, nArray[1] >> 8, nArray[2] >> 8);
        }
        return new Color(nArray[0], nArray[1], nArray[2]);
    }

    public Object getProperty(String string) {
        this.a();
        return this.c.get(string);
    }

    public Map getProperties() {
        this.a();
        return this.c;
    }

    public TextChunk getTextChunk(String string) {
        this.a();
        List list = (List)this.getProperty("text_chunks");
        if (string != null && list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                TextChunk textChunk = (TextChunk)iterator.next();
                if (!textChunk.getKeyword().equals(string)) continue;
                return textChunk;
            }
        }
        return null;
    }

    int a(String string) {
        this.a();
        return ((Number)this.c.get(string)).intValue();
    }

    private void a() {
        if (this.c == null) {
            throw new IllegalStateException("Image has not been read");
        }
    }

    protected boolean readChunk(int n2, DataInput dataInput, int n3) throws IOException {
        if (this.b.getReadLimit() == 4 && PngConstants.isAncillary(n2)) {
            switch (n2) {
                case 1732332865: 
                case 1951551059: {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return d.a(n2, dataInput, n3, this);
    }

    protected boolean isMultipleOK(int n2) {
        switch (n2) {
            case 1767135348: 
            case 1934642260: 
            case 1950701684: 
            case 2052348020: {
                return true;
            }
        }
        return false;
    }

    private static void a(InputStream inputStream, long l2) throws IOException {
        for (long i2 = 0L; i2 < l2; i2 += inputStream.skip(l2 - i2)) {
        }
    }
}

