/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import java.awt.Rectangle;

public final class PngConfig {
    public static final int READ_ALL = 0;
    public static final int READ_HEADER = 1;
    public static final int READ_UNTIL_DATA = 2;
    public static final int READ_EXCEPT_DATA = 3;
    public static final int READ_EXCEPT_METADATA = 4;
    final int a;
    final float b;
    final float c;
    final boolean d;
    final boolean e;
    final boolean f;
    final boolean g;
    final Rectangle h;
    final int[] i;
    final boolean j;

    PngConfig(Builder builder) {
        this.a = builder.a;
        this.b = builder.b;
        this.c = builder.c;
        this.d = builder.d;
        this.e = builder.e;
        this.f = builder.f;
        this.g = builder.g;
        this.h = builder.h;
        this.i = builder.i;
        this.j = builder.j;
        if (this.e && (this.getSourceXSubsampling() != 1 || this.getSourceYSubsampling() != 1 || this.getSourceRegion() != null)) {
            throw new IllegalStateException("Progressive rendering cannot be used with source regions or subsampling");
        }
    }

    public boolean getReduce16() {
        return this.f;
    }

    public float getDefaultGamma() {
        return this.b;
    }

    public boolean getGammaCorrect() {
        return this.g;
    }

    public boolean getProgressive() {
        return this.e;
    }

    public float getDisplayExponent() {
        return this.c;
    }

    public int getReadLimit() {
        return this.a;
    }

    public boolean getWarningsFatal() {
        return this.d;
    }

    public Rectangle getSourceRegion() {
        return this.h != null ? new Rectangle(this.h) : null;
    }

    public int getSourceXSubsampling() {
        return this.i[0];
    }

    public int getSourceYSubsampling() {
        return this.i[1];
    }

    public int getSubsamplingXOffset() {
        return this.i[2];
    }

    public int getSubsamplingYOffset() {
        return this.i[3];
    }

    public static final class Builder {
        private static final int[] k = new int[]{1, 1, 0, 0};
        int a = 0;
        float b = 0.45455f;
        float c = 2.2f;
        boolean d;
        boolean e;
        boolean f = true;
        boolean g = true;
        Rectangle h;
        int[] i = k;
        boolean j = false;

        public Builder() {
        }

        public Builder(PngConfig pngConfig) {
            this.a = pngConfig.a;
            this.b = pngConfig.b;
            this.c = pngConfig.c;
            this.d = pngConfig.d;
            this.e = pngConfig.e;
            this.f = pngConfig.f;
            this.g = pngConfig.g;
            this.i = pngConfig.i;
            this.j = pngConfig.j;
        }

        public PngConfig build() {
            return new PngConfig(this);
        }

        public Builder reduce16(boolean bl) {
            this.f = bl;
            return this;
        }

        public Builder defaultGamma(float f2) {
            this.b = f2;
            return this;
        }

        public Builder displayExponent(float f2) {
            this.c = f2;
            return this;
        }

        public Builder gammaCorrect(boolean bl) {
            this.g = bl;
            return this;
        }

        public Builder progressive(boolean bl) {
            this.e = bl;
            return this;
        }

        public Builder readLimit(int n2) {
            this.a = n2;
            return this;
        }

        public Builder warningsFatal(boolean bl) {
            this.d = bl;
            return this;
        }

        public Builder sourceRegion(Rectangle rectangle) {
            if (rectangle != null) {
                if (rectangle.x < 0 || rectangle.y < 0 || rectangle.width <= 0 || rectangle.height <= 0) {
                    throw new IllegalArgumentException("invalid source region: " + rectangle);
                }
                this.h = new Rectangle(rectangle);
            } else {
                this.h = null;
            }
            return this;
        }

        public Builder sourceSubsampling(int n2, int n3, int n4, int n5) {
            if (n2 <= 0 || n3 <= 0 || n4 < 0 || n4 >= n2 || n5 < 0 || n5 >= n3) {
                throw new IllegalArgumentException("invalid subsampling values");
            }
            this.i = new int[]{n2, n3, n4, n5};
            return this;
        }
    }
}

