/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.image.png;

import com.sixlegs.image.png.Chunk_IHDR;
import com.sixlegs.image.png.PngException;
import com.sixlegs.image.png.PngImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

final class UnfilterInputStream
extends InputStream {
    private final Chunk_IHDR header;
    private final int rowSize;
    private final int bpp;
    private final InflaterInputStream infstr;
    private final byte[] prev;
    private final byte[] cur;
    private int nextPass;
    private int rowsLeftInPass;
    private int bytesPerRow;
    private int pullSize;
    private int xc;
    private int xp;
    private int xPtr;
    private byte[] _b = new byte[1];

    UnfilterInputStream(PngImage pngImage, InputStream inputStream) {
        this.header = pngImage.data.header;
        this.infstr = new InflaterInputStream(inputStream, new Inflater(), 8192);
        this.bpp = Math.max(1, this.header.depth * this.header.samples / 8);
        int n2 = this.header.interlacer.getMaxPassWidth();
        int n3 = this.getByteWidth(n2);
        this.rowSize = n3 + this.bpp;
        this.prev = new byte[this.rowSize];
        this.cur = new byte[this.rowSize];
        for (int i2 = 0; i2 < this.rowSize; ++i2) {
            this.cur[i2] = 0;
        }
    }

    private int getByteWidth(int n2) {
        if (this.header.samples == 1) {
            int n3 = n2 * 2;
            int n4 = 16 / this.header.depth;
            return n3 % n4 == 0 ? n3 / n4 : (n3 + n4 - n3 % n4) / n4;
        }
        return n2 * this.header.samples * this.header.depth / 8;
    }

    private int readRow() throws IOException {
        int n2;
        int n3;
        if (this.rowsLeftInPass == 0) {
            while (this.rowsLeftInPass == 0 || this.bytesPerRow == 0) {
                if (this.nextPass >= this.header.interlacer.numPasses()) {
                    return -1;
                }
                this.rowsLeftInPass = this.header.interlacer.getPassHeight(this.nextPass);
                this.bytesPerRow = this.getByteWidth(this.header.interlacer.getPassWidth(this.nextPass));
                ++this.nextPass;
            }
            this.pullSize = this.bytesPerRow + this.bpp;
            for (n3 = 0; n3 < this.pullSize; ++n3) {
                this.prev[n3] = 0;
            }
        }
        --this.rowsLeftInPass;
        n3 = this.infstr.read();
        if (n3 == -1) {
            return -1;
        }
        if (n3 > 4 || n3 < 0) {
            throw new PngException("Bad filter type: " + n3);
        }
        for (int i2 = this.bytesPerRow; i2 > 0; i2 -= n2) {
            n2 = this.infstr.read(this.cur, this.bytesPerRow - i2 + this.bpp, i2);
            if (n2 != -1) continue;
            return -1;
        }
        switch (n3) {
            case 0: {
                break;
            }
            case 1: {
                this.xc = this.bpp;
                this.xp = 0;
                while (this.xc < this.rowSize) {
                    this.cur[this.xc] = (byte)(this.cur[this.xc] + this.cur[this.xp]);
                    ++this.xc;
                    ++this.xp;
                }
                break;
            }
            case 2: {
                this.xc = this.bpp;
                this.xp = 0;
                while (this.xc < this.rowSize) {
                    this.cur[this.xc] = (byte)(this.cur[this.xc] + this.prev[this.xc]);
                    ++this.xc;
                    ++this.xp;
                }
                break;
            }
            case 3: {
                this.xc = this.bpp;
                this.xp = 0;
                while (this.xc < this.rowSize) {
                    this.cur[this.xc] = (byte)(this.cur[this.xc] + ((0xFF & this.cur[this.xp]) + (0xFF & this.prev[this.xc])) / 2);
                    ++this.xc;
                    ++this.xp;
                }
                break;
            }
            case 4: {
                this.xc = this.bpp;
                this.xp = 0;
                while (this.xc < this.rowSize) {
                    this.cur[this.xc] = (byte)(this.cur[this.xc] + this.Paeth(this.cur[this.xp], this.prev[this.xc], this.prev[this.xp]));
                    ++this.xc;
                    ++this.xp;
                }
                break;
            }
            default: {
                throw new PngException("unrecognized filter type " + n3);
            }
        }
        System.arraycopy(this.cur, 0, this.prev, 0, this.rowSize);
        return 0;
    }

    private int Paeth(byte by, byte by2, byte by3) {
        int n2;
        int n3;
        int n4 = 0xFF & by;
        int n5 = 0xFF & by2;
        int n6 = 0xFF & by3;
        int n7 = n4 + n5 - n6;
        int n8 = n7 - n4;
        if (n8 < 0) {
            n8 = -n8;
        }
        if ((n3 = n7 - n5) < 0) {
            n3 = -n3;
        }
        if ((n2 = n7 - n6) < 0) {
            n2 = -n2;
        }
        if (n8 <= n3 && n8 <= n2) {
            return n4;
        }
        if (n3 <= n2) {
            return n5;
        }
        return n6;
    }

    public int read() throws IOException {
        return this.read(this._b, 0, 1) > 0 ? this._b[0] & 0xFF : -1;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        while (n3 > 0) {
            if (this.xPtr == 0) {
                if (this.readRow() == -1) {
                    return n4 == 0 ? -1 : n4;
                }
                this.xPtr = this.bpp;
            }
            int n5 = Math.min(n3, this.pullSize - this.xPtr);
            System.arraycopy(this.cur, this.xPtr, byArray, n2, n5);
            n4 += n5;
            this.xPtr = (this.xPtr + n5) % this.pullSize;
            n2 += n5;
            n3 -= n5;
        }
        return n4;
    }

    public void close() throws IOException {
        this.infstr.close();
    }
}

