/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.image.png;

import com.sixlegs.image.png.Chunk;
import com.sixlegs.image.png.PngExceptionSoft;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

abstract class KeyValueChunk
extends Chunk {
    protected String key;
    protected String value;

    KeyValueChunk(int n2) {
        super(n2);
    }

    protected abstract boolean isCompressed();

    protected String getEncoding() {
        return "8859_1";
    }

    protected void readData() throws IOException {
        this.key = this.readKey();
        this.value = this.readValue();
    }

    protected String readKey() throws IOException {
        String string = this.in_data.readString();
        if (string.length() > 79) {
            throw new PngExceptionSoft(Chunk.typeToString(this.type) + " string too long");
        }
        return KeyValueChunk.repairKey(string);
    }

    protected String readValue() throws IOException {
        int n2 = this.bytesRemaining();
        byte[] byArray = new byte[n2];
        this.in_data.readFully(byArray);
        if (this.isCompressed()) {
            byte by = byArray[0];
            if (by != 0) {
                throw new PngExceptionSoft("Unrecognized " + Chunk.typeToString(this.type) + " compression method: " + by);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2 * 3);
            byte[] byArray2 = new byte[512];
            Inflater inflater = new Inflater();
            inflater.reset();
            inflater.setInput(byArray, 1, n2 - 1);
            try {
                while (!inflater.needsInput()) {
                    byteArrayOutputStream.write(byArray2, 0, inflater.inflate(byArray2));
                }
            }
            catch (DataFormatException dataFormatException) {
                throw new PngExceptionSoft("Error inflating " + Chunk.typeToString(this.type) + " chunk: " + dataFormatException);
            }
            return byteArrayOutputStream.toString(this.getEncoding());
        }
        return new String(byArray, 0, n2, this.getEncoding());
    }

    static String repairKey(String string) {
        char[] cArray = string.toCharArray();
        int n2 = 0;
        int n3 = 0;
        int n4 = cArray.length;
        block0: while (n3 < n4) {
            char c2;
            if (Character.isWhitespace(c2 = cArray[n3++])) {
                if (n2 > 0) {
                    cArray[n2++] = 32;
                }
                while (Character.isWhitespace(c2 = cArray[n3++])) {
                    if (n3 != n4) continue;
                    break block0;
                }
            }
            cArray[n2++] = c2;
        }
        if (Character.isWhitespace(cArray[n2 - 1])) {
            --n2;
        }
        return new String(cArray, 0, n2);
    }
}

