/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.image.png;

import com.sixlegs.image.png.Chunk;
import com.sixlegs.image.png.ExDataInputStream;
import com.sixlegs.image.png.PngExceptionSoft;
import java.io.IOException;

final class Chunk_sCAL
extends Chunk {
    Chunk_sCAL() {
        super(Chunk.sCAL);
    }

    protected boolean multipleOK() {
        return false;
    }

    protected boolean beforeIDAT() {
        return true;
    }

    protected void readData() throws IOException {
        int n2 = this.in_data.readUnsignedByte();
        if (n2 != 1 && n2 != 2) {
            throw new PngExceptionSoft("Illegal sCAL chunk unit specifier: " + n2);
        }
        String string = this.in_data.readString();
        int n3 = this.length - string.length() + 2;
        try {
            double d2 = ExDataInputStream.parseFloatingPoint(string);
            double d3 = ExDataInputStream.parseFloatingPoint(this.in_data.readString(n3));
            if (d2 < 0.0 || d3 < 0.0) {
                throw new NumberFormatException();
            }
            this.img.data.properties.put("pixel scale x", new Double(d2));
            this.img.data.properties.put("pixel scale y", new Double(d3));
            this.img.data.properties.put("pixel scale unit", new Integer(n2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new PngExceptionSoft("Bad floating point value in sCAL chunk");
        }
    }
}

