/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.image.png;

import com.sixlegs.image.png.Chunk;
import com.sixlegs.image.png.PngException;
import com.sixlegs.image.png.PngExceptionSoft;
import java.io.IOException;

class Chunk_cHRM
extends Chunk {
    protected long xwlong;
    protected long ywlong;
    protected long xrlong;
    protected long yrlong;
    protected long xglong;
    protected long yglong;
    protected long xblong;
    protected long yblong;
    protected double xw;
    protected double yw;
    protected double xr;
    protected double yr;
    protected double xg;
    protected double yg;
    protected double xb;
    protected double yb;
    protected double Xw;
    protected double Yw;
    protected double Zw;
    protected double Xr;
    protected double Yr;
    protected double Zr;
    protected double Xg;
    protected double Yg;
    protected double Zg;
    protected double Xb;
    protected double Yb;
    protected double Zb;

    Chunk_cHRM() {
        super(Chunk.cHRM);
    }

    protected boolean multipleOK() {
        return false;
    }

    protected boolean beforeIDAT() {
        return true;
    }

    protected void calc() {
        double d2 = 1.0 - (this.xr + this.yr);
        double d3 = 1.0 - (this.xg + this.yg);
        double d4 = 1.0 - (this.xb + this.yb);
        double d5 = 1.0 - (this.xw + this.yw);
        this.Xw = this.xw / this.yw;
        this.Yw = 1.0;
        this.Zw = d5 / this.yw;
        double d6 = this.xr * (this.yg * d4 - d3 * this.yb) - this.xg * (this.yr * d4 - d2 * this.yb) + this.xb * (this.yr * d3 - d2 * this.yg);
        double d7 = (this.Xw * (this.yg * d4 - d3 * this.yb) - this.xg * (d4 - this.Zw * this.yb) + this.xb * (d3 - this.Zw * this.yg)) / d6;
        double d8 = (this.xr * (d4 - this.Zw * this.yb) - this.Xw * (this.yr * d4 - d2 * this.yb) + this.xb * (this.yr * this.Zw - d2)) / d6;
        double d9 = (this.xr * (this.yg * this.Zw - d3) - this.xg * (this.yr * this.Zw - d2) + this.Xw * (this.yr * d3 - d2 * this.yg)) / d6;
        this.Xr = d7 * this.xr;
        this.Yr = d7 * this.yr;
        this.Zr = d7 * d2;
        this.Xg = d8 * this.xg;
        this.Yg = d8 * this.yg;
        this.Zg = d8 * d3;
        this.Xb = d9 * this.xb;
        this.Yb = d9 * this.yb;
        this.Zb = d9 * d4;
        if (this.img.getChunk(Chunk.sRGB) == null) {
            this.img.data.properties.put("chromaticity xy", new long[][]{{this.xwlong, this.ywlong}, {this.xrlong, this.yrlong}, {this.xglong, this.yglong}, {this.xblong, this.yblong}});
            this.img.data.properties.put("chromaticity xyz", new double[][]{{this.Xw, this.Yw, this.Zw}, {this.Xr, this.Yr, this.Zr}, {this.Xg, this.Yg, this.Zg}, {this.Xb, this.Yb, this.Zb}});
        }
    }

    protected void readData() throws IOException {
        if (this.img.data.palette != null) {
            throw new PngException("cHRM chunk must precede PLTE chunk");
        }
        if (this.length != 32) {
            this.badLength(32);
        }
        this.xwlong = this.in_data.readUnsignedInt();
        this.xw = (double)this.xwlong / 100000.0;
        this.checkRange(this.xw, "white");
        this.ywlong = this.in_data.readUnsignedInt();
        this.yw = (double)this.ywlong / 100000.0;
        this.checkRange(this.yw, "white");
        this.xrlong = this.in_data.readUnsignedInt();
        this.xr = (double)this.xrlong / 100000.0;
        this.checkRange(this.xr, "red");
        this.yrlong = this.in_data.readUnsignedInt();
        this.yr = (double)this.yrlong / 100000.0;
        this.checkRange(this.yr, "red");
        this.xglong = this.in_data.readUnsignedInt();
        this.xg = (double)this.xglong / 100000.0;
        this.checkRange(this.xg, "green");
        this.yglong = this.in_data.readUnsignedInt();
        this.yg = (double)this.yglong / 100000.0;
        this.checkRange(this.yg, "green");
        this.xblong = this.in_data.readUnsignedInt();
        this.xb = (double)this.xblong / 100000.0;
        this.checkRange(this.xb, "blue");
        this.yblong = this.in_data.readUnsignedInt();
        this.yb = (double)this.yblong / 100000.0;
        this.checkRange(this.yb, "blue");
        this.calc();
    }

    private void checkRange(double d2, String string) throws PngException {
        if (d2 < 0.0 || d2 > 0.8) {
            throw new PngExceptionSoft("Invalid cHRM " + string + " point");
        }
    }
}

