/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.image.png;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

final class CRCInputStream
extends FilterInputStream {
    private CRC32 crc = new CRC32();
    private int byteCount = 0;
    private byte[] byteArray = new byte[0];

    public CRCInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public long getValue() {
        return this.crc.getValue();
    }

    public void reset() {
        this.byteCount = 0;
        this.crc.reset();
    }

    public int count() {
        return this.byteCount;
    }

    public int read() throws IOException {
        int n2 = this.in.read();
        if (n2 != -1) {
            this.crc.update(n2);
            ++this.byteCount;
        }
        return n2;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.in.read(byArray, n2, n3);
        if (n4 != -1) {
            this.crc.update(byArray, n2, n4);
            this.byteCount += n4;
        }
        return n4;
    }

    public long skip(long l2) throws IOException {
        if ((long)this.byteArray.length < l2) {
            this.byteArray = new byte[(int)l2];
        }
        return this.read(this.byteArray, 0, (int)l2);
    }
}

