/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.codec.TiffImage;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.ImageFilter;
import com.lowagie.tools.arguments.OptionArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class Tiff2Pdf
extends AbstractTool {
    static {
        Tiff2Pdf.addVersion("$Id: Tiff2Pdf.java,v 1.9 2005/11/29 21:05:02 blowagie Exp $");
    }

    public Tiff2Pdf() {
        this.menuoptions = 3;
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to convert", false, new ImageFilter(false, false, false, false, false, true)));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the converted TIFF has to be written", true, new PdfFilter()));
        OptionArgument oa = new OptionArgument(this, "pagesize", "Pagesize");
        oa.addOption("A4", "A4");
        oa.addOption("Letter", "LETTER");
        oa.addOption("Original format", "ORIGINAL");
        this.arguments.add(oa);
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Tiff2Pdf", true, false, true);
        this.internalFrame.setSize(550, 250);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Tiff2Pdf OPENED ===");
    }

    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File tiff_file = (File)this.getValue("srcfile");
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File pdf_file = (File)this.getValue("destfile");
            RandomAccessFileOrArray ra = new RandomAccessFileOrArray(tiff_file.getAbsolutePath());
            int comps = TiffImage.getNumberOfPages(ra);
            boolean adjustSize = false;
            Document document = new Document(PageSize.A4);
            if ("ORIGINAL".equals(this.getValue("pagesize"))) {
                Image img = TiffImage.getTiffImage(ra, 1);
                document.setPageSize(new Rectangle(img.scaledWidth(), img.scaledHeight()));
                adjustSize = true;
            } else if ("LETTER".equals(this.getValue("pagesize"))) {
                document.setPageSize(PageSize.LETTER);
            }
            PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(pdf_file));
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            int c2 = 0;
            while (c2 < comps) {
                Image img = TiffImage.getTiffImage(ra, c2 + 1);
                if (img != null) {
                    if (adjustSize) {
                        document.setPageSize(new Rectangle(img.scaledWidth(), img.scaledHeight()));
                        document.newPage();
                        img.setAbsolutePosition(0.0f, 0.0f);
                    } else {
                        if (img.scaledWidth() > 500.0f || img.scaledHeight() > 700.0f) {
                            img.scaleToFit(500.0f, 700.0f);
                        }
                        img.setAbsolutePosition(20.0f, 20.0f);
                        document.newPage();
                        document.add(new Paragraph(tiff_file + " - page " + (c2 + 1)));
                    }
                    cb.addImage(img);
                    System.out.println("Finished page " + (c2 + 1));
                }
                ++c2;
            }
            ra.close();
            document.close();
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(this.internalFrame, e2.getMessage(), e2.getClass().getName(), 0);
            System.err.println(e2.getMessage());
        }
    }

    public void valueHasChanged(ToolArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] args) {
        Tiff2Pdf tool = new Tiff2Pdf();
        if (args.length < 2) {
            System.err.println(tool.getUsage());
        }
        tool.setArguments(args);
        tool.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }
}

