/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.pdf.PdfEncryptor;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class InspectPDF
extends AbstractTool {
    static /* synthetic */ Class class$0;

    static {
        InspectPDF.addVersion("$Id: InspectPDF.java,v 1.7 2006/09/21 16:45:04 xlv Exp $");
    }

    public InspectPDF() {
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to inspect", false, new PdfFilter()));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.arguments.add(new ToolArgument(this, "ownerpassword", "The owner password if the file is encrypt", clazz.getName()));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Pdf Information", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Pdf Information OPENED ===");
    }

    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            PdfReader reader = this.getValue("ownerpassword") == null ? new PdfReader(((File)this.getValue("srcfile")).getAbsolutePath()) : new PdfReader(((File)this.getValue("srcfile")).getAbsolutePath(), ((String)this.getValue("ownerpassword")).getBytes());
            System.out.println("=== Document Information ===");
            System.out.println("PDF Version: " + reader.getPdfVersion());
            System.out.println("Number of pages: " + reader.getNumberOfPages());
            System.out.println("Number of PDF objects: " + reader.getXrefSize());
            System.out.println("File length: " + reader.getFileLength());
            System.out.println("Encrypted? " + reader.isEncrypted());
            if (reader.isEncrypted()) {
                System.out.println("Permissions: " + PdfEncryptor.getPermissionsVerbose(reader.getPermissions()));
                System.out.println("128 bit? " + reader.is128Key());
            }
            System.out.println("Rebuilt? " + !reader.isRebuilt());
            System.out.println("=== Metadata ===");
            HashMap info = reader.getInfo();
            Iterator i2 = info.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry entry = i2.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                System.out.println(String.valueOf(key) + ": " + value);
            }
            if (reader.getMetadata() == null) {
                System.out.println("There is no XML Metadata in the file");
            } else {
                System.out.println("XML Metadata: " + new String(reader.getMetadata()));
            }
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(this.internalFrame, e2.getMessage(), e2.getClass().getName(), 0);
            System.err.println(e2.getMessage());
        }
    }

    public void valueHasChanged(ToolArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] args) {
        InspectPDF tool = new InspectPDF();
        if (args.length < 1) {
            System.err.println(tool.getUsage());
        }
        tool.setArguments(args);
        tool.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        throw new InstantiationException("There is no file to show.");
    }
}

