/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import java.io.FileOutputStream;

public class handout_pdf {
    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("arguments: srcfile destfile pages");
        } else {
            try {
                int pages = Integer.parseInt(args[2]);
                if (pages < 2 || pages > 8) {
                    throw new DocumentException("You can't have " + pages + " pages on one page (minimum 2; maximum 8).");
                }
                float x1 = 30.0f;
                float x2 = 280.0f;
                float x3 = 320.0f;
                float x4 = 565.0f;
                float[] y1 = new float[pages];
                float[] y2 = new float[pages];
                float height = (778.0f - 20.0f * (float)(pages - 1)) / (float)pages;
                y1[0] = 812.0f;
                y2[0] = 812.0f - height;
                int i2 = 1;
                while (i2 < pages) {
                    y1[i2] = y2[i2 - 1] - 20.0f;
                    y2[i2] = y1[i2] - height;
                    ++i2;
                }
                PdfReader reader = new PdfReader(args[0]);
                int n2 = reader.getNumberOfPages();
                System.out.println("There are " + n2 + " pages in the original file.");
                Document document = new Document(PageSize.A4);
                PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(args[1]));
                document.open();
                PdfContentByte cb = writer.getDirectContent();
                int i3 = 0;
                int p2 = 0;
                while (i3 < n2) {
                    float factory;
                    Rectangle rect;
                    float factorx;
                    float factor = (factorx = (x2 - x1) / (rect = reader.getPageSizeWithRotation(++i3)).width()) < (factory = (y1[p2] - y2[p2]) / rect.height()) ? factorx : factory;
                    float dx = factorx == factor ? 0.0f : (x2 - x1 - rect.width() * factor) / 2.0f;
                    float dy = factory == factor ? 0.0f : (y1[p2] - y2[p2] - rect.height() * factor) / 2.0f;
                    PdfImportedPage page = writer.getImportedPage(reader, i3);
                    int rotation = reader.getPageRotation(i3);
                    if (rotation == 90 || rotation == 270) {
                        cb.addTemplate(page, 0.0f, -factor, factor, 0.0f, x1 + dx, y2[p2] + dy + rect.height() * factor);
                    } else {
                        cb.addTemplate(page, factor, 0.0f, 0.0f, factor, x1 + dx, y2[p2] + dy);
                    }
                    cb.setRGBColorStroke(192, 192, 192);
                    cb.rectangle(x3 - 5.0f, y2[p2] - 5.0f, x4 - x3 + 10.0f, y1[p2] - y2[p2] + 10.0f);
                    float l2 = y1[p2] - 19.0f;
                    while (l2 > y2[p2]) {
                        cb.moveTo(x3, l2);
                        cb.lineTo(x4, l2);
                        l2 -= 16.0f;
                    }
                    cb.rectangle(x1 + dx, y2[p2] + dy, rect.width() * factor, rect.height() * factor);
                    cb.stroke();
                    System.out.println("Processed page " + i3);
                    if (++p2 != pages) continue;
                    p2 = 0;
                    document.newPage();
                }
                document.close();
            }
            catch (Exception e2) {
                System.err.println(String.valueOf(e2.getClass().getName()) + ": " + e2.getMessage());
            }
        }
    }
}

