/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.xml.xmp;

import com.lowagie.text.xml.xmp.XmpArray;
import java.util.Enumeration;
import java.util.Properties;

public abstract class XmpSchema
extends Properties {
    protected String xmlns;

    public XmpSchema(String xmlns) {
        this.xmlns = xmlns;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<?> e2 = this.propertyNames();
        while (e2.hasMoreElements()) {
            this.process(buf, e2.nextElement());
        }
        return buf.toString();
    }

    protected void process(StringBuffer buf, Object p2) {
        buf.append('<');
        buf.append(p2);
        buf.append('>');
        buf.append(this.get(p2));
        buf.append("</");
        buf.append(p2);
        buf.append('>');
    }

    public String getXmlns() {
        return this.xmlns;
    }

    public synchronized Object addProperty(String key, String value) {
        return this.setProperty(key, value);
    }

    public synchronized Object setProperty(String key, String value) {
        return super.setProperty(key, XmpSchema.escape(value));
    }

    public synchronized Object setProperty(String key, XmpArray value) {
        return super.setProperty(key, value.toString());
    }

    public static String escape(String content) {
        StringBuffer buf = new StringBuffer();
        int i2 = 0;
        while (i2 < content.length()) {
            switch (content.charAt(i2)) {
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\'': {
                    buf.append("&apos;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                default: {
                    buf.append(content.charAt(i2));
                }
            }
            ++i2;
        }
        return buf.toString();
    }
}

