/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.graphic.RtfImage;
import com.lowagie.text.rtf.style.RtfFont;
import com.lowagie.text.rtf.style.RtfParagraphStyle;
import com.lowagie.text.rtf.text.RtfPhrase;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfParagraph
extends RtfPhrase {
    public static final byte[] PARAGRAPH = "\\par".getBytes();
    private RtfParagraphStyle paragraphStyle = null;

    public RtfParagraph(RtfDocument doc, Paragraph paragraph) {
        super(doc);
        RtfFont baseFont = null;
        if (paragraph.font() instanceof RtfParagraphStyle) {
            this.paragraphStyle = this.document.getDocumentHeader().getRtfParagraphStyle(((RtfParagraphStyle)paragraph.font()).getStyleName());
            baseFont = this.paragraphStyle;
        } else {
            baseFont = new RtfFont(this.document, paragraph.font());
            this.paragraphStyle = new RtfParagraphStyle(this.document, this.document.getDocumentHeader().getRtfParagraphStyle("Normal"));
            this.paragraphStyle.setAlignment(paragraph.alignment());
            this.paragraphStyle.setIndentLeft((int)((double)paragraph.indentationLeft() * 20.0));
            this.paragraphStyle.setIndentRight((int)((double)paragraph.indentationRight() * 20.0));
            this.paragraphStyle.setSpacingBefore((int)((double)paragraph.spacingBefore() * 20.0));
            this.paragraphStyle.setSpacingAfter((int)((double)paragraph.spacingAfter() * 20.0));
            if (paragraph.leadingDefined()) {
                this.paragraphStyle.setLineLeading((int)((double)paragraph.leading() * 20.0));
            }
            this.paragraphStyle.setKeepTogether(paragraph.getKeepTogether());
        }
        int i2 = 0;
        while (i2 < paragraph.size()) {
            Element chunk = (Element)paragraph.get(i2);
            if (chunk instanceof Chunk) {
                ((Chunk)chunk).setFont(baseFont.difference(((Chunk)chunk).font()));
            } else if (chunk instanceof RtfImage) {
                ((RtfImage)this.chunks.get(i2)).setAlignment(this.paragraphStyle.getAlignment());
            }
            try {
                this.chunks.add(doc.getMapper().mapElement(chunk));
            }
            catch (DocumentException documentException) {
                // empty catch block
            }
            ++i2;
        }
    }

    public void setKeepTogetherWithNext(boolean keepTogetherWithNext) {
        this.paragraphStyle.setKeepTogetherWithNext(keepTogetherWithNext);
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(PARAGRAPH_DEFAULTS);
            if (this.inTable) {
                result.write(IN_TABLE);
            }
            if (this.paragraphStyle != null) {
                result.write(this.paragraphStyle.writeBegin());
            }
            int i2 = 0;
            while (i2 < this.chunks.size()) {
                result.write(((RtfBasicElement)this.chunks.get(i2)).write());
                ++i2;
            }
            if (this.paragraphStyle != null) {
                result.write(this.paragraphStyle.writeEnd());
            }
            if (!this.inTable) {
                result.write(PARAGRAPH);
            }
            if (this.document.getDocumentSettings().isOutputDebugLineBreaks()) {
                result.write(10);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public int getIndentLeft() {
        return this.paragraphStyle.getIndentLeft();
    }

    public void setIndentLeft(int indentLeft) {
        this.paragraphStyle.setIndentLeft(indentLeft);
    }

    public int getIndentRight() {
        return this.paragraphStyle.getIndentRight();
    }

    public void setIndentRight(int indentRight) {
        this.paragraphStyle.setIndentRight(indentRight);
    }
}

