/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.headerfooter;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Table;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.field.RtfPageNumber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfHeaderFooter
extends HeaderFooter
implements RtfBasicElement {
    public static final int TYPE_HEADER = 1;
    public static final int TYPE_FOOTER = 2;
    public static final int DISPLAY_FIRST_PAGE = 0;
    public static final int DISPLAY_ALL_PAGES = 1;
    public static final int DISPLAY_LEFT_PAGES = 2;
    public static final int DISPLAY_RIGHT_PAGES = 4;
    private static final byte[] HEADER_ALL = "\\header".getBytes();
    private static final byte[] HEADER_FIRST = "\\headerf".getBytes();
    private static final byte[] HEADER_LEFT = "\\headerl".getBytes();
    private static final byte[] HEADER_RIGHT = "\\headerr".getBytes();
    private static final byte[] FOOTER_ALL = "\\footer".getBytes();
    private static final byte[] FOOTER_FIRST = "\\footerf".getBytes();
    private static final byte[] FOOTER_LEFT = "\\footerl".getBytes();
    private static final byte[] FOOTER_RIGHT = "\\footerr".getBytes();
    private RtfDocument document = null;
    private Object[] content = null;
    private int type = 1;
    private int displayAt = 1;

    protected RtfHeaderFooter(RtfDocument doc, HeaderFooter headerFooter, int type, int displayAt) {
        super(new Phrase(""), false);
        this.document = doc;
        this.type = type;
        this.displayAt = displayAt;
        Paragraph par = new Paragraph();
        par.setAlignment(headerFooter.alignment());
        if (headerFooter.getBefore() != null) {
            par.add(headerFooter.getBefore());
        }
        if (headerFooter.isNumbered()) {
            par.add(new RtfPageNumber(this.document));
        }
        if (headerFooter.getAfter() != null) {
            par.add(headerFooter.getAfter());
        }
        try {
            this.content = new Object[1];
            if (this.document != null) {
                this.content[0] = this.document.getMapper().mapElement(par);
                ((RtfBasicElement)this.content[0]).setInHeader(true);
            } else {
                this.content[0] = par;
            }
        }
        catch (DocumentException de) {
            de.printStackTrace();
        }
    }

    protected RtfHeaderFooter(RtfDocument doc, RtfHeaderFooter headerFooter, int displayAt) {
        super(new Phrase(""), false);
        this.document = doc;
        this.content = headerFooter.getContent();
        this.displayAt = displayAt;
        int i2 = 0;
        while (i2 < this.content.length) {
            if (this.content[i2] instanceof Element) {
                try {
                    this.content[i2] = this.document.getMapper().mapElement((Element)this.content[i2]);
                }
                catch (DocumentException de) {
                    de.printStackTrace();
                }
            }
            if (this.content[i2] instanceof RtfBasicElement) {
                ((RtfBasicElement)this.content[i2]).setInHeader(true);
            }
            ++i2;
        }
    }

    protected RtfHeaderFooter(RtfDocument doc, HeaderFooter headerFooter) {
        super(new Phrase(""), false);
        this.document = doc;
        Paragraph par = new Paragraph();
        par.setAlignment(headerFooter.alignment());
        if (headerFooter.getBefore() != null) {
            par.add(headerFooter.getBefore());
        }
        if (headerFooter.isNumbered()) {
            par.add(new RtfPageNumber(this.document));
        }
        if (headerFooter.getAfter() != null) {
            par.add(headerFooter.getAfter());
        }
        try {
            this.content = new Object[1];
            this.content[0] = doc.getMapper().mapElement(par);
            ((RtfBasicElement)this.content[0]).setInHeader(true);
        }
        catch (DocumentException de) {
            de.printStackTrace();
        }
    }

    public RtfHeaderFooter(Element element) {
        this(new Element[]{element});
    }

    public RtfHeaderFooter(Element[] elements) {
        super(new Phrase(""), false);
        this.content = new Object[elements.length];
        int i2 = 0;
        while (i2 < elements.length) {
            this.content[i2] = elements[i2];
            ++i2;
        }
    }

    public void setRtfDocument(RtfDocument doc) {
        this.document = doc;
        if (this.document != null) {
            int i2 = 0;
            while (i2 < this.content.length) {
                try {
                    if (this.content[i2] instanceof Element) {
                        this.content[i2] = this.document.getMapper().mapElement((Element)this.content[i2]);
                        ((RtfBasicElement)this.content[i2]).setInHeader(true);
                    } else if (this.content[i2] instanceof RtfBasicElement) {
                        ((RtfBasicElement)this.content[i2]).setRtfDocument(this.document);
                        ((RtfBasicElement)this.content[i2]).setInHeader(true);
                    }
                }
                catch (DocumentException de) {
                    de.printStackTrace();
                }
                ++i2;
            }
        }
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(OPEN_GROUP);
            if (this.type == 1) {
                if (this.displayAt == 1) {
                    result.write(HEADER_ALL);
                } else if (this.displayAt == 0) {
                    result.write(HEADER_FIRST);
                } else if (this.displayAt == 2) {
                    result.write(HEADER_LEFT);
                } else if (this.displayAt == 4) {
                    result.write(HEADER_RIGHT);
                }
            } else if (this.displayAt == 1) {
                result.write(FOOTER_ALL);
            } else if (this.displayAt == 0) {
                result.write(FOOTER_FIRST);
            } else if (this.displayAt == 2) {
                result.write(FOOTER_LEFT);
            } else if (this.displayAt == 4) {
                result.write(FOOTER_RIGHT);
            }
            result.write(DELIMITER);
            int i2 = 0;
            while (i2 < this.content.length) {
                if (this.content[i2] instanceof RtfBasicElement) {
                    result.write(((RtfBasicElement)this.content[i2]).write());
                }
                ++i2;
            }
            result.write(CLOSE_GROUP);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public void setDisplayAt(int displayAt) {
        this.displayAt = displayAt;
    }

    public void setType(int type) {
        this.type = type;
    }

    private Object[] getContent() {
        return this.content;
    }

    public void setInTable(boolean inTable) {
    }

    public void setInHeader(boolean inHeader) {
    }

    public void setAlignment(int alignment) {
        super.setAlignment(alignment);
        int i2 = 0;
        while (i2 < this.content.length) {
            if (this.content[i2] instanceof Paragraph) {
                ((Paragraph)this.content[i2]).setAlignment(alignment);
            } else if (this.content[i2] instanceof Table) {
                ((Table)this.content[i2]).setAlignment(alignment);
            } else if (this.content[i2] instanceof Image) {
                ((Image)this.content[i2]).setAlignment(alignment);
            }
            ++i2;
        }
    }
}

