/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.document;

import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfMapper;
import com.lowagie.text.rtf.document.RtfDocumentHeader;
import com.lowagie.text.rtf.document.RtfDocumentSettings;
import com.lowagie.text.rtf.document.RtfInfoElement;
import com.lowagie.text.rtf.document.output.RtfDataCache;
import com.lowagie.text.rtf.document.output.RtfDiskCache;
import com.lowagie.text.rtf.document.output.RtfMemoryCache;
import com.lowagie.text.rtf.graphic.RtfImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class RtfDocument
extends RtfElement {
    private RtfDataCache data = new RtfMemoryCache();
    private RtfMapper mapper = new RtfMapper(this);
    private RtfDocumentHeader documentHeader = new RtfDocumentHeader(this);
    private ArrayList previousRandomInts = null;
    private boolean autogenerateTOCEntries = false;
    private RtfDocumentSettings documentSettings = null;
    private RtfBasicElement lastElementWritten = null;
    private static final byte[] RTF_DOCUMENT = "\\rtf1".getBytes();

    public RtfDocument() {
        super(null);
        this.documentHeader.init();
        this.previousRandomInts = new ArrayList();
        this.documentSettings = new RtfDocumentSettings(this);
    }

    public void writeDocument(OutputStream out) {
        try {
            out.write(OPEN_GROUP);
            out.write(RTF_DOCUMENT);
            out.write(this.documentHeader.write());
            this.data.writeTo(out);
            out.write(CLOSE_GROUP);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void open() {
        try {
            switch (this.documentSettings.getDataCacheStyle()) {
                case 2: {
                    this.data = new RtfMemoryCache();
                    break;
                }
                case 1: {
                    this.data = new RtfDiskCache();
                }
            }
        }
        catch (IOException ioe) {
            System.err.println("Could not initialise disk cache. Using memory cache.");
            ioe.printStackTrace();
            this.data = new RtfMemoryCache();
        }
    }

    public void add(RtfBasicElement element) {
        try {
            if (element instanceof RtfInfoElement) {
                this.documentHeader.addInfoElement((RtfInfoElement)element);
            } else {
                if (element instanceof RtfImage) {
                    ((RtfImage)element).setTopLevelElement(true);
                }
                this.data.getOutputStream().write(element.write());
                this.lastElementWritten = element;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public RtfMapper getMapper() {
        return this.mapper;
    }

    public int getRandomInt() {
        Integer newInt = null;
        while (this.previousRandomInts.contains(newInt = new Integer((int)(Math.random() * 2.147483647E9)))) {
        }
        this.previousRandomInts.add(newInt);
        return newInt;
    }

    public RtfDocumentHeader getDocumentHeader() {
        return this.documentHeader;
    }

    public String filterSpecialChar(String str, boolean useHex, boolean softLineBreaks) {
        int length = str.length();
        char z = 'z';
        StringBuffer ret = new StringBuffer(length);
        int i2 = 0;
        while (i2 < length) {
            char ch = str.charAt(i2);
            if (ch == '\\') {
                ret.append("\\\\");
            } else if (ch == '\n') {
                if (softLineBreaks) {
                    ret.append("\\line ");
                } else {
                    ret.append("\\par ");
                }
            } else if (ch == '\t') {
                ret.append("\\tab ");
            } else if (ch > z && this.documentSettings.isAlwaysUseUnicode()) {
                if (useHex) {
                    ret.append("\\'").append(Long.toHexString(ch));
                } else {
                    ret.append("\\u").append((long)ch).append('?');
                }
            } else {
                ret.append(ch);
            }
            ++i2;
        }
        String s2 = ret.toString();
        if (s2.indexOf("$newpage$") >= 0) {
            String before = s2.substring(0, s2.indexOf("$newpage$"));
            String after = s2.substring(s2.indexOf("$newpage$") + 9);
            ret = new StringBuffer(before);
            ret.append("\\page\\par ");
            ret.append(after);
            return ret.toString();
        }
        return s2;
    }

    public void setAutogenerateTOCEntries(boolean autogenerate) {
        this.autogenerateTOCEntries = autogenerate;
    }

    public boolean getAutogenerateTOCEntries() {
        return this.autogenerateTOCEntries;
    }

    public RtfDocumentSettings getDocumentSettings() {
        return this.documentSettings;
    }

    public RtfBasicElement getLastElementWritten() {
        return this.lastElementWritten;
    }
}

