/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.hyphenation;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.SimpleXMLDocHandler;
import com.lowagie.text.pdf.SimpleXMLParser;
import com.lowagie.text.pdf.hyphenation.Hyphen;
import com.lowagie.text.pdf.hyphenation.PatternConsumer;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class SimplePatternParser
implements SimpleXMLDocHandler,
PatternConsumer {
    int currElement;
    PatternConsumer consumer;
    StringBuffer token = new StringBuffer();
    ArrayList exception;
    char hyphenChar = (char)45;
    SimpleXMLParser parser;
    static final int ELEM_CLASSES = 1;
    static final int ELEM_EXCEPTIONS = 2;
    static final int ELEM_PATTERNS = 3;
    static final int ELEM_HYPHEN = 4;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(InputStream stream, PatternConsumer consumer) {
        this.consumer = consumer;
        try {
            try {
                SimpleXMLParser.parse((SimpleXMLDocHandler)this, stream);
            }
            catch (IOException e2) {
                throw new ExceptionConverter(e2);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                stream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        stream.close();
    }

    protected static String getPattern(String word) {
        StringBuffer pat = new StringBuffer();
        int len = word.length();
        int i2 = 0;
        while (i2 < len) {
            if (!Character.isDigit(word.charAt(i2))) {
                pat.append(word.charAt(i2));
            }
            ++i2;
        }
        return pat.toString();
    }

    protected ArrayList normalizeException(ArrayList ex) {
        ArrayList<Object> res = new ArrayList<Object>();
        int i2 = 0;
        while (i2 < ex.size()) {
            Object item = ex.get(i2);
            if (item instanceof String) {
                String str = (String)item;
                StringBuffer buf = new StringBuffer();
                int j2 = 0;
                while (j2 < str.length()) {
                    char c2 = str.charAt(j2);
                    if (c2 != this.hyphenChar) {
                        buf.append(c2);
                    } else {
                        res.add(buf.toString());
                        buf.setLength(0);
                        char[] h2 = new char[]{this.hyphenChar};
                        res.add(new Hyphen(new String(h2), null, null));
                    }
                    ++j2;
                }
                if (buf.length() > 0) {
                    res.add(buf.toString());
                }
            } else {
                res.add(item);
            }
            ++i2;
        }
        return res;
    }

    protected String getExceptionWord(ArrayList ex) {
        StringBuffer res = new StringBuffer();
        int i2 = 0;
        while (i2 < ex.size()) {
            Object item = ex.get(i2);
            if (item instanceof String) {
                res.append((String)item);
            } else if (((Hyphen)item).noBreak != null) {
                res.append(((Hyphen)item).noBreak);
            }
            ++i2;
        }
        return res.toString();
    }

    protected static String getInterletterValues(String pat) {
        StringBuffer il = new StringBuffer();
        String word = String.valueOf(pat) + "a";
        int len = word.length();
        int i2 = 0;
        while (i2 < len) {
            char c2 = word.charAt(i2);
            if (Character.isDigit(c2)) {
                il.append(c2);
                ++i2;
            } else {
                il.append('0');
            }
            ++i2;
        }
        return il.toString();
    }

    public void endDocument() {
    }

    public void endElement(String tag) {
        if (this.token.length() > 0) {
            String word = this.token.toString();
            switch (this.currElement) {
                case 1: {
                    this.consumer.addClass(word);
                    break;
                }
                case 2: {
                    this.exception.add(word);
                    this.exception = this.normalizeException(this.exception);
                    this.consumer.addException(this.getExceptionWord(this.exception), (ArrayList)this.exception.clone());
                    break;
                }
                case 3: {
                    this.consumer.addPattern(SimplePatternParser.getPattern(word), SimplePatternParser.getInterletterValues(word));
                    break;
                }
            }
            if (this.currElement != 4) {
                this.token.setLength(0);
            }
        }
        this.currElement = this.currElement == 4 ? 2 : 0;
    }

    public void startDocument() {
    }

    public void startElement(String tag, HashMap h2) {
        if (tag.equals("hyphen-char")) {
            String hh = (String)h2.get("value");
            if (hh != null && hh.length() == 1) {
                this.hyphenChar = hh.charAt(0);
            }
        } else if (tag.equals("classes")) {
            this.currElement = 1;
        } else if (tag.equals("patterns")) {
            this.currElement = 3;
        } else if (tag.equals("exceptions")) {
            this.currElement = 2;
            this.exception = new ArrayList();
        } else if (tag.equals("hyphen")) {
            if (this.token.length() > 0) {
                this.exception.add(this.token.toString());
            }
            this.exception.add(new Hyphen((String)h2.get("pre"), (String)h2.get("no"), (String)h2.get("post")));
            this.currElement = 4;
        }
        this.token.setLength(0);
    }

    public void text(String str) {
        StringTokenizer tk = new StringTokenizer(str);
        while (tk.hasMoreTokens()) {
            String word = tk.nextToken();
            switch (this.currElement) {
                case 1: {
                    this.consumer.addClass(word);
                    break;
                }
                case 2: {
                    this.exception.add(word);
                    this.exception = this.normalizeException(this.exception);
                    this.consumer.addException(this.getExceptionWord(this.exception), (ArrayList)this.exception.clone());
                    this.exception.clear();
                    break;
                }
                case 3: {
                    this.consumer.addPattern(SimplePatternParser.getPattern(word), SimplePatternParser.getInterletterValues(word));
                }
            }
        }
    }

    public void addClass(String c2) {
        System.out.println("class: " + c2);
    }

    public void addException(String w, ArrayList e2) {
        System.out.println("exception: " + w + " : " + e2.toString());
    }

    public void addPattern(String p2, String v) {
        System.out.println("pattern: " + p2 + " : " + v);
    }

    public static void main(String[] args) throws Exception {
        try {
            if (args.length > 0) {
                SimplePatternParser pp = new SimplePatternParser();
                pp.parse(new FileInputStream(args[0]), pp);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

