/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.crypto;

import com.lowagie.text.pdf.crypto.BlockCipherPadding;
import com.lowagie.text.pdf.crypto.InvalidCipherTextException;

public class PKCS7Padding
implements BlockCipherPadding {
    public String getPaddingName() {
        return "PKCS7";
    }

    public int addPadding(byte[] in, int inOff) {
        byte code = (byte)(in.length - inOff);
        while (inOff < in.length) {
            in[inOff] = code;
            ++inOff;
        }
        return code;
    }

    public int padCount(byte[] in) throws InvalidCipherTextException {
        int count = in[in.length - 1] & 0xFF;
        if (count > in.length) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        int i2 = 1;
        while (i2 <= count) {
            if (in[in.length - i2] != count) {
                throw new InvalidCipherTextException("pad block corrupted");
            }
            ++i2;
        }
        return count;
    }
}

