/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XmlDomWriter {
    protected PrintWriter fOut;
    protected boolean fCanonical;
    protected boolean fXML11;

    public XmlDomWriter() {
    }

    public XmlDomWriter(boolean canonical) {
        this.fCanonical = canonical;
    }

    public void setCanonical(boolean canonical) {
        this.fCanonical = canonical;
    }

    public void setOutput(OutputStream stream, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            encoding = "UTF8";
        }
        OutputStreamWriter writer = new OutputStreamWriter(stream, encoding);
        this.fOut = new PrintWriter(writer);
    }

    public void setOutput(Writer writer) {
        this.fOut = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void write(Node node) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                Document document = (Document)node;
                this.fXML11 = false;
                if (!this.fCanonical) {
                    if (this.fXML11) {
                        this.fOut.println("<?xml version=\"1.1\" encoding=\"UTF-8\"?>");
                    } else {
                        this.fOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    }
                    this.fOut.flush();
                    this.write(document.getDoctype());
                }
                this.write(document.getDocumentElement());
                break;
            }
            case 10: {
                DocumentType doctype = (DocumentType)node;
                this.fOut.print("<!DOCTYPE ");
                this.fOut.print(doctype.getName());
                String publicId = doctype.getPublicId();
                String systemId = doctype.getSystemId();
                if (publicId != null) {
                    this.fOut.print(" PUBLIC '");
                    this.fOut.print(publicId);
                    this.fOut.print("' '");
                    this.fOut.print(systemId);
                    this.fOut.print('\'');
                } else if (systemId != null) {
                    this.fOut.print(" SYSTEM '");
                    this.fOut.print(systemId);
                    this.fOut.print('\'');
                }
                String internalSubset = doctype.getInternalSubset();
                if (internalSubset != null) {
                    this.fOut.println(" [");
                    this.fOut.print(internalSubset);
                    this.fOut.print(']');
                }
                this.fOut.println('>');
                break;
            }
            case 1: {
                this.fOut.print('<');
                this.fOut.print(node.getNodeName());
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                int i2 = 0;
                while (i2 < attrs.length) {
                    Attr attr = attrs[i2];
                    this.fOut.print(' ');
                    this.fOut.print(attr.getNodeName());
                    this.fOut.print("=\"");
                    this.normalizeAndPrint(attr.getNodeValue(), true);
                    this.fOut.print('\"');
                    ++i2;
                }
                this.fOut.print('>');
                this.fOut.flush();
                Node child = node.getFirstChild();
                while (child != null) {
                    this.write(child);
                    child = child.getNextSibling();
                }
                break;
            }
            case 5: {
                if (this.fCanonical) {
                    Node child = node.getFirstChild();
                    while (child != null) {
                        this.write(child);
                        child = child.getNextSibling();
                    }
                    break;
                }
                this.fOut.print('&');
                this.fOut.print(node.getNodeName());
                this.fOut.print(';');
                this.fOut.flush();
                break;
            }
            case 4: {
                if (this.fCanonical) {
                    this.normalizeAndPrint(node.getNodeValue(), false);
                } else {
                    this.fOut.print("<![CDATA[");
                    this.fOut.print(node.getNodeValue());
                    this.fOut.print("]]>");
                }
                this.fOut.flush();
                break;
            }
            case 3: {
                this.normalizeAndPrint(node.getNodeValue(), false);
                this.fOut.flush();
                break;
            }
            case 7: {
                this.fOut.print("<?");
                this.fOut.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    this.fOut.print(' ');
                    this.fOut.print(data);
                }
                this.fOut.print("?>");
                this.fOut.flush();
                break;
            }
            case 8: {
                if (this.fCanonical) break;
                this.fOut.print("<!--");
                String comment = node.getNodeValue();
                if (comment != null && comment.length() > 0) {
                    this.fOut.print(comment);
                }
                this.fOut.print("-->");
                this.fOut.flush();
            }
        }
        if (type == 1) {
            this.fOut.print("</");
            this.fOut.print(node.getNodeName());
            this.fOut.print('>');
            this.fOut.flush();
        }
    }

    protected Attr[] sortAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        int i2 = 0;
        while (i2 < len) {
            array[i2] = (Attr)attrs.item(i2);
            ++i2;
        }
        i2 = 0;
        while (i2 < len - 1) {
            String name = array[i2].getNodeName();
            int index = i2;
            int j2 = i2 + 1;
            while (j2 < len) {
                String curName = array[j2].getNodeName();
                if (curName.compareTo(name) < 0) {
                    name = curName;
                    index = j2;
                }
                ++j2;
            }
            if (index != i2) {
                Attr temp = array[i2];
                array[i2] = array[index];
                array[index] = temp;
            }
            ++i2;
        }
        return array;
    }

    protected void normalizeAndPrint(String s2, boolean isAttValue) {
        int len = s2 != null ? s2.length() : 0;
        int i2 = 0;
        while (i2 < len) {
            char c2 = s2.charAt(i2);
            this.normalizeAndPrint(c2, isAttValue);
            ++i2;
        }
    }

    protected void normalizeAndPrint(char c2, boolean isAttValue) {
        switch (c2) {
            case '<': {
                this.fOut.print("&lt;");
                break;
            }
            case '>': {
                this.fOut.print("&gt;");
                break;
            }
            case '&': {
                this.fOut.print("&amp;");
                break;
            }
            case '\"': {
                if (isAttValue) {
                    this.fOut.print("&quot;");
                    break;
                }
                this.fOut.print("\"");
                break;
            }
            case '\r': {
                this.fOut.print("&#xD;");
                break;
            }
            case '\n': {
                if (this.fCanonical) {
                    this.fOut.print("&#xA;");
                    break;
                }
            }
            default: {
                if (this.fXML11 && (c2 >= '\u0001' && c2 <= '\u001f' && c2 != '\t' && c2 != '\n' || c2 >= '\u007f' && c2 <= '\u009f' || c2 == '\u2028') || isAttValue && (c2 == '\t' || c2 == '\n')) {
                    this.fOut.print("&#x");
                    this.fOut.print(Integer.toHexString(c2).toUpperCase());
                    this.fOut.print(";");
                    break;
                }
                this.fOut.print(c2);
            }
        }
    }
}

